/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Function;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.AlphanumComparator;

public final class OsmPrimitiveComparator {
    public static Comparator<OsmPrimitive> comparingNames() {
        Comparator<String> comparator = Comparator.comparing(string -> Character.isDigit(string.charAt(0)) ? 1 : 0);
        return Comparator.comparing(OsmPrimitiveComparator.memoize(DefaultNameFormatter.getInstance()::format), comparator.thenComparing(AlphanumComparator.getInstance()));
    }

    public static Comparator<OsmPrimitive> comparingUniqueId() {
        return Comparator.comparing(AbstractPrimitive::getUniqueId);
    }

    public static Comparator<OsmPrimitive> orderingNodesWaysRelations() {
        return Comparator.comparingInt(osmPrimitive -> osmPrimitive.getType().ordinal());
    }

    public static Comparator<OsmPrimitive> orderingWaysRelationsNodes() {
        return Comparator.comparingInt(osmPrimitive -> {
            switch (osmPrimitive.getType()) {
                case WAY: {
                    return 1;
                }
                case RELATION: {
                    return 2;
                }
                case NODE: {
                    return 3;
                }
            }
            throw new IllegalStateException();
        });
    }

    private static <T, R> Function<T, R> memoize(Function<T, R> function) {
        HashMap hashMap = new HashMap();
        return object -> hashMap.computeIfAbsent(object, function);
    }

    private OsmPrimitiveComparator() {
    }
}

