/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class LongSegment
extends Test {
    protected static final int LONG_SEGMENT = 3501;
    protected int maxlength;

    public LongSegment() {
        super(I18n.tr("Long segments", new Object[0]), I18n.tr("This tests for long way segments, which are usually errors.", new Object[0]));
    }

    @Override
    public void visit(Way way) {
        if (way.hasTag("route", "ferry")) {
            return;
        }
        Double d = way.getLongestSegmentLength();
        if (d > (double)this.maxlength) {
            d = d / 1000.0;
            this.errors.add(TestError.builder(this, Severity.WARNING, 3501).message(I18n.tr("Long segments", new Object[0]), I18n.marktr("Very long segment of {0} kilometers"), d.intValue()).primitives(way).build());
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.maxlength = Main.pref.getInteger("validator.maximum.segment.length", 15000);
    }

    @Override
    public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
        return osmPrimitive.isUsable() && osmPrimitive instanceof Way && ((Way)osmPrimitive).getNodesCount() > 1;
    }
}

