/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.tools.Pair;

public final class TagConflictResolutionUtil {
    private static final String KEY_SOURCE = "source";
    private static final String GRP_FR_CADASTRE = "FR:cadastre";
    private static final String GRP_CA_CANVEC = "CA:canvec";
    private static final Collection<AutomaticCombine> defaultAutomaticTagConflictCombines = Arrays.asList(new AutomaticCombine("tiger:tlid", "US TIGER tlid", false, ":", "Integer"), new AutomaticCombine("tiger:(?!tlid$).*", "US TIGER not tlid", true, ":", "String"));
    private static final Collection<AutomaticChoice> defaultAutomaticTagConflictChoices = Arrays.asList(new AutomaticChoice("source", "FR:cadastre", "FR cadastre source, manual value", true, "cadastre", "0"), new AutomaticChoice("source", "FR:cadastre", "FR cadastre source, initial format", true, "extraction vectorielle v1 cadastre-dgi-fr source : Direction G[e\u00e9]n[e\u00e9]rale des Imp[o\u00f4]ts - Cadas\\. Mise [a\u00e0] jour : (2[0-9]{3})", "$1 1"), new AutomaticChoice("source", "FR:cadastre", "FR cadastre source, last format", true, "(?:cadastre-dgi-fr source : )?Direction G[e\u00e9]n[e\u00e9]rale des (?:Imp[o\u00f4]ts|Finances Publiques) - Cadas(?:tre)?(?:\\.| ;) [Mm]ise [a\u00e0] jour : (2[0-9]{3})", "$1 2"), new AutomaticChoice("source", "CA:canvec", "CA canvec source, initial value", true, "CanVec_Import_2009", "00"), new AutomaticChoice("source", "CA:canvec", "CA canvec source, 4.0/6.0 value", true, "CanVec ([1-9]).0 - NRCan", "0$1"), new AutomaticChoice("source", "CA:canvec", "CA canvec source, 7.0/8.0 value", true, "NRCan-CanVec-([1-9]).0", "0$1"), new AutomaticChoice("source", "CA:canvec", "CA canvec source, 10.0/12.0 value", true, "NRCan-CanVec-(1[012]).0", "$1"));
    private static volatile Collection<AutomaticTagConflictResolver> automaticTagConflictResolvers;

    private TagConflictResolutionUtil() {
    }

    public static void normalizeTagCollectionBeforeEditing(TagCollection tagCollection, Collection<? extends OsmPrimitive> collection) {
        for (String iterator : OsmPrimitive.getDiscardableKeys()) {
            tagCollection.removeByKey(iterator);
        }
        ArrayList arrayList = new ArrayList();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!osmPrimitive.isTagged()) continue;
            arrayList.add(osmPrimitive);
        }
        if (arrayList.size() <= 1) {
            return;
        }
        for (String string : tagCollection.getKeys()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                OsmPrimitive osmPrimitive = (OsmPrimitive)iterator.next();
                if (osmPrimitive.get(string) != null) continue;
                tagCollection.add(new Tag(string, ""));
            }
        }
    }

    public static void completeTagCollectionForEditing(TagCollection tagCollection) {
        for (String string : tagCollection.getKeys()) {
            tagCollection.add(new Tag(string, ""));
        }
    }

    public static void applyAutomaticTagConflictResolution(TagCollection tagCollection) {
        TagConflictResolutionUtil.applyAutomaticTagConflictResolution(tagCollection, TagConflictResolutionUtil.getAutomaticTagConflictResolvers());
    }

    public static Collection<AutomaticTagConflictResolver> getAutomaticTagConflictResolvers() {
        if (automaticTagConflictResolvers == null) {
            List<AutomaticCombine> list = Main.pref.getListOfStructs("automatic-tag-conflict-resolution.combine", defaultAutomaticTagConflictCombines, AutomaticCombine.class);
            Collection<AutomaticChoiceGroup> collection = AutomaticChoiceGroup.groupChoices(Main.pref.getListOfStructs("automatic-tag-conflict-resolution.choice", defaultAutomaticTagConflictChoices, AutomaticChoice.class));
            ArrayList<AutomaticTagConflictResolver> arrayList = new ArrayList<AutomaticTagConflictResolver>();
            arrayList.addAll(list);
            arrayList.addAll(collection);
            automaticTagConflictResolvers = arrayList;
        }
        return Collections.unmodifiableCollection(automaticTagConflictResolvers);
    }

    public static void applyAutomaticTagConflictResolution(TagCollection tagCollection, Collection<AutomaticTagConflictResolver> collection) {
        block2: for (String string : tagCollection.getKeysWithMultipleValues()) {
            for (AutomaticTagConflictResolver automaticTagConflictResolver : collection) {
                try {
                    String string2;
                    if (!automaticTagConflictResolver.matchesKey(string) || (string2 = automaticTagConflictResolver.resolve(tagCollection.getValues(string))) == null) continue;
                    tagCollection.setUniqueForKey(string, string2);
                    continue block2;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    Main.error(patternSyntaxException);
                }
            }
        }
    }

    public static class AutomaticChoiceGroup
    implements AutomaticTagConflictResolver {
        @Preferences.pref
        public String key;
        final String group;
        @Preferences.pref
        public boolean isRegex;
        final List<AutomaticChoice> choices;

        public AutomaticChoiceGroup(String string, String string2, boolean bl, List<AutomaticChoice> list) {
            this.key = string;
            this.group = string2;
            this.isRegex = bl;
            this.choices = list;
        }

        public static Collection<AutomaticChoiceGroup> groupChoices(Collection<AutomaticChoice> collection) {
            HashMap<Pair<String, String>, AutomaticChoiceGroup> hashMap = new HashMap<Pair<String, String>, AutomaticChoiceGroup>();
            for (AutomaticChoice automaticChoice : collection) {
                Pair<String, String> pair = new Pair<String, String>(automaticChoice.key, automaticChoice.group);
                AutomaticChoiceGroup automaticChoiceGroup = (AutomaticChoiceGroup)hashMap.get(pair);
                if (automaticChoiceGroup == null) {
                    boolean bl = automaticChoice.isRegex && !Pattern.quote(automaticChoice.key).equals(automaticChoice.key);
                    automaticChoiceGroup = new AutomaticChoiceGroup(automaticChoice.key, automaticChoice.group, bl, new ArrayList<AutomaticChoice>());
                    hashMap.put(pair, automaticChoiceGroup);
                }
                automaticChoiceGroup.choices.add(automaticChoice);
            }
            return hashMap.values();
        }

        @Override
        public boolean matchesKey(String string) {
            if (this.isRegex) {
                return Pattern.matches(this.key, string);
            }
            return this.key.equals(string);
        }

        @Override
        public String resolve(Set<String> set) {
            String string = "";
            String string2 = "";
            for (String string3 : set) {
                String string4 = null;
                for (AutomaticChoice automaticChoice : this.choices) {
                    if (!automaticChoice.matchesValue(string3)) continue;
                    string4 = automaticChoice.computeScoreFromValue(string3);
                }
                if (string4 == null) {
                    return null;
                }
                if (string4.compareTo(string) < 0) continue;
                string = string4;
                string2 = string3;
            }
            return string2;
        }

        public String toString() {
            Collection collection = this.choices.stream().map(AutomaticChoice::toString).collect(Collectors.toCollection(ArrayList::new));
            return AutomaticChoiceGroup.class.getSimpleName() + "(key='" + this.key + "', group='" + this.group + "', isRegex=" + this.isRegex + ", choices=(\n  " + String.join((CharSequence)",\n  ", collection) + "))";
        }
    }

    public static class AutomaticChoice {
        @Preferences.pref
        public String key;
        @Preferences.pref
        public String group;
        @Preferences.pref
        public String description = "";
        @Preferences.pref
        public boolean isRegex;
        @Preferences.pref
        public String value;
        @Preferences.pref
        public String score;

        public AutomaticChoice() {
        }

        public AutomaticChoice(String string, String string2, String string3, boolean bl, String string4, String string5) {
            this.key = string;
            this.group = string2;
            this.description = string3;
            this.isRegex = bl;
            this.value = string4;
            this.score = string5;
        }

        public boolean matchesValue(String string) {
            if (this.isRegex) {
                return Pattern.matches(this.value, string);
            }
            return this.value.equals(string);
        }

        public String computeScoreFromValue(String string) {
            if (this.isRegex) {
                return string.replaceAll("^" + this.value + "$", this.score);
            }
            return this.score;
        }

        public String toString() {
            return AutomaticChoice.class.getSimpleName() + "(key='" + this.key + "', group='" + this.group + "', description='" + this.description + "', isRegex=" + this.isRegex + ", value='" + this.value + "', score='" + this.score + "')";
        }
    }

    public static class AutomaticCombine
    implements AutomaticTagConflictResolver {
        @Preferences.pref
        public String key;
        @Preferences.pref
        public String description = "";
        @Preferences.pref
        public boolean isRegex;
        @Preferences.pref
        public String separator = ";";
        @Preferences.pref
        public String sort;

        public AutomaticCombine() {
        }

        public AutomaticCombine(String string, String string2, boolean bl, String string3, String string4) {
            this.key = string;
            this.description = string2;
            this.isRegex = bl;
            this.separator = string3;
            this.sort = string4;
        }

        @Override
        public boolean matchesKey(String string) {
            if (this.isRegex) {
                return Pattern.matches(this.key, string);
            }
            return this.key.equals(string);
        }

        Set<String> instantiateSortedSet() {
            if ("String".equals(this.sort)) {
                return new TreeSet<String>();
            }
            if ("Integer".equals(this.sort)) {
                return new TreeSet<String>((string, string2) -> Long.valueOf(string).compareTo(Long.valueOf(string2)));
            }
            return new LinkedHashSet<String>();
        }

        @Override
        public String resolve(Set<String> set) {
            Set<String> set2 = this.instantiateSortedSet();
            for (String string : set) {
                for (String string2 : string.split(Pattern.quote(this.separator))) {
                    set2.add(string2);
                }
            }
            return String.join((CharSequence)this.separator, set2);
        }

        public String toString() {
            return AutomaticCombine.class.getSimpleName() + "(key='" + this.key + "', description='" + this.description + "', isRegex=" + this.isRegex + ", separator='" + this.separator + "', sort='" + this.sort + "')";
        }
    }

    static interface AutomaticTagConflictResolver {
        public boolean matchesKey(String var1);

        public String resolve(Set<String> var1);
    }
}

