/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.map;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.data.AutosaveTask;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class BackupPreference
implements SubPreferenceSetting {
    private static final BooleanProperty PROP_KEEP_BACKUP = new BooleanProperty("save.keepbackup", false);
    private JCheckBox notification;
    private JCheckBox keepBackup;
    private JCheckBox autosave;
    private final JosmTextField autosaveInterval = new JosmTextField(8);
    private final JosmTextField backupPerLayer = new JosmTextField(8);

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        VerticallyScrollablePanel verticallyScrollablePanel = new VerticallyScrollablePanel(new GridBagLayout());
        verticallyScrollablePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.autosave = new JCheckBox(I18n.tr("Auto save enabled", new Object[0]));
        this.autosave.setSelected(AutosaveTask.PROP_AUTOSAVE_ENABLED.get());
        verticallyScrollablePanel.add((Component)this.autosave, GBC.eol());
        JLabel jLabel = new JLabel(I18n.tr("Auto save interval (seconds)", new Object[0]));
        jLabel.setLabelFor(this.autosaveInterval);
        verticallyScrollablePanel.add((Component)jLabel, GBC.std().insets(60, 0, 0, 0));
        this.autosaveInterval.setText(Integer.toString(AutosaveTask.PROP_INTERVAL.get()));
        this.autosaveInterval.setToolTipText(I18n.tr("Default value: {0}", AutosaveTask.PROP_INTERVAL.getDefaultValue()));
        this.autosaveInterval.setMinimumSize(this.autosaveInterval.getPreferredSize());
        verticallyScrollablePanel.add((Component)this.autosaveInterval, GBC.eol().insets(5, 0, 0, 5));
        JLabel jLabel2 = new JLabel(I18n.tr("Auto saved files per layer", new Object[0]));
        jLabel2.setLabelFor(this.backupPerLayer);
        verticallyScrollablePanel.add((Component)jLabel2, GBC.std().insets(60, 0, 0, 0));
        this.backupPerLayer.setText(Integer.toString(AutosaveTask.PROP_FILES_PER_LAYER.get()));
        this.backupPerLayer.setToolTipText(I18n.tr("Default value: {0}", AutosaveTask.PROP_FILES_PER_LAYER.getDefaultValue()));
        this.backupPerLayer.setMinimumSize(this.backupPerLayer.getPreferredSize());
        verticallyScrollablePanel.add((Component)this.backupPerLayer, GBC.eol().insets(5, 0, 0, 10));
        verticallyScrollablePanel.add((Component)new HtmlPanel(I18n.tr("<i>(Autosave stores the changed data layers in periodic intervals. The backups are saved in JOSM''s preference folder. In case of a crash, JOSM tries to recover the unsaved changes on next start.)</i>", new Object[0])), GBC.eop().fill(2).insets(5, 0, 0, 10));
        verticallyScrollablePanel.add((Component)new JSeparator(), GBC.eop().fill(2));
        this.keepBackup = new JCheckBox(I18n.tr("Keep backup files when saving data layers", new Object[0]));
        this.keepBackup.setSelected(PROP_KEEP_BACKUP.get());
        this.keepBackup.setToolTipText(I18n.tr("When saving, keep backup files ending with a ~", new Object[0]));
        verticallyScrollablePanel.add((Component)this.keepBackup, GBC.eop());
        verticallyScrollablePanel.add((Component)new HtmlPanel(I18n.tr("<i>(JOSM can keep a backup file when saving data layers. It appends ''~'' to the file name and saves it in the same folder.)</i>", new Object[0])), GBC.eop().fill(2).insets(5, 0, 0, 0));
        verticallyScrollablePanel.add((Component)new JSeparator(), GBC.eop().fill(2));
        this.notification = new JCheckBox(I18n.tr("Notification at each save", new Object[0]));
        this.notification.setSelected(AutosaveTask.PROP_NOTIFICATION.get());
        this.notification.setToolTipText(I18n.tr("When saving, display a small notification", new Object[0]));
        verticallyScrollablePanel.add((Component)this.notification, GBC.eop());
        ActionListener actionListener = actionEvent -> {
            boolean bl = this.autosave.isSelected();
            jLabel.setEnabled(bl);
            this.autosaveInterval.setEnabled(bl);
            jLabel2.setEnabled(bl);
            this.backupPerLayer.setEnabled(bl);
        };
        this.autosave.addActionListener(actionListener);
        actionListener.actionPerformed(null);
        verticallyScrollablePanel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        JScrollPane jScrollPane = GuiHelper.embedInVerticalScrollPane(verticallyScrollablePanel);
        preferenceTabbedPane.getMapPreference().addSubTab(this, I18n.tr("File backup", new Object[0]), jScrollPane, I18n.tr("Configure whether to create backup files", new Object[0]));
    }

    @Override
    public boolean ok() {
        boolean bl = false;
        PROP_KEEP_BACKUP.put(this.keepBackup.isSelected());
        bl |= AutosaveTask.PROP_AUTOSAVE_ENABLED.put(this.autosave.isSelected());
        AutosaveTask.PROP_FILES_PER_LAYER.parseAndPut(this.backupPerLayer.getText());
        AutosaveTask.PROP_NOTIFICATION.put(this.notification.isSelected());
        return bl |= AutosaveTask.PROP_INTERVAL.parseAndPut(this.autosaveInterval.getText());
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane preferenceTabbedPane) {
        return preferenceTabbedPane.getMapPreference();
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public BackupPreference createPreferenceSetting() {
            return new BackupPreference();
        }
    }
}

