/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.generator.IndentPrintWriter;
import ch.interlis.ili2c.generator.Interlis1Generator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.BasketType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.View;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public final class XSD22Generator {
    IndentPrintWriter ipw;
    TransferDescription td;
    int numErrors = 0;
    static ResourceBundle rsrc = ResourceBundle.getBundle(Interlis1Generator.class.getName(), Locale.getDefault());

    private XSD22Generator(Writer out, TransferDescription td) {
        this.ipw = new IndentPrintWriter(out);
        this.td = td;
    }

    private void finish() {
        this.ipw.close();
    }

    public static int generate(Writer out, TransferDescription td) {
        XSD22Generator d = new XSD22Generator(out, td);
        d.printXSD(td);
        d.finish();
        return d.numErrors;
    }

    public static String getTransferName(Element elt) {
        if (elt instanceof Model) {
            return elt.getName();
        }
        if (elt instanceof Topic) {
            return elt.getScopedName(null);
        }
        if (elt instanceof Viewable) {
            return elt.getScopedName(null);
        }
        if (elt instanceof Domain) {
            return elt.getScopedName(null);
        }
        if (elt instanceof AttributeDef) {
            return elt.getName();
        }
        if (elt instanceof RoleDef) {
            return elt.getName();
        }
        throw new IllegalArgumentException();
    }

    private void printXSD(TransferDescription td) {
        Topic topic;
        Model model;
        this.ipw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        this.ipw.println("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns=\"http://www.interlis.ch/INTERLIS2.2\" targetNamespace=\"http://www.interlis.ch/INTERLIS2.2\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">");
        this.ipw.indent();
        this.ipw.println("<xsd:annotation>");
        this.ipw.indent();
        this.ipw.print("<xsd:appinfo source=\"http://www.interlis.ch/ili2c/ili2cversion\">");
        this.ipw.print(Main.getVersion());
        this.ipw.println("</xsd:appinfo>");
        this.ipw.unindent();
        this.ipw.println("</xsd:annotation>");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"TRANSFER\" type=\"Transfer\"/>");
        this.ipw.println("<xsd:simpleType name=\"IliID\">");
        this.ipw.indent();
        this.ipw.println("<xsd:restriction base=\"xsd:string\">");
        this.ipw.indent();
        this.ipw.println("<xsd:pattern value=\"x[0-9a-zA-Z]*\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:restriction>");
        this.ipw.unindent();
        this.ipw.println("</xsd:simpleType>");
        this.ipw.println("<xsd:complexType name=\"Transfer\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"HEADERSECTION\" type=\"HeaderSection\"/>");
        this.ipw.println("<xsd:element name=\"DATASECTION\" type=\"DataSection\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.generateAliasTable();
        this.ipw.println("<xsd:complexType name=\"HeaderSection\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"ALIAS\" type=\"Alias\"/>");
        this.ipw.println("<xsd:element name=\"COMMENT\" type=\"xsd:anyType\" minOccurs=\"0\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.println("<xsd:attribute name=\"VERSION\" type=\"xsd:decimal\" use=\"required\" fixed=\"2.2\"/>");
        this.ipw.println("<xsd:attribute name=\"SENDER\" type=\"xsd:string\" use=\"required\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:complexType name=\"Alias\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"ENTRIES\" type=\"Entries\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:complexType name=\"Entries\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:choice maxOccurs=\"unbounded\">");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"TAGENTRY\" type=\"Tagentry\"/>");
        this.ipw.println("<xsd:element name=\"VALENTRY\" type=\"Valentry\"/>");
        this.ipw.println("<xsd:element name=\"DELENTRY\" type=\"Delentry\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:choice>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.println("<xsd:attribute name=\"FOR\" type=\"xsd:string\" use=\"required\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:complexType name=\"Tagentry\">");
        this.ipw.indent();
        this.ipw.println("<xsd:attribute name=\"FROM\" type=\"xsd:string\" use=\"required\"/>");
        this.ipw.println("<xsd:attribute name=\"TO\" type=\"xsd:string\" use=\"required\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:complexType name=\"Valentry\">");
        this.ipw.indent();
        this.ipw.println("<xsd:attribute name=\"ATTR\" type=\"xsd:string\" use=\"required\"/>");
        this.ipw.println("<xsd:attribute name=\"FROM\" type=\"xsd:string\" use=\"required\"/>");
        this.ipw.println("<xsd:attribute name=\"TO\" type=\"xsd:string\" use=\"required\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:complexType name=\"Delentry\">");
        this.ipw.indent();
        this.ipw.println("<xsd:attribute name=\"TAG\" type=\"xsd:string\" use=\"required\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:complexType name=\"BasketValue\">");
        this.ipw.indent();
        this.ipw.println("<xsd:attribute name=\"TOPIC\" type=\"xsd:string\" use=\"required\"/>");
        this.ipw.println("<xsd:attribute name=\"KIND\" type=\"xsd:string\" use=\"required\"/>");
        this.ipw.println("<xsd:attribute name=\"BID\" type=\"IliID\" use=\"required\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:complexType name=\"CoordValue\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"C1\" type=\"xsd:double\"/>");
        this.ipw.println("<xsd:element name=\"C2\" type=\"xsd:double\" minOccurs=\"0\"/>");
        this.ipw.println("<xsd:element name=\"C3\" type=\"xsd:double\" minOccurs=\"0\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:complexType name=\"ArcPoint\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"C1\" type=\"xsd:double\"/>");
        this.ipw.println("<xsd:element name=\"C2\" type=\"xsd:double\"/>");
        this.ipw.println("<xsd:element name=\"C3\" type=\"xsd:double\" minOccurs=\"0\"/>");
        this.ipw.println("<xsd:element name=\"A1\" type=\"xsd:double\"/>");
        this.ipw.println("<xsd:element name=\"A2\" type=\"xsd:double\"/>");
        this.ipw.println("<xsd:element name=\"R\" type=\"xsd:double\" minOccurs=\"0\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:complexType name=\"RoleType\">");
        this.ipw.indent();
        this.ipw.println("<xsd:simpleContent>");
        this.ipw.indent();
        this.ipw.println("<xsd:extension base=\"xsd:string\">");
        this.ipw.indent();
        this.ipw.println("<xsd:attribute name=\"REF\" type=\"IliID\"/>");
        this.ipw.println("<xsd:attribute name=\"EXTREF\" type=\"IliID\"/>");
        this.ipw.println("<xsd:attribute name=\"BID\" type=\"IliID\"/>");
        this.ipw.println("<xsd:attribute name=\"ORDER_POS\" type=\"xsd:positiveInteger\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:extension>");
        this.ipw.unindent();
        this.ipw.println("</xsd:simpleContent>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.ipw.println("<xsd:complexType name=\"DataSection\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:choice minOccurs=\"0\" maxOccurs=\"unbounded\">");
        this.ipw.indent();
        for (Object mObj : td) {
            if (!(mObj instanceof Model) || this.suppressModel((Model)mObj)) continue;
            model = (Model)mObj;
            for (Object tObj : model) {
                if (!(tObj instanceof Topic) || this.suppressTopic((Topic)tObj)) continue;
                topic = (Topic)tObj;
                this.ipw.println("<xsd:element name=\"" + XSD22Generator.getTransferName(topic) + "\" type=\"" + XSD22Generator.getTransferName(topic) + "\"/>");
            }
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:choice>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
        this.declareDomainDef(td.INTERLIS.HALIGNMENT);
        this.declareDomainDef(td.INTERLIS.VALIGNMENT);
        this.declareDomainDef(td.INTERLIS.URI);
        this.declareDomainDef(td.INTERLIS.NAME);
        this.declareDomainDef(td.INTERLIS.INTERLIS_1_DATE);
        this.declareAbstractClassDef(td.INTERLIS.METAOBJECT);
        this.declareAbstractClassDef(td.INTERLIS.METAOBJECT_TRANSLATION);
        this.declareAbstractClassDef(td.INTERLIS.AXIS);
        this.declareAbstractClassDef(td.INTERLIS.REFSYSTEM);
        this.declareAbstractClassDef(td.INTERLIS.COORDSYSTEM);
        this.declareAbstractClassDef(td.INTERLIS.SCALSYSTEM);
        this.declareAbstractClassDef(td.INTERLIS.SIGN);
        for (Object mObj : td) {
            if (!(mObj instanceof Model) || mObj instanceof PredefinedModel) continue;
            model = (Model)mObj;
            for (Object tObj : model) {
                if (tObj instanceof Topic) {
                    topic = (Topic)tObj;
                    this.declareTopic(topic);
                }
                if (tObj instanceof Domain) {
                    this.declareDomainDef((Domain)tObj);
                }
                if (!(tObj instanceof AbstractClassDef)) continue;
                this.declareAbstractClassDef((AbstractClassDef)tObj);
            }
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:schema>");
    }

    private void generateAliasTable() {
        this.ipw.println("<!-- ALIAS TABLE ");
        this.ipw.indent();
        for (Object mObj : this.td) {
            if (!(mObj instanceof Model) || this.suppressModel((Model)mObj)) continue;
            Model model = (Model)mObj;
            this.ipw.println("<ENTRIES FOR=\"" + XSD22Generator.getTransferName(model) + "\">");
            this.ipw.indent();
            Iterator topici = model.iterator();
            HashSet<Viewable> modelelev = new HashSet<Viewable>();
            while (topici.hasNext()) {
                Object tObj = topici.next();
                if (!(tObj instanceof Viewable) || this.suppressViewableInAliasTable((Viewable)tObj)) continue;
                Viewable v = (Viewable)tObj;
                modelelev.add(v);
                this.ipw.println("<TAGENTRY FROM=\"" + XSD22Generator.getTransferName(v) + "\" TO=\"" + XSD22Generator.getTransferName(v) + "\"/>");
                for (Viewable xv : this.sortMetamodelElements(v.getExtensions())) {
                    if (xv == v) continue;
                    if (!this.suppressViewableInAliasTable(xv)) {
                        modelelev.add(xv);
                        this.ipw.println("<TAGENTRY FROM=\"" + XSD22Generator.getTransferName(xv) + "\" TO=\"" + XSD22Generator.getTransferName(v) + "\"/>");
                    }
                    for (Object attro : xv) {
                        AttributeDef attr;
                        if (!(attro instanceof AttributeDef) || (attr = (AttributeDef)attro).getExtending() != null) continue;
                        this.ipw.println("<DELENTRY TAG=\"" + XSD22Generator.getTransferName(xv) + "." + XSD22Generator.getTransferName(attr) + "\"/>");
                    }
                }
            }
            for (Object tObj : model) {
                if (!(tObj instanceof Topic) || this.suppressTopicInAliasTable((Topic)tObj)) continue;
                Topic topic = (Topic)tObj;
                this.ipw.println("<TAGENTRY FROM=\"" + XSD22Generator.getTransferName(topic) + "\" TO=\"" + XSD22Generator.getTransferName(topic) + "\"/>");
                for (Topic xtopic : this.sortMetamodelElements(topic.getExtensions())) {
                    if (xtopic == topic || this.suppressTopicInAliasTable(xtopic)) continue;
                    this.ipw.println("<TAGENTRY FROM=\"" + XSD22Generator.getTransferName(xtopic) + "\" TO=\"" + XSD22Generator.getTransferName(topic) + "\"/>");
                }
                HashSet<Viewable> elev = new HashSet<Viewable>();
                for (Object ele : topic) {
                    if (!(ele instanceof Viewable) || this.suppressViewableInAliasTable((Viewable)ele)) continue;
                    Viewable v = (Viewable)ele;
                    elev.add(v);
                    this.ipw.println("<TAGENTRY FROM=\"" + XSD22Generator.getTransferName(v) + "\" TO=\"" + XSD22Generator.getTransferName(v) + "\"/>");
                    for (Viewable xv : this.sortMetamodelElements(v.getExtensions())) {
                        if (xv == v) continue;
                        if (!this.suppressViewableInAliasTable(xv)) {
                            elev.add(xv);
                            this.ipw.println("<TAGENTRY FROM=\"" + XSD22Generator.getTransferName(xv) + "\" TO=\"" + XSD22Generator.getTransferName(v) + "\"/>");
                        }
                        for (Object attro : xv) {
                            AttributeDef attr;
                            if (!(attro instanceof AttributeDef) || (attr = (AttributeDef)attro).getExtending() != null) continue;
                            this.ipw.println("<DELENTRY TAG=\"" + XSD22Generator.getTransferName(xv) + "." + XSD22Generator.getTransferName(attr) + "\"/>");
                        }
                    }
                }
                for (Topic xtopic : this.sortMetamodelElements(topic.getExtensions())) {
                    if (xtopic == topic || this.suppressTopicInAliasTable(xtopic)) continue;
                    for (Object ele : xtopic) {
                        Viewable v;
                        if (!(ele instanceof Viewable) || this.suppressViewableInAliasTable((Viewable)ele) || elev.contains(v = (Viewable)ele) || modelelev.contains(v)) continue;
                        this.ipw.println("<DELENTRY TAG=\"" + XSD22Generator.getTransferName(v) + "\"/>");
                    }
                }
            }
            this.ipw.unindent();
            this.ipw.println("</ENTRIES>");
        }
        this.ipw.unindent();
        this.ipw.println("    ALIAS TABLE -->");
    }

    private ArrayList sortMetamodelElements(Collection c) {
        ArrayList ret = new ArrayList(c);
        Collections.sort(ret, new Comparator(){

            public int compare(Object o1, Object o2) {
                Element e1 = (Element)o1;
                Element e2 = (Element)o2;
                return e1.getScopedName(null).compareTo(e2.getScopedName(null));
            }
        });
        return ret;
    }

    protected boolean suppressModel(Model model) {
        if (model == null) {
            return true;
        }
        if (model == this.td.INTERLIS) {
            return true;
        }
        return model instanceof TypeModel || model instanceof PredefinedModel;
    }

    protected boolean suppressTopic(Topic topic) {
        if (topic == null) {
            return true;
        }
        return topic.isAbstract();
    }

    protected boolean suppressTopicInAliasTable(Topic topic) {
        return this.suppressTopic(topic);
    }

    protected boolean suppressViewable(Viewable v) {
        Topic topic;
        if (v == null) {
            return true;
        }
        if (v.isAbstract()) {
            return true;
        }
        if (v instanceof AssociationDef) {
            AssociationDef assoc = (AssociationDef)v;
            if (assoc.isLightweight()) {
                return true;
            }
            if (assoc.getDerivedFrom() != null) {
                return true;
            }
        }
        if (v instanceof View && (topic = (Topic)v.getContainer(Topic.class)) != null && !topic.isViewTopic()) {
            return true;
        }
        return v instanceof Table && !((Table)v).isIdentifiable();
    }

    protected boolean suppressViewableInAliasTable(Viewable v) {
        Topic topic;
        if (v == null) {
            return true;
        }
        if (v.isAbstract()) {
            return true;
        }
        return v instanceof View && (topic = (Topic)v.getContainer(Topic.class)) != null && !topic.isViewTopic();
    }

    protected void declareTopic(Topic topic) {
        for (Object e : topic) {
            if (e instanceof Domain) {
                this.declareDomainDef((Domain)e);
            }
            if (!(e instanceof AbstractClassDef)) continue;
            this.declareAbstractClassDef((AbstractClassDef)e);
        }
        this.ipw.println("<xsd:complexType name=\"" + XSD22Generator.getTransferName(topic) + "\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        this.ipw.println("<xsd:choice minOccurs=\"0\" maxOccurs=\"unbounded\">");
        this.ipw.indent();
        for (Object object : topic.getViewables()) {
            if (!(object instanceof Viewable) || this.suppressViewable((Viewable)object)) continue;
            Viewable v = (Viewable)object;
            this.ipw.println("<xsd:element name=\"" + XSD22Generator.getTransferName(v) + "\">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            this.ipw.println("<xsd:complexContent>");
            this.ipw.indent();
            this.ipw.println("<xsd:extension base=\"" + XSD22Generator.getTransferName(v) + "\">");
            this.ipw.indent();
            this.ipw.println("<xsd:attribute name=\"TID\" type=\"IliID\" use=\"required\"/>");
            this.ipw.println("<xsd:attribute name=\"BID\" type=\"IliID\"/>");
            this.ipw.println("<xsd:attribute name=\"OPERATION\" type=\"xsd:string\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:extension>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexContent>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:choice>");
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.println("<xsd:attribute name=\"BID\" type=\"IliID\" use=\"required\"/>");
        this.ipw.println("<xsd:attribute name=\"TOPICS\" type=\"xsd:string\"/>");
        this.ipw.println("<xsd:attribute name=\"KIND\" type=\"xsd:string\"/>");
        this.ipw.println("<xsd:attribute name=\"STARTSTATE\" type=\"xsd:string\"/>");
        this.ipw.println("<xsd:attribute name=\"ENDSTATE\" type=\"xsd:string\"/>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    protected void declareAbstractClassDef(Viewable v) {
        this.ipw.println("<xsd:complexType  name=\"" + XSD22Generator.getTransferName(v) + "\">");
        this.ipw.indent();
        this.ipw.println("<xsd:sequence>");
        this.ipw.indent();
        Iterator<ViewableTransferElement> iter = v.getAttributesAndRoles2();
        while (iter.hasNext()) {
            AssociationDef roleOwner;
            ViewableTransferElement obj = iter.next();
            if (obj.obj instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)obj.obj;
                this.declareAttribute(attr);
            }
            if (!(obj.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj.obj;
            if (!obj.embedded && !((AssociationDef)v).isLightweight()) {
                this.ipw.println("<xsd:element name=\"" + XSD22Generator.getTransferName(role) + "\" type=\"RoleType\"/>");
            }
            if (!obj.embedded || (roleOwner = (AssociationDef)role.getContainer()).getDerivedFrom() != null) continue;
            Cardinality card = role.getCardinality();
            String minOccurs = "";
            if (card.getMinimum() == 0L) {
                minOccurs = " minOccurs=\"0\"";
            }
            this.ipw.println("<xsd:element name=\"" + XSD22Generator.getTransferName(role) + "\"" + minOccurs + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            if (roleOwner.getAttributes().hasNext() || roleOwner.getLightweightAssociations().iterator().hasNext()) {
                this.ipw.println("<xsd:sequence>");
                this.ipw.indent();
                this.ipw.println("<xsd:element name=\"" + XSD22Generator.getTransferName(roleOwner) + "\" type=\"" + XSD22Generator.getTransferName(roleOwner) + "\"/>");
                this.ipw.unindent();
                this.ipw.println("</xsd:sequence>");
            }
            this.ipw.println("<xsd:attribute name=\"REF\" type=\"IliID\"/>");
            this.ipw.println("<xsd:attribute name=\"EXTREF\" type=\"IliID\"/>");
            this.ipw.println("<xsd:attribute name=\"BID\" type=\"IliID\"/>");
            this.ipw.println("<xsd:attribute name=\"ORDER_POS\" type=\"xsd:positiveInteger\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:sequence>");
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    protected void declareDomainDef(Domain domain) {
        this.declareType(domain.getType(), domain);
    }

    protected void declareAttribute(AttributeDef attribute) {
        try {
            Type type;
            String minOccurs = "";
            if (!attribute.getDomain().isMandatoryConsideringAliases()) {
                minOccurs = " minOccurs=\"0\"";
            }
            if ((type = attribute.getDomain()) instanceof TypeAlias) {
                if (((TypeAlias)type).getAliasing() == this.td.INTERLIS.BOOLEAN) {
                    this.ipw.println("<xsd:element name=\"" + XSD22Generator.getTransferName(attribute) + "\" type=\"xsd:boolean\"" + minOccurs + "/>");
                } else {
                    this.ipw.println("<xsd:element name=\"" + XSD22Generator.getTransferName(attribute) + "\" type=\"" + XSD22Generator.getTransferName(((TypeAlias)type).getAliasing()) + "\"" + minOccurs + "/>");
                }
            } else {
                this.ipw.println("<xsd:element name=\"" + XSD22Generator.getTransferName(attribute) + "\"" + minOccurs + ">");
                this.ipw.indent();
                this.declareType(type, null);
                this.ipw.unindent();
                this.ipw.println("</xsd:element>");
            }
        }
        catch (Exception ex) {
            System.err.println(attribute.toString());
            ex.printStackTrace(System.err);
        }
    }

    protected void declareType(Type type, Domain domain) {
        String typeName = "";
        if (domain != null) {
            typeName = " name=\"" + XSD22Generator.getTransferName(domain) + "\"";
        }
        if (type instanceof PolylineType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"POLYLINE\">");
            this.ipw.indent();
            this.declarePolylineValue((PolylineType)type);
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof SurfaceOrAreaType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"SURFACE\">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"BOUNDARY\" maxOccurs=\"unbounded\">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"POLYLINE\" maxOccurs=\"unbounded\">");
            this.ipw.indent();
            this.declarePolylineValue((SurfaceOrAreaType)type);
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof CoordType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"COORD\" type=\"CoordValue\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof CompositionType) {
            Set extv;
            CompositionType composition = (CompositionType)type;
            Table part = composition.getComponentType();
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            Cardinality card = composition.getCardinality();
            String minOccurs = "";
            if (card.getMinimum() > 1L) {
                minOccurs = " minOccurs=\"" + Long.toString(card.getMinimum()) + "\"";
            }
            String maxOccurs = "";
            if (card.getMaximum() != 1L) {
                maxOccurs = card.getMaximum() == Long.MAX_VALUE ? " maxOccurs=\"unbounded\"" : " maxOccurs=\"" + Long.toString(card.getMaximum()) + "\"";
            }
            if ((extv = part.getExtensions()).size() > 1) {
                this.ipw.println("<xsd:choice" + minOccurs + maxOccurs + ">");
                this.ipw.indent();
                for (Table table : extv) {
                    this.ipw.println("<xsd:element name=\"" + XSD22Generator.getTransferName(table) + "\" type=\"" + XSD22Generator.getTransferName(table) + "\"/>");
                }
                this.ipw.unindent();
                this.ipw.println("</xsd:choice>");
            } else {
                this.ipw.println("<xsd:element name=\"" + XSD22Generator.getTransferName(part) + "\" type=\"" + XSD22Generator.getTransferName(part) + "\"" + minOccurs + maxOccurs + "/>");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof ReferenceType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:simpleContent>");
            this.ipw.indent();
            this.ipw.println("<xsd:extension base=\"xsd:string\">");
            this.ipw.indent();
            this.ipw.println("<xsd:attribute name=\"REF\" type=\"IliID\"/>");
            this.ipw.println("<xsd:attribute name=\"EXTREF\" type=\"IliID\"/>");
            this.ipw.println("<xsd:attribute name=\"BID\" type=\"IliID\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:extension>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleContent>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof BasketType) {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"BASKETVALUE\" type=\"BasketValue\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        } else if (type instanceof EnumerationType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:restriction base=\"xsd:string\">");
            this.ipw.indent();
            ArrayList ev = new ArrayList();
            this.buildEnumList(ev, "", ((EnumerationType)type).getConsolidatedEnumeration());
            for (String value : ev) {
                this.ipw.println("<xsd:enumeration value=\"" + value + "\"/>");
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof NumericType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            if (type.isAbstract()) {
                this.ipw.println("<xsd:restriction base=\"xsd:double\">");
                this.ipw.println("</xsd:restriction>");
            } else {
                PrecisionDecimal min = ((NumericType)type).getMinimum();
                if (min.getAccuracy() > 0) {
                    this.ipw.println("<xsd:restriction base=\"xsd:double\">");
                    this.ipw.indent();
                    this.ipw.println("<xsd:minInclusive value=\"" + ((NumericType)type).getMinimum().doubleValue() + "\"/>");
                    this.ipw.println("<xsd:maxInclusive value=\"" + ((NumericType)type).getMaximum().doubleValue() + "\"/>");
                    this.ipw.unindent();
                    this.ipw.println("</xsd:restriction>");
                } else {
                    this.ipw.println("<xsd:restriction base=\"xsd:integer\">");
                    this.ipw.indent();
                    this.ipw.println("<xsd:minInclusive value=\"" + (int)((NumericType)type).getMinimum().doubleValue() + "\"/>");
                    this.ipw.println("<xsd:maxInclusive value=\"" + (int)((NumericType)type).getMaximum().doubleValue() + "\"/>");
                    this.ipw.unindent();
                    this.ipw.println("</xsd:restriction>");
                }
            }
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else if (type instanceof TextType) {
            this.ipw.println("<xsd:simpleType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:restriction base=\"xsd:string\">");
            if (((TextType)type).getMaxLength() > 0) {
                this.ipw.indent();
                this.ipw.println("<xsd:maxLength value=\"" + ((TextType)type).getMaxLength() + "\"/>");
                this.ipw.unindent();
            }
            this.ipw.println("</xsd:restriction>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleType>");
        } else {
            this.ipw.println("<xsd:complexType" + typeName + ">");
            this.ipw.indent();
            this.ipw.println("<xsd:simpleContent>");
            this.ipw.indent();
            this.ipw.println("<xsd:extension base=\"xsd:string\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:simpleContent>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
        }
    }

    private void declarePolylineValue(LineType domain) {
        Table part;
        this.ipw.println("<xsd:complexType>");
        this.ipw.indent();
        boolean hasLineAttr = false;
        if (domain instanceof SurfaceOrAreaType && (part = ((SurfaceOrAreaType)domain).getLineAttributeStructure()) != null) {
            hasLineAttr = true;
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"LINEATTR\">");
            this.ipw.indent();
            this.ipw.println("<xsd:complexType>");
            this.ipw.indent();
            this.ipw.println("<xsd:sequence>");
            this.ipw.indent();
            this.ipw.println("<xsd:element name=\"" + XSD22Generator.getTransferName(part) + "\" type=\"" + XSD22Generator.getTransferName(part) + "\"/>");
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
            this.ipw.unindent();
            this.ipw.println("</xsd:complexType>");
            this.ipw.unindent();
            this.ipw.println("</xsd:element>");
        }
        this.ipw.println("<xsd:choice minOccurs=\"2\" maxOccurs=\"unbounded\">");
        this.ipw.indent();
        this.ipw.println("<xsd:element name=\"COORD\" type=\"CoordValue\"/>");
        HashSet<LineForm> lfv = new HashSet<LineForm>(Arrays.asList(domain.getLineForms()));
        if (lfv.contains(this.td.INTERLIS.ARCS)) {
            this.ipw.println("<xsd:element name=\"ARC\" type=\"ArcPoint\"/>");
        }
        for (LineForm lf : lfv) {
            if (lf == this.td.INTERLIS.ARCS || lf == this.td.INTERLIS.STRAIGHTS) continue;
            Table segmentStruct = lf.getSegmentStructure();
            this.ipw.println("<xsd:element name=\"" + XSD22Generator.getTransferName(segmentStruct) + "\" type=\"" + XSD22Generator.getTransferName(segmentStruct) + "\"/>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:choice>");
        if (hasLineAttr) {
            this.ipw.unindent();
            this.ipw.println("</xsd:sequence>");
        }
        this.ipw.unindent();
        this.ipw.println("</xsd:complexType>");
    }

    private void buildEnumList(List accu, String prefix1, Enumeration enumer) {
        Iterator<Enumeration.Element> iter = enumer.getElements();
        String prefix = "";
        if (prefix1.length() > 0) {
            prefix = prefix1 + ".";
        }
        while (iter.hasNext()) {
            Enumeration.Element ee = iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            if (subEnum != null) {
                this.buildEnumList(accu, prefix + ee.getName(), subEnum);
                continue;
            }
            accu.add(prefix + ee.getName());
        }
    }

    public static HashMap getTagMap(TransferDescription td) {
        HashMap<String, Viewable> ret = new HashMap<String, Viewable>();
        for (Object mObj : td) {
            if (!(mObj instanceof Model)) continue;
            Model model = (Model)mObj;
            for (Object tObj : model) {
                if (tObj instanceof Topic) {
                    Topic topic = (Topic)tObj;
                    for (Viewable<?> obj : topic.getViewables()) {
                        if (!(obj instanceof Viewable)) continue;
                        Viewable<?> v = obj;
                        ret.put(v.getScopedName((Container)null), v);
                    }
                    continue;
                }
                if (!(tObj instanceof Viewable)) continue;
                Viewable v = (Viewable)tObj;
                ret.put(v.getScopedName((Container)null), v);
            }
        }
        return ret;
    }
}

