/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.exception;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.exception.ExceptionLayoutImpl;
import org.jruby.truffle.core.exception.SystemCallErrorLayout;
import org.jruby.truffle.language.backtrace.Backtrace;

@GeneratedBy(value=SystemCallErrorLayout.class)
public class SystemCallErrorLayoutImpl
extends ExceptionLayoutImpl
implements SystemCallErrorLayout {
    public static final SystemCallErrorLayout INSTANCE = new SystemCallErrorLayoutImpl();
    protected static final Shape.Allocator SYSTEM_CALL_ERROR_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey ERRNO_IDENTIFIER;
    protected static final Property ERRNO_PROPERTY;

    protected SystemCallErrorLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createSystemCallErrorShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new SystemCallErrorType(logicalClass, metaClass)).addProperty(MESSAGE_PROPERTY).addProperty(BACKTRACE_PROPERTY).addProperty(ERRNO_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createSystemCallError(DynamicObjectFactory factory, Object message, Backtrace backtrace, Object errno) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (SystemCallErrorLayoutImpl.createsSystemCallError(factory));
        assert (factory.getShape().hasProperty(MESSAGE_IDENTIFIER));
        assert (factory.getShape().hasProperty(BACKTRACE_IDENTIFIER));
        assert (factory.getShape().hasProperty(ERRNO_IDENTIFIER));
        assert (message != null);
        assert (errno != null);
        return factory.newInstance(message, backtrace, errno);
    }

    private static boolean isSystemCallError(DynamicObject object) {
        return SystemCallErrorLayoutImpl.isSystemCallError(object.getShape().getObjectType());
    }

    private static boolean isSystemCallError(ObjectType objectType) {
        return objectType instanceof SystemCallErrorType;
    }

    private static boolean createsSystemCallError(DynamicObjectFactory factory) {
        return SystemCallErrorLayoutImpl.isSystemCallError(factory.getShape().getObjectType());
    }

    @Override
    public Object getErrno(DynamicObject object) {
        assert (SystemCallErrorLayoutImpl.isSystemCallError(object));
        assert (object.getShape().hasProperty(ERRNO_IDENTIFIER));
        return ERRNO_PROPERTY.get(object, SystemCallErrorLayoutImpl.isSystemCallError(object));
    }

    @Override
    public void setErrno(DynamicObject object, Object value) {
        assert (SystemCallErrorLayoutImpl.isSystemCallError(object));
        assert (object.getShape().hasProperty(ERRNO_IDENTIFIER));
        assert (value != null);
        try {
            ERRNO_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static {
        SYSTEM_CALL_ERROR_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull));
        SYSTEM_CALL_ERROR_ALLOCATOR.locationForType(Backtrace.class);
        ERRNO_IDENTIFIER = new HiddenKey("errno");
        ERRNO_PROPERTY = Property.create(ERRNO_IDENTIFIER, SYSTEM_CALL_ERROR_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), 0);
    }

    public static class SystemCallErrorType
    extends ExceptionLayoutImpl.ExceptionType {
        public SystemCallErrorType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public SystemCallErrorType setLogicalClass(DynamicObject logicalClass) {
            return new SystemCallErrorType(logicalClass, this.metaClass);
        }

        @Override
        public SystemCallErrorType setMetaClass(DynamicObject metaClass) {
            return new SystemCallErrorType(this.logicalClass, metaClass);
        }
    }
}

