/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WsFrame;
import org.apache.coyote.http11.upgrade.UpgradeOutbound;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.res.StringManager;

@Deprecated
public class WsOutbound {
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.websocket");
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final Object stateLock = new Object();
    private UpgradeOutbound upgradeOutbound;
    private StreamInbound streamInbound;
    private ByteBuffer bb;
    private CharBuffer cb;
    private boolean closed = false;
    private Boolean text = null;
    private boolean firstFrame = true;

    public WsOutbound(UpgradeOutbound upgradeOutbound, StreamInbound streamInbound) {
        this(upgradeOutbound, streamInbound, 8192, 8192);
    }

    public WsOutbound(UpgradeOutbound upgradeOutbound, StreamInbound streamInbound, int byteBufferSize, int charBufferSize) {
        this.upgradeOutbound = upgradeOutbound;
        this.streamInbound = streamInbound;
        this.bb = ByteBuffer.allocate(byteBufferSize);
        this.cb = CharBuffer.allocate(charBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryData(int b) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    throw new IOException(sm.getString("outbound.closed"));
                }
                if (this.bb.position() == this.bb.capacity()) {
                    this.doFlush(false);
                }
                if (this.text == null) {
                    this.text = Boolean.FALSE;
                } else if (Boolean.TRUE.equals(this.text)) {
                    this.flush();
                    this.text = Boolean.FALSE;
                }
                this.bb.put((byte)(b & 0xFF));
            }
        }
        catch (IOException ioe) {
            this.streamInbound.doOnClose(1006);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTextData(char c) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    throw new IOException(sm.getString("outbound.closed"));
                }
                if (this.cb.position() == this.cb.capacity()) {
                    this.doFlush(false);
                }
                if (this.text == null) {
                    this.text = Boolean.TRUE;
                } else if (Boolean.FALSE.equals(this.text)) {
                    this.flush();
                    this.text = Boolean.TRUE;
                }
                this.cb.append(c);
            }
        }
        catch (IOException ioe) {
            this.streamInbound.doOnClose(1006);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryMessage(ByteBuffer msgBb) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    throw new IOException(sm.getString("outbound.closed"));
                }
                if (this.text != null) {
                    this.flush();
                }
                this.text = Boolean.FALSE;
                this.doWriteBytes(msgBb, true);
            }
        }
        catch (IOException ioe) {
            this.streamInbound.doOnClose(1006);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTextMessage(CharBuffer msgCb) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    throw new IOException(sm.getString("outbound.closed"));
                }
                if (this.text != null) {
                    this.flush();
                }
                this.text = Boolean.TRUE;
                this.doWriteText(msgCb, true);
            }
        }
        catch (IOException ioe) {
            this.streamInbound.doOnClose(1006);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    throw new IOException(sm.getString("outbound.closed"));
                }
                this.doFlush(true);
            }
        }
        catch (IOException ioe) {
            this.streamInbound.doOnClose(1006);
            throw ioe;
        }
    }

    private void doFlush(boolean finalFragment) throws IOException {
        if (this.text == null) {
            return;
        }
        if (this.text.booleanValue()) {
            this.cb.flip();
            this.doWriteText(this.cb, finalFragment);
        } else {
            this.bb.flip();
            this.doWriteBytes(this.bb, finalFragment);
        }
    }

    protected void close(WsFrame frame) throws IOException {
        if (frame.getPayLoadLength() > 0L) {
            if (frame.getPayLoadLength() == 1L) {
                throw new IOException();
            }
            int status = (frame.getPayLoad().get() & 0xFF) << 8;
            if (this.validateCloseStatus(status += frame.getPayLoad().get() & 0xFF)) {
                this.close(status, frame.getPayLoad());
            } else {
                this.close(1002, null);
            }
        } else {
            this.close(0, null);
        }
    }

    private boolean validateCloseStatus(int status) {
        return status == 1000 || status == 1001 || status == 1002 || status == 1003 || status == 1007 || status == 1008 || status == 1009 || status == 1010 || status == 1011 || status > 2999 && status < 5000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int status, ByteBuffer data) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                try {
                    this.doFlush(false);
                }
                finally {
                    this.closed = true;
                }
                this.upgradeOutbound.write(136);
                if (status == 0) {
                    this.upgradeOutbound.write(0);
                } else if (data == null || data.position() == data.limit()) {
                    this.upgradeOutbound.write(2);
                    this.upgradeOutbound.write(status >>> 8);
                    this.upgradeOutbound.write(status);
                } else {
                    this.upgradeOutbound.write(2 + data.limit() - data.position());
                    this.upgradeOutbound.write(status >>> 8);
                    this.upgradeOutbound.write(status);
                    this.upgradeOutbound.write(data.array(), data.position(), data.limit() - data.position());
                }
                this.upgradeOutbound.flush();
                this.bb = null;
                this.cb = null;
                this.upgradeOutbound = null;
            }
        }
        catch (IOException ioe) {
            this.streamInbound.doOnClose(1006);
            throw ioe;
        }
    }

    public void pong(ByteBuffer data) throws IOException {
        this.sendControlMessage(data, (byte)10);
    }

    public void ping(ByteBuffer data) throws IOException {
        this.sendControlMessage(data, (byte)9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendControlMessage(ByteBuffer data, byte opcode) throws IOException {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.closed) {
                    throw new IOException(sm.getString("outbound.closed"));
                }
                this.doFlush(false);
                this.upgradeOutbound.write(0x80 | opcode);
                if (data == null) {
                    this.upgradeOutbound.write(0);
                } else {
                    this.upgradeOutbound.write(data.limit() - data.position());
                    this.upgradeOutbound.write(data.array(), data.position(), data.limit() - data.position());
                }
                this.upgradeOutbound.flush();
            }
        }
        catch (IOException ioe) {
            this.streamInbound.doOnClose(1006);
            throw ioe;
        }
    }

    private void doWriteBytes(ByteBuffer buffer, boolean finalFragment) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("outbound.closed"));
        }
        int first = 0;
        if (finalFragment) {
            first += 128;
        }
        if (this.firstFrame) {
            first = this.text.booleanValue() ? ++first : (first += 2);
        }
        this.upgradeOutbound.write(first);
        if (buffer.limit() < 126) {
            this.upgradeOutbound.write(buffer.limit());
        } else if (buffer.limit() < 65536) {
            this.upgradeOutbound.write(126);
            this.upgradeOutbound.write(buffer.limit() >>> 8);
            this.upgradeOutbound.write(buffer.limit() & 0xFF);
        } else {
            this.upgradeOutbound.write(127);
            this.upgradeOutbound.write(0);
            this.upgradeOutbound.write(0);
            this.upgradeOutbound.write(0);
            this.upgradeOutbound.write(0);
            this.upgradeOutbound.write(buffer.limit() >>> 24);
            this.upgradeOutbound.write(buffer.limit() >>> 16);
            this.upgradeOutbound.write(buffer.limit() >>> 8);
            this.upgradeOutbound.write(buffer.limit() & 0xFF);
        }
        this.upgradeOutbound.write(buffer.array(), buffer.arrayOffset(), buffer.limit());
        this.upgradeOutbound.flush();
        if (finalFragment) {
            this.text = null;
            this.firstFrame = true;
        } else {
            this.firstFrame = false;
        }
        this.bb.clear();
    }

    private void doWriteText(CharBuffer buffer, boolean finalFragment) throws IOException {
        CharsetEncoder encoder = B2CConverter.UTF_8.newEncoder();
        do {
            CoderResult cr;
            if ((cr = encoder.encode(buffer, this.bb, true)).isError()) {
                cr.throwException();
            }
            this.bb.flip();
            if (buffer.hasRemaining()) {
                this.doWriteBytes(this.bb, false);
                continue;
            }
            this.doWriteBytes(this.bb, finalFragment);
        } while (buffer.hasRemaining());
        this.cb.clear();
    }
}

