/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParseFieldMatcherSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.SearchSortValues;
import org.elasticsearch.search.lookup.SourceLookup;

public class InternalSearchHit
implements SearchHit {
    private transient int docId;
    private float score = Float.NEGATIVE_INFINITY;
    private Text id;
    private Text type;
    private InternalNestedIdentity nestedIdentity;
    private long version = -1L;
    private BytesReference source;
    private Map<String, SearchHitField> fields = Collections.emptyMap();
    private Map<String, HighlightField> highlightFields = null;
    private SearchSortValues sortValues = SearchSortValues.EMPTY;
    private String[] matchedQueries = Strings.EMPTY_ARRAY;
    private Explanation explanation;
    @Nullable
    private SearchShardTarget shard;
    private Map<String, Object> sourceAsMap;
    private byte[] sourceAsBytes;
    private Map<String, InternalSearchHits> innerHits;

    private InternalSearchHit() {
    }

    public InternalSearchHit(int docId) {
        this(docId, null, null, null);
    }

    public InternalSearchHit(int docId, String id, Text type, Map<String, SearchHitField> fields) {
        this.docId = docId;
        this.id = id != null ? new Text(id) : null;
        this.type = type;
        this.fields = fields;
    }

    public InternalSearchHit(int nestedTopDocId, String id, Text type, InternalNestedIdentity nestedIdentity, Map<String, SearchHitField> fields) {
        this.docId = nestedTopDocId;
        this.id = new Text(id);
        this.type = type;
        this.nestedIdentity = nestedIdentity;
        this.fields = fields;
    }

    public int docId() {
        return this.docId;
    }

    public void shardTarget(SearchShardTarget shardTarget) {
        this.shard = shardTarget;
        if (this.innerHits != null) {
            for (InternalSearchHits searchHits : this.innerHits.values()) {
                searchHits.shardTarget(shardTarget);
            }
        }
    }

    public void score(float score) {
        this.score = score;
    }

    @Override
    public float score() {
        return this.score;
    }

    @Override
    public float getScore() {
        return this.score();
    }

    public void version(long version) {
        this.version = version;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public String index() {
        return this.shard.index();
    }

    @Override
    public String getIndex() {
        return this.index();
    }

    @Override
    public String id() {
        return this.id != null ? this.id.string() : null;
    }

    @Override
    public String getId() {
        return this.id();
    }

    @Override
    public String type() {
        return this.type != null ? this.type.string() : null;
    }

    @Override
    public String getType() {
        return this.type();
    }

    @Override
    public SearchHit.NestedIdentity getNestedIdentity() {
        return this.nestedIdentity;
    }

    @Override
    public BytesReference sourceRef() {
        if (this.source == null) {
            return null;
        }
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
        }
    }

    public InternalSearchHit sourceRef(BytesReference source) {
        this.source = source;
        this.sourceAsBytes = null;
        this.sourceAsMap = null;
        return this;
    }

    @Override
    public BytesReference getSourceRef() {
        return this.sourceRef();
    }

    public BytesReference internalSourceRef() {
        return this.source;
    }

    @Override
    public byte[] source() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsBytes != null) {
            return this.sourceAsBytes;
        }
        this.sourceAsBytes = BytesReference.toBytes(this.sourceRef());
        return this.sourceAsBytes;
    }

    @Override
    public boolean hasSource() {
        return this.source != null;
    }

    @Override
    public Map<String, Object> getSource() {
        return this.sourceAsMap();
    }

    @Override
    public String sourceAsString() {
        if (this.source == null) {
            return null;
        }
        try {
            return XContentHelper.convertToJson(this.sourceRef(), false);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to convert source to a json string", new Object[0]);
        }
    }

    @Override
    public String getSourceAsString() {
        return this.sourceAsString();
    }

    @Override
    public Map<String, Object> sourceAsMap() throws ElasticsearchParseException {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source);
        return this.sourceAsMap;
    }

    @Override
    public Iterator<SearchHitField> iterator() {
        return this.fields.values().iterator();
    }

    @Override
    public SearchHitField field(String fieldName) {
        return this.fields().get(fieldName);
    }

    @Override
    public Map<String, SearchHitField> fields() {
        return this.fields == null ? Collections.emptyMap() : this.fields;
    }

    public Map<String, SearchHitField> fieldsOrNull() {
        return this.fields;
    }

    @Override
    public Map<String, SearchHitField> getFields() {
        return this.fields();
    }

    public void fields(Map<String, SearchHitField> fields) {
        this.fields = fields;
    }

    public Map<String, HighlightField> internalHighlightFields() {
        return this.highlightFields;
    }

    @Override
    public Map<String, HighlightField> highlightFields() {
        return this.highlightFields == null ? Collections.emptyMap() : this.highlightFields;
    }

    @Override
    public Map<String, HighlightField> getHighlightFields() {
        return this.highlightFields();
    }

    public void highlightFields(Map<String, HighlightField> highlightFields) {
        this.highlightFields = highlightFields;
    }

    public void sortValues(Object[] sortValues, DocValueFormat[] sortValueFormats) {
        this.sortValues = new SearchSortValues(sortValues, sortValueFormats);
    }

    @Override
    public Object[] sortValues() {
        return this.sortValues.sortValues();
    }

    @Override
    public Object[] getSortValues() {
        return this.sortValues();
    }

    @Override
    public Explanation explanation() {
        return this.explanation;
    }

    @Override
    public Explanation getExplanation() {
        return this.explanation();
    }

    public void explanation(Explanation explanation) {
        this.explanation = explanation;
    }

    @Override
    public SearchShardTarget shard() {
        return this.shard;
    }

    @Override
    public SearchShardTarget getShard() {
        return this.shard();
    }

    public void shard(SearchShardTarget target) {
        this.shard = target;
    }

    public void matchedQueries(String[] matchedQueries) {
        this.matchedQueries = matchedQueries;
    }

    @Override
    public String[] matchedQueries() {
        return this.matchedQueries;
    }

    @Override
    public String[] getMatchedQueries() {
        return this.matchedQueries;
    }

    @Override
    public Map<String, SearchHits> getInnerHits() {
        return this.innerHits;
    }

    public void setInnerHits(Map<String, InternalSearchHits> innerHits) {
        this.innerHits = innerHits;
    }

    public XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ArrayList<SearchHitField> metaFields = new ArrayList<SearchHitField>();
        ArrayList<SearchHitField> otherFields = new ArrayList<SearchHitField>();
        if (this.fields != null && !this.fields.isEmpty()) {
            for (SearchHitField searchHitField : this.fields.values()) {
                if (searchHitField.values().isEmpty()) continue;
                if (searchHitField.isMetadataField()) {
                    metaFields.add(searchHitField);
                    continue;
                }
                otherFields.add(searchHitField);
            }
        }
        if (this.explanation() != null && this.shard != null) {
            builder.field("_shard", this.shard.shardId());
            builder.field("_node", this.shard.nodeIdText());
        }
        if (this.nestedIdentity != null) {
            this.nestedIdentity.toXContent(builder, params);
        } else {
            if (this.shard != null) {
                builder.field("_index", this.shard.indexText());
            }
            if (this.type != null) {
                builder.field("_type", this.type);
            }
            if (this.id != null) {
                builder.field("_id", this.id);
            }
        }
        if (this.version != -1L) {
            builder.field("_version", this.version);
        }
        if (Float.isNaN(this.score)) {
            builder.nullField("_score");
        } else {
            builder.field("_score", this.score);
        }
        for (SearchHitField searchHitField : metaFields) {
            Object value = searchHitField.value();
            builder.field(searchHitField.name(), value);
        }
        if (this.source != null) {
            XContentHelper.writeRawField("_source", this.source, builder, params);
        }
        if (!otherFields.isEmpty()) {
            builder.startObject("fields");
            for (SearchHitField searchHitField : otherFields) {
                builder.startArray(searchHitField.name());
                for (Object object : searchHitField.getValues()) {
                    builder.value(object);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        if (this.highlightFields != null && !this.highlightFields.isEmpty()) {
            builder.startObject("highlight");
            for (HighlightField highlightField : this.highlightFields.values()) {
                highlightField.toXContent(builder, params);
            }
            builder.endObject();
        }
        this.sortValues.toXContent(builder, params);
        if (this.matchedQueries.length > 0) {
            builder.startArray("matched_queries");
            for (Iterator<Object> iterator : this.matchedQueries) {
                builder.value((String)((Object)iterator));
            }
            builder.endArray();
        }
        if (this.explanation() != null) {
            builder.field("_explanation");
            this.buildExplanation(builder, this.explanation());
        }
        if (this.innerHits != null) {
            builder.startObject("inner_hits");
            for (Map.Entry entry : this.innerHits.entrySet()) {
                builder.startObject((String)entry.getKey());
                ((InternalSearchHits)entry.getValue()).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    private void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
        builder.startObject();
        builder.field("value", explanation.getValue());
        builder.field("description", explanation.getDescription());
        Explanation[] innerExps = explanation.getDetails();
        if (innerExps != null) {
            builder.startArray("details");
            for (Explanation exp : innerExps) {
                this.buildExplanation(builder, exp);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static InternalSearchHit readSearchHit(StreamInput in) throws IOException {
        InternalSearchHit hit = new InternalSearchHit();
        hit.readFrom(in);
        return hit;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        int size;
        this.score = in.readFloat();
        this.id = in.readOptionalText();
        this.type = in.readOptionalText();
        this.nestedIdentity = in.readOptionalWriteable(InternalNestedIdentity::new);
        this.version = in.readLong();
        this.source = in.readBytesReference();
        if (this.source.length() == 0) {
            this.source = null;
        }
        if (in.readBoolean()) {
            this.explanation = Lucene.readExplanation(in);
        }
        if ((size = in.readVInt()) == 0) {
            this.fields = Collections.emptyMap();
        } else if (size == 1) {
            InternalSearchHitField hitField = InternalSearchHitField.readSearchHitField(in);
            this.fields = Collections.singletonMap(hitField.name(), hitField);
        } else {
            HashMap<String, InternalSearchHitField> fields = new HashMap<String, InternalSearchHitField>();
            for (i = 0; i < size; ++i) {
                InternalSearchHitField hitField = InternalSearchHitField.readSearchHitField(in);
                fields.put(hitField.name(), hitField);
            }
            this.fields = Collections.unmodifiableMap(fields);
        }
        size = in.readVInt();
        if (size == 0) {
            this.highlightFields = Collections.emptyMap();
        } else if (size == 1) {
            HighlightField field = HighlightField.readHighlightField(in);
            this.highlightFields = Collections.singletonMap(field.name(), field);
        } else {
            HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
            for (i = 0; i < size; ++i) {
                HighlightField field = HighlightField.readHighlightField(in);
                highlightFields.put(field.name(), field);
            }
            this.highlightFields = Collections.unmodifiableMap(highlightFields);
        }
        this.sortValues = new SearchSortValues(in);
        size = in.readVInt();
        if (size > 0) {
            this.matchedQueries = new String[size];
            for (int i2 = 0; i2 < size; ++i2) {
                this.matchedQueries[i2] = in.readString();
            }
        }
        this.shard = in.readOptionalWriteable(SearchShardTarget::new);
        size = in.readVInt();
        if (size > 0) {
            this.innerHits = new HashMap<String, InternalSearchHits>(size);
            for (int i3 = 0; i3 < size; ++i3) {
                String key = in.readString();
                InternalSearchHits value = InternalSearchHits.readSearchHits(in);
                this.innerHits.put(key, value);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeFloat(this.score);
        out.writeOptionalText(this.id);
        out.writeOptionalText(this.type);
        out.writeOptionalWriteable(this.nestedIdentity);
        out.writeLong(this.version);
        out.writeBytesReference(this.source);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (this.fields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.fields.size());
            for (SearchHitField searchHitField : this.fields().values()) {
                searchHitField.writeTo(out);
            }
        }
        if (this.highlightFields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.highlightFields.size());
            for (HighlightField highlightField : this.highlightFields.values()) {
                highlightField.writeTo(out);
            }
        }
        this.sortValues.writeTo(out);
        if (this.matchedQueries.length == 0) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.matchedQueries.length);
            for (Iterator<Streamable> iterator : this.matchedQueries) {
                out.writeString((String)((Object)iterator));
            }
        }
        out.writeOptionalWriteable(this.shard);
        if (this.innerHits == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.innerHits.size());
            for (Map.Entry entry : this.innerHits.entrySet()) {
                out.writeString((String)entry.getKey());
                ((InternalSearchHits)entry.getValue()).writeTo(out);
            }
        }
    }

    public static final class InternalNestedIdentity
    implements SearchHit.NestedIdentity,
    Writeable,
    ToXContent {
        private Text field;
        private int offset;
        private InternalNestedIdentity child;
        private static final ConstructingObjectParser<InternalNestedIdentity, ParseFieldMatcherSupplier> PARSER = new ConstructingObjectParser("nested_identity", ctorArgs -> new InternalNestedIdentity((String)ctorArgs[0], (Integer)ctorArgs[1], (InternalNestedIdentity)ctorArgs[2]));

        public InternalNestedIdentity(String field, int offset, InternalNestedIdentity child) {
            this.field = new Text(field);
            this.offset = offset;
            this.child = child;
        }

        InternalNestedIdentity(StreamInput in) throws IOException {
            this.field = in.readOptionalText();
            this.offset = in.readInt();
            this.child = in.readOptionalWriteable(InternalNestedIdentity::new);
        }

        @Override
        public Text getField() {
            return this.field;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public SearchHit.NestedIdentity getChild() {
            return this.child;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalText(this.field);
            out.writeInt(this.offset);
            out.writeOptionalWriteable(this.child);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("_nested");
            return this.innerToXContent(builder, params);
        }

        XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.field != null) {
                builder.field("field", this.field);
            }
            if (this.offset != -1) {
                builder.field("offset", this.offset);
            }
            if (this.child != null) {
                builder = this.child.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        public static InternalNestedIdentity fromXContent(XContentParser parser) {
            return PARSER.apply(parser, () -> ParseFieldMatcher.EMPTY);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            InternalNestedIdentity other = (InternalNestedIdentity)obj;
            return Objects.equals(this.field, other.field) && Objects.equals(this.offset, other.offset) && Objects.equals(this.child, other.child);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.offset, this.child);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("field", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("offset", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), PARSER, new ParseField("_nested", new String[0]));
        }

        public static class Fields {
            static final String _NESTED = "_nested";
            static final String _NESTED_FIELD = "field";
            static final String _NESTED_OFFSET = "offset";
        }
    }

    public static class Fields {
        static final String _INDEX = "_index";
        static final String _TYPE = "_type";
        static final String _ID = "_id";
        static final String _VERSION = "_version";
        static final String _SCORE = "_score";
        static final String FIELDS = "fields";
        static final String HIGHLIGHT = "highlight";
        static final String SORT = "sort";
        static final String MATCHED_QUERIES = "matched_queries";
        static final String _EXPLANATION = "_explanation";
        static final String VALUE = "value";
        static final String DESCRIPTION = "description";
        static final String DETAILS = "details";
        static final String INNER_HITS = "inner_hits";
    }
}

