/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion2x;

import com.carrotsearch.hppc.ObjectLongHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.XAnalyzingSuggester;
import org.apache.lucene.search.suggest.analyzing.XFuzzySuggester;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.elasticsearch.common.FieldMemoryStats;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.CompletionFieldMapper2x;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;
import org.elasticsearch.search.suggest.completion.FuzzyOptions;
import org.elasticsearch.search.suggest.completion2x.Completion090PostingsFormat;
import org.elasticsearch.search.suggest.completion2x.PayloadProcessor;
import org.elasticsearch.search.suggest.completion2x.context.ContextMapping;

public class AnalyzingCompletionLookupProvider
extends Completion090PostingsFormat.CompletionLookupProvider {
    public static final int SERIALIZE_PRESERVE_SEPARATORS = 1;
    public static final int SERIALIZE_HAS_PAYLOADS = 2;
    public static final int SERIALIZE_PRESERVE_POSITION_INCREMENTS = 4;
    private static final int MAX_SURFACE_FORMS_PER_ANALYZED_FORM = 256;
    private static final int MAX_GRAPH_EXPANSIONS = -1;
    public static final String CODEC_NAME = "analyzing";
    public static final int CODEC_VERSION_START = 1;
    public static final int CODEC_VERSION_SERIALIZED_LABELS = 2;
    public static final int CODEC_VERSION_CHECKSUMS = 3;
    public static final int CODEC_VERSION_LATEST = 3;
    private final boolean preserveSep;
    private final boolean preservePositionIncrements;
    private final int maxSurfaceFormsPerAnalyzedForm;
    private final int maxGraphExpansions;
    private final boolean hasPayloads;
    private final XAnalyzingSuggester prototype;

    public AnalyzingCompletionLookupProvider(boolean preserveSep, boolean preservePositionIncrements, boolean hasPayloads) {
        this.preserveSep = preserveSep;
        this.preservePositionIncrements = preservePositionIncrements;
        this.hasPayloads = hasPayloads;
        this.maxSurfaceFormsPerAnalyzedForm = 256;
        this.maxGraphExpansions = -1;
        int options = preserveSep ? 2 : 0;
        this.prototype = new XAnalyzingSuggester(null, null, null, options, this.maxSurfaceFormsPerAnalyzedForm, this.maxGraphExpansions, preservePositionIncrements, null, false, 1, 31, 31, 0, 30);
    }

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    public boolean getPreserveSep() {
        return this.preserveSep;
    }

    public boolean getPreservePositionsIncrements() {
        return this.preservePositionIncrements;
    }

    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    @Override
    public FieldsConsumer consumer(final IndexOutput output) throws IOException {
        CodecUtil.writeHeader((DataOutput)output, (String)CODEC_NAME, (int)3);
        return new FieldsConsumer(){
            private Map<String, Long> fieldOffsets = new HashMap<String, Long>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    long pointer = output.getFilePointer();
                    output.writeVInt(this.fieldOffsets.size());
                    for (Map.Entry<String, Long> entry : this.fieldOffsets.entrySet()) {
                        output.writeString(entry.getKey());
                        output.writeVLong(entry.getValue().longValue());
                    }
                    output.writeLong(pointer);
                    CodecUtil.writeFooter((IndexOutput)output);
                }
                catch (Throwable throwable) {
                    IOUtils.close((Closeable[])new Closeable[]{output});
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{output});
            }

            public void write(Fields fields) throws IOException {
                for (String field : fields) {
                    BytesRef term;
                    Terms terms = fields.terms(field);
                    if (terms == null) continue;
                    TermsEnum termsEnum = terms.iterator();
                    PostingsEnum docsEnum = null;
                    PayloadProcessor.SuggestPayload spare = new PayloadProcessor.SuggestPayload();
                    int maxAnalyzedPathsForOneInput = 0;
                    XAnalyzingSuggester.XBuilder builder = new XAnalyzingSuggester.XBuilder(AnalyzingCompletionLookupProvider.this.maxSurfaceFormsPerAnalyzedForm, AnalyzingCompletionLookupProvider.this.hasPayloads, 31);
                    int docCount = 0;
                    while ((term = termsEnum.next()) != null) {
                        docsEnum = termsEnum.postings(docsEnum, 88);
                        builder.startTerm(term);
                        int docFreq = 0;
                        while (docsEnum.nextDoc() != Integer.MAX_VALUE) {
                            for (int i = 0; i < docsEnum.freq(); ++i) {
                                int position = docsEnum.nextPosition();
                                AnalyzingCompletionLookupProvider.this.parsePayload(docsEnum.getPayload(), spare);
                                builder.addSurface(spare.surfaceForm.get(), spare.payload.get(), spare.weight);
                                maxAnalyzedPathsForOneInput = Math.max(maxAnalyzedPathsForOneInput, position + 1);
                            }
                            ++docFreq;
                            docCount = Math.max(docCount, docsEnum.docID() + 1);
                        }
                        builder.finishTerm(docFreq);
                    }
                    FST<PairOutputs.Pair<Long, BytesRef>> build = builder.build();
                    assert (build != null || docCount == 0) : "the FST is null but docCount is != 0 actual value: [" + docCount + "]";
                    if (build == null) continue;
                    this.fieldOffsets.put(field, output.getFilePointer());
                    build.save((DataOutput)output);
                    output.writeVInt(maxAnalyzedPathsForOneInput);
                    output.writeVInt(AnalyzingCompletionLookupProvider.this.maxSurfaceFormsPerAnalyzedForm);
                    output.writeInt(AnalyzingCompletionLookupProvider.this.maxGraphExpansions);
                    int options = 0;
                    options |= AnalyzingCompletionLookupProvider.this.preserveSep ? 1 : 0;
                    options |= AnalyzingCompletionLookupProvider.this.hasPayloads ? 2 : 0;
                    output.writeVInt(options |= AnalyzingCompletionLookupProvider.this.preservePositionIncrements ? 4 : 0);
                    output.writeVInt(31);
                    output.writeVInt(0);
                    output.writeVInt(31);
                    output.writeVInt(30);
                }
            }
        };
    }

    @Override
    public Completion090PostingsFormat.LookupFactory load(IndexInput input) throws IOException {
        long sizeInBytes = 0L;
        int version = CodecUtil.checkHeader((DataInput)input, (String)CODEC_NAME, (int)1, (int)3);
        if (version >= 3) {
            CodecUtil.checksumEntireFile((IndexInput)input);
        }
        long metaPointerPosition = input.length() - (long)(version >= 3 ? 8 + CodecUtil.footerLength() : 8);
        final HashMap lookupMap = new HashMap();
        input.seek(metaPointerPosition);
        long metaPointer = input.readLong();
        input.seek(metaPointer);
        int numFields = input.readVInt();
        TreeMap<Long, String> meta = new TreeMap<Long, String>();
        for (int i = 0; i < numFields; ++i) {
            String name = input.readString();
            long offset = input.readVLong();
            meta.put(offset, name);
        }
        for (Map.Entry entry : meta.entrySet()) {
            int holeCharacter;
            int endByte;
            int payloadSep;
            int sepLabel;
            input.seek(((Long)entry.getKey()).longValue());
            FST fst = new FST((DataInput)input, (Outputs)new PairOutputs((Outputs)PositiveIntOutputs.getSingleton(), (Outputs)ByteSequenceOutputs.getSingleton()));
            int maxAnalyzedPathsForOneInput = input.readVInt();
            int maxSurfaceFormsPerAnalyzedForm = input.readVInt();
            int maxGraphExpansions = input.readInt();
            int options = input.readVInt();
            boolean preserveSep = (options & 1) != 0;
            boolean hasPayloads = (options & 2) != 0;
            boolean preservePositionIncrements = (options & 4) != 0;
            switch (version) {
                case 1: {
                    sepLabel = 255;
                    payloadSep = 31;
                    endByte = 0;
                    holeCharacter = 30;
                    break;
                }
                default: {
                    sepLabel = input.readVInt();
                    endByte = input.readVInt();
                    payloadSep = input.readVInt();
                    holeCharacter = input.readVInt();
                }
            }
            AnalyzingSuggestHolder holder = new AnalyzingSuggestHolder(preserveSep, preservePositionIncrements, maxSurfaceFormsPerAnalyzedForm, maxGraphExpansions, hasPayloads, maxAnalyzedPathsForOneInput, (FST<PairOutputs.Pair<Long, BytesRef>>)fst, sepLabel, payloadSep, endByte, holeCharacter);
            sizeInBytes += fst.ramBytesUsed();
            lookupMap.put(entry.getValue(), holder);
        }
        final long ramBytesUsed = sizeInBytes;
        return new Completion090PostingsFormat.LookupFactory(){

            @Override
            public Lookup getLookup(CompletionFieldMapper2x.CompletionFieldType fieldType, CompletionSuggestionContext suggestionContext) {
                AnalyzingSuggestHolder analyzingSuggestHolder = (AnalyzingSuggestHolder)lookupMap.get(fieldType.name());
                if (analyzingSuggestHolder == null) {
                    return null;
                }
                int flags = analyzingSuggestHolder.getPreserveSeparator() ? 2 : 0;
                Automaton queryPrefix = fieldType.requiresContext() ? ContextMapping.ContextQuery.toAutomaton(analyzingSuggestHolder.getPreserveSeparator(), suggestionContext.getContextQueries()) : null;
                FuzzyOptions fuzzyOptions = suggestionContext.getFuzzyOptions();
                XAnalyzingSuggester suggester = fuzzyOptions != null ? new XFuzzySuggester((Analyzer)fieldType.indexAnalyzer(), queryPrefix, (Analyzer)fieldType.searchAnalyzer(), flags, analyzingSuggestHolder.maxSurfaceFormsPerAnalyzedForm, analyzingSuggestHolder.maxGraphExpansions, fuzzyOptions.getEditDistance(), fuzzyOptions.isTranspositions(), fuzzyOptions.getFuzzyPrefixLength(), fuzzyOptions.getFuzzyMinLength(), fuzzyOptions.isUnicodeAware(), analyzingSuggestHolder.fst, analyzingSuggestHolder.hasPayloads, analyzingSuggestHolder.maxAnalyzedPathsForOneInput, analyzingSuggestHolder.sepLabel, analyzingSuggestHolder.payloadSep, analyzingSuggestHolder.endByte, analyzingSuggestHolder.holeCharacter) : new XAnalyzingSuggester((Analyzer)fieldType.indexAnalyzer(), queryPrefix, (Analyzer)fieldType.searchAnalyzer(), flags, analyzingSuggestHolder.maxSurfaceFormsPerAnalyzedForm, analyzingSuggestHolder.maxGraphExpansions, analyzingSuggestHolder.preservePositionIncrements, analyzingSuggestHolder.fst, analyzingSuggestHolder.hasPayloads, analyzingSuggestHolder.maxAnalyzedPathsForOneInput, analyzingSuggestHolder.sepLabel, analyzingSuggestHolder.payloadSep, analyzingSuggestHolder.endByte, analyzingSuggestHolder.holeCharacter);
                return suggester;
            }

            @Override
            public CompletionStats stats(String ... fields) {
                long sizeInBytes = 0L;
                ObjectLongHashMap completionFields = null;
                if (fields != null && fields.length > 0) {
                    completionFields = new ObjectLongHashMap(fields.length);
                }
                for (Map.Entry entry : lookupMap.entrySet()) {
                    sizeInBytes += ((AnalyzingSuggestHolder)entry.getValue()).fst.ramBytesUsed();
                    if (fields == null || fields.length == 0 || !Regex.simpleMatch(fields, (String)entry.getKey())) continue;
                    long fstSize = ((AnalyzingSuggestHolder)entry.getValue()).fst.ramBytesUsed();
                    completionFields.addTo(entry.getKey(), fstSize);
                }
                return new CompletionStats(sizeInBytes, completionFields == null ? null : new FieldMemoryStats((ObjectLongHashMap<String>)completionFields));
            }

            @Override
            AnalyzingSuggestHolder getAnalyzingSuggestHolder(MappedFieldType fieldType) {
                return (AnalyzingSuggestHolder)lookupMap.get(fieldType.name());
            }

            public long ramBytesUsed() {
                return ramBytesUsed;
            }

            public Collection<Accountable> getChildResources() {
                return Accountables.namedAccountables((String)"field", (Map)lookupMap);
            }
        };
    }

    @Override
    public Set<IntsRef> toFiniteStrings(TokenStream stream) throws IOException {
        return this.prototype.toFiniteStrings(stream);
    }

    static class AnalyzingSuggestHolder
    implements Accountable {
        final boolean preserveSep;
        final boolean preservePositionIncrements;
        final int maxSurfaceFormsPerAnalyzedForm;
        final int maxGraphExpansions;
        final boolean hasPayloads;
        final int maxAnalyzedPathsForOneInput;
        final FST<PairOutputs.Pair<Long, BytesRef>> fst;
        final int sepLabel;
        final int payloadSep;
        final int endByte;
        final int holeCharacter;

        public AnalyzingSuggestHolder(boolean preserveSep, boolean preservePositionIncrements, int maxSurfaceFormsPerAnalyzedForm, int maxGraphExpansions, boolean hasPayloads, int maxAnalyzedPathsForOneInput, FST<PairOutputs.Pair<Long, BytesRef>> fst, int sepLabel, int payloadSep, int endByte, int holeCharacter) {
            this.preserveSep = preserveSep;
            this.preservePositionIncrements = preservePositionIncrements;
            this.maxSurfaceFormsPerAnalyzedForm = maxSurfaceFormsPerAnalyzedForm;
            this.maxGraphExpansions = maxGraphExpansions;
            this.hasPayloads = hasPayloads;
            this.maxAnalyzedPathsForOneInput = maxAnalyzedPathsForOneInput;
            this.fst = fst;
            this.sepLabel = sepLabel;
            this.payloadSep = payloadSep;
            this.endByte = endByte;
            this.holeCharacter = holeCharacter;
        }

        public boolean getPreserveSeparator() {
            return this.preserveSep;
        }

        public boolean getPreservePositionIncrements() {
            return this.preservePositionIncrements;
        }

        public boolean hasPayloads() {
            return this.hasPayloads;
        }

        public long ramBytesUsed() {
            if (this.fst != null) {
                return this.fst.ramBytesUsed();
            }
            return 0L;
        }

        public Collection<Accountable> getChildResources() {
            if (this.fst != null) {
                return Collections.singleton(Accountables.namedAccountable((String)"fst", this.fst));
            }
            return Collections.emptyList();
        }
    }
}

