/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.suggest.phrase.Laplace;
import org.elasticsearch.search.suggest.phrase.LinearInterpolation;
import org.elasticsearch.search.suggest.phrase.StupidBackoff;
import org.elasticsearch.search.suggest.phrase.WordScorer;

public abstract class SmoothingModel
implements NamedWriteable,
ToXContent {
    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getWriteableName());
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SmoothingModel other = (SmoothingModel)obj;
        return this.doEquals(other);
    }

    public final int hashCode() {
        return this.doHashCode();
    }

    protected abstract int doHashCode();

    public static SmoothingModel fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        ParseFieldMatcher parseFieldMatcher = parseContext.getParseFieldMatcher();
        String fieldName = null;
        SmoothingModel model = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (LinearInterpolation.PARSE_FIELD.match(fieldName)) {
                    model = LinearInterpolation.innerFromXContent(parseContext);
                    continue;
                }
                if (Laplace.PARSE_FIELD.match(fieldName)) {
                    model = Laplace.innerFromXContent(parseContext);
                    continue;
                }
                if (StupidBackoff.PARSE_FIELD.match(fieldName)) {
                    model = StupidBackoff.innerFromXContent(parseContext);
                    continue;
                }
                throw new IllegalArgumentException("suggester[phrase] doesn't support object field [" + fieldName + "]");
            }
            throw new ParsingException(parser.getTokenLocation(), "[smoothing] unknown token [" + (Object)((Object)token) + "] after [" + fieldName + "]", new Object[0]);
        }
        return model;
    }

    public abstract WordScorer.WordScorerFactory buildWordScorerFactory();

    protected abstract boolean doEquals(SmoothingModel var1);

    protected abstract XContentBuilder innerToXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
}

