/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.watcher.AbstractResourceWatcher;
import org.elasticsearch.watcher.FileChangesListener;

public class FileWatcher
extends AbstractResourceWatcher<FileChangesListener> {
    private FileObserver rootFileObserver;
    private Path file;
    private static final Logger logger = Loggers.getLogger(FileWatcher.class);
    private static FileObserver[] EMPTY_DIRECTORY = new FileObserver[0];

    public FileWatcher(Path file) {
        this.file = file;
        this.rootFileObserver = new FileObserver(file);
    }

    public void clearState() {
        this.rootFileObserver = new FileObserver(this.file);
        try {
            this.rootFileObserver.init(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void doInit() throws IOException {
        this.rootFileObserver.init(true);
    }

    @Override
    protected void doCheckAndNotify() throws IOException {
        this.rootFileObserver.checkAndNotify();
    }

    private class FileObserver {
        private Path file;
        private boolean exists;
        private long length;
        private long lastModified;
        private boolean isDirectory;
        private FileObserver[] children;

        public FileObserver(Path file) {
            this.file = file;
        }

        public void checkAndNotify() throws IOException {
            boolean prevExists = this.exists;
            boolean prevIsDirectory = this.isDirectory;
            long prevLength = this.length;
            long prevLastModified = this.lastModified;
            this.exists = Files.exists(this.file, new LinkOption[0]);
            if (this.exists) {
                BasicFileAttributes attributes = Files.readAttributes(this.file, BasicFileAttributes.class, new LinkOption[0]);
                this.isDirectory = attributes.isDirectory();
                if (this.isDirectory) {
                    this.length = 0L;
                    this.lastModified = 0L;
                } else {
                    this.length = attributes.size();
                    this.lastModified = attributes.lastModifiedTime().toMillis();
                }
            } else {
                this.isDirectory = false;
                this.length = 0L;
                this.lastModified = 0L;
            }
            if (prevExists) {
                if (this.exists) {
                    if (this.isDirectory) {
                        if (prevIsDirectory) {
                            this.updateChildren();
                        } else {
                            this.onFileDeleted();
                            this.onDirectoryCreated(false);
                        }
                    } else if (prevIsDirectory) {
                        this.onDirectoryDeleted();
                        this.onFileCreated(false);
                    } else if (prevLastModified != this.lastModified || prevLength != this.length) {
                        this.onFileChanged();
                    }
                } else if (prevIsDirectory) {
                    this.onDirectoryDeleted();
                } else {
                    this.onFileDeleted();
                }
            } else if (this.exists) {
                if (this.isDirectory) {
                    this.onDirectoryCreated(false);
                } else {
                    this.onFileCreated(false);
                }
            }
        }

        private void init(boolean initial) throws IOException {
            this.exists = Files.exists(this.file, new LinkOption[0]);
            if (this.exists) {
                BasicFileAttributes attributes = Files.readAttributes(this.file, BasicFileAttributes.class, new LinkOption[0]);
                this.isDirectory = attributes.isDirectory();
                if (this.isDirectory) {
                    this.onDirectoryCreated(initial);
                } else {
                    this.length = attributes.size();
                    this.lastModified = attributes.lastModifiedTime().toMillis();
                    this.onFileCreated(initial);
                }
            }
        }

        private FileObserver createChild(Path file, boolean initial) throws IOException {
            FileObserver child = new FileObserver(file);
            child.init(initial);
            return child;
        }

        private Path[] listFiles() throws IOException {
            Object[] files = FileSystemUtils.files(this.file);
            Arrays.sort(files);
            return files;
        }

        private FileObserver[] listChildren(boolean initial) throws IOException {
            Path[] files = this.listFiles();
            if (files != null && files.length > 0) {
                FileObserver[] children = new FileObserver[files.length];
                for (int i = 0; i < files.length; ++i) {
                    children[i] = this.createChild(files[i], initial);
                }
                return children;
            }
            return EMPTY_DIRECTORY;
        }

        private void updateChildren() throws IOException {
            Path[] files = this.listFiles();
            if (files != null && files.length > 0) {
                FileObserver[] newChildren = new FileObserver[files.length];
                int child = 0;
                int file = 0;
                while (file < files.length || child < this.children.length) {
                    int compare = file >= files.length ? -1 : (child >= this.children.length ? 1 : this.children[child].file.compareTo(files[file]));
                    if (compare == 0) {
                        this.children[child].checkAndNotify();
                        newChildren[file] = this.children[child];
                        ++file;
                        ++child;
                        continue;
                    }
                    if (compare > 0) {
                        newChildren[file] = this.createChild(files[file], false);
                        ++file;
                        continue;
                    }
                    this.deleteChild(child);
                    ++child;
                }
                this.children = newChildren;
            } else {
                for (int child = 0; child < this.children.length; ++child) {
                    this.deleteChild(child);
                }
                this.children = EMPTY_DIRECTORY;
            }
        }

        private void deleteChild(int child) {
            if (this.children[child].exists) {
                if (this.children[child].isDirectory) {
                    this.children[child].onDirectoryDeleted();
                } else {
                    this.children[child].onFileDeleted();
                }
            }
        }

        private void onFileCreated(boolean initial) {
            for (FileChangesListener listener : FileWatcher.this.listeners()) {
                try {
                    if (initial) {
                        listener.onFileInit(this.file);
                        continue;
                    }
                    listener.onFileCreated(this.file);
                }
                catch (Exception e) {
                    logger.warn("cannot notify file changes listener", (Throwable)e);
                }
            }
        }

        private void onFileDeleted() {
            for (FileChangesListener listener : FileWatcher.this.listeners()) {
                try {
                    listener.onFileDeleted(this.file);
                }
                catch (Exception e) {
                    logger.warn("cannot notify file changes listener", (Throwable)e);
                }
            }
        }

        private void onFileChanged() {
            for (FileChangesListener listener : FileWatcher.this.listeners()) {
                try {
                    listener.onFileChanged(this.file);
                }
                catch (Exception e) {
                    logger.warn("cannot notify file changes listener", (Throwable)e);
                }
            }
        }

        private void onDirectoryCreated(boolean initial) throws IOException {
            for (FileChangesListener listener : FileWatcher.this.listeners()) {
                try {
                    if (initial) {
                        listener.onDirectoryInit(this.file);
                        continue;
                    }
                    listener.onDirectoryCreated(this.file);
                }
                catch (Exception e) {
                    logger.warn("cannot notify file changes listener", (Throwable)e);
                }
            }
            this.children = this.listChildren(initial);
        }

        private void onDirectoryDeleted() {
            for (int child = 0; child < this.children.length; ++child) {
                this.deleteChild(child);
            }
            for (FileChangesListener listener : FileWatcher.this.listeners()) {
                try {
                    listener.onDirectoryDeleted(this.file);
                }
                catch (Exception e) {
                    logger.warn("cannot notify file changes listener", (Throwable)e);
                }
            }
        }
    }
}

