/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.GraphQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.graph.GraphTokenStreamFiniteStrings;

public class QueryBuilder {
    protected Analyzer analyzer;
    protected boolean enablePositionIncrements = true;

    public QueryBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Query createBooleanQuery(String field, String queryText) {
        return this.createBooleanQuery(field, queryText, BooleanClause.Occur.SHOULD);
    }

    public Query createBooleanQuery(String field, String queryText, BooleanClause.Occur operator) {
        if (operator != BooleanClause.Occur.SHOULD && operator != BooleanClause.Occur.MUST) {
            throw new IllegalArgumentException("invalid operator: only SHOULD or MUST are allowed");
        }
        return this.createFieldQuery(this.analyzer, operator, field, queryText, false, 0);
    }

    public Query createPhraseQuery(String field, String queryText) {
        return this.createPhraseQuery(field, queryText, 0);
    }

    public Query createPhraseQuery(String field, String queryText, int phraseSlop) {
        return this.createFieldQuery(this.analyzer, BooleanClause.Occur.MUST, field, queryText, true, phraseSlop);
    }

    public Query createMinShouldMatchQuery(String field, String queryText, float fraction) {
        if (Float.isNaN(fraction) || fraction < 0.0f || fraction > 1.0f) {
            throw new IllegalArgumentException("fraction should be >= 0 and <= 1");
        }
        if (fraction == 1.0f) {
            return this.createBooleanQuery(field, queryText, BooleanClause.Occur.MUST);
        }
        Query query = this.createFieldQuery(this.analyzer, BooleanClause.Occur.SHOULD, field, queryText, false, 0);
        if (query instanceof BooleanQuery) {
            query = this.addMinShouldMatchToBoolean((BooleanQuery)query, fraction);
        } else if (query instanceof GraphQuery && ((GraphQuery)query).hasBoolean()) {
            List<Query> oldQueries = ((GraphQuery)query).getQueries();
            Query[] queries = new Query[oldQueries.size()];
            for (int i = 0; i < queries.length; ++i) {
                Query oldQuery = oldQueries.get(i);
                queries[i] = oldQuery instanceof BooleanQuery ? this.addMinShouldMatchToBoolean((BooleanQuery)oldQuery, fraction) : oldQuery;
            }
            query = new GraphQuery(queries);
        }
        return query;
    }

    private BooleanQuery addMinShouldMatchToBoolean(BooleanQuery query, float fraction) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setDisableCoord(query.isCoordDisabled());
        builder.setMinimumNumberShouldMatch((int)(fraction * (float)query.clauses().size()));
        for (BooleanClause clause : query) {
            builder.add(clause);
        }
        return builder.build();
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public boolean getEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public void setEnablePositionIncrements(boolean enable) {
        this.enablePositionIncrements = enable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Query createFieldQuery(Analyzer analyzer, BooleanClause.Occur operator, String field, String queryText, boolean quoted, int phraseSlop) {
        assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
        try (TokenStream source = analyzer.tokenStream(field, queryText);){
            Query query = this.createFieldQuery(source, operator, field, quoted, phraseSlop);
            return query;
        }
        catch (IOException e) {
            throw new RuntimeException("Error analyzing query text", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Query createFieldQuery(TokenStream source, BooleanClause.Occur operator, String field, boolean quoted, int phraseSlop) {
        assert (operator == BooleanClause.Occur.SHOULD || operator == BooleanClause.Occur.MUST);
        try (CachingTokenFilter stream = new CachingTokenFilter(source);){
            TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncAtt = stream.addAttribute(PositionIncrementAttribute.class);
            PositionLengthAttribute posLenAtt = stream.addAttribute(PositionLengthAttribute.class);
            if (termAtt == null) {
                Query query = null;
                return query;
            }
            int numTokens = 0;
            int positionCount = 0;
            boolean hasSynonyms = false;
            boolean isGraph = false;
            stream.reset();
            while (stream.incrementToken()) {
                ++numTokens;
                int positionIncrement = posIncAtt.getPositionIncrement();
                if (positionIncrement != 0) {
                    positionCount += positionIncrement;
                } else {
                    hasSynonyms = true;
                }
                int positionLength = posLenAtt.getPositionLength();
                if (isGraph || positionLength <= 1) continue;
                isGraph = true;
            }
            if (numTokens == 0) {
                Query query = null;
                return query;
            }
            if (numTokens == 1) {
                Query query = this.analyzeTerm(field, stream);
                return query;
            }
            if (isGraph) {
                Query query = this.analyzeGraph(stream, operator, field, quoted, phraseSlop);
                return query;
            }
            if (quoted && positionCount > 1) {
                if (hasSynonyms) {
                    Query query = this.analyzeMultiPhrase(field, stream, phraseSlop);
                    return query;
                }
                Query query = this.analyzePhrase(field, stream, phraseSlop);
                return query;
            }
            if (positionCount == 1) {
                Query query = this.analyzeBoolean(field, stream);
                return query;
            }
            Query query = this.analyzeMultiBoolean(field, stream, operator);
            return query;
        }
        catch (IOException e) {
            throw new RuntimeException("Error analyzing query text", e);
        }
    }

    protected Query analyzeTerm(String field, TokenStream stream) throws IOException {
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        stream.reset();
        if (!stream.incrementToken()) {
            throw new AssertionError();
        }
        return this.newTermQuery(new Term(field, termAtt.getBytesRef()));
    }

    protected Query analyzeBoolean(String field, TokenStream stream) throws IOException {
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        stream.reset();
        ArrayList<Term> terms = new ArrayList<Term>();
        while (stream.incrementToken()) {
            terms.add(new Term(field, termAtt.getBytesRef()));
        }
        return this.newSynonymQuery(terms.toArray(new Term[terms.size()]));
    }

    protected void add(BooleanQuery.Builder q, List<Term> current, BooleanClause.Occur operator) {
        if (current.isEmpty()) {
            return;
        }
        if (current.size() == 1) {
            q.add(this.newTermQuery(current.get(0)), operator);
        } else {
            q.add(this.newSynonymQuery(current.toArray(new Term[current.size()])), operator);
        }
    }

    protected Query analyzeMultiBoolean(String field, TokenStream stream, BooleanClause.Occur operator) throws IOException {
        BooleanQuery.Builder q = this.newBooleanQuery();
        ArrayList<Term> currentQuery = new ArrayList<Term>();
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        stream.reset();
        while (stream.incrementToken()) {
            if (posIncrAtt.getPositionIncrement() != 0) {
                this.add(q, currentQuery, operator);
                currentQuery.clear();
            }
            currentQuery.add(new Term(field, termAtt.getBytesRef()));
        }
        this.add(q, currentQuery, operator);
        return q.build();
    }

    protected Query analyzePhrase(String field, TokenStream stream, int slop) throws IOException {
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        builder.setSlop(slop);
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        int position = -1;
        stream.reset();
        while (stream.incrementToken()) {
            position = this.enablePositionIncrements ? (position += posIncrAtt.getPositionIncrement()) : ++position;
            builder.add(new Term(field, termAtt.getBytesRef()), position);
        }
        return builder.build();
    }

    protected Query analyzeMultiPhrase(String field, TokenStream stream, int slop) throws IOException {
        MultiPhraseQuery.Builder mpqb = this.newMultiPhraseQueryBuilder();
        mpqb.setSlop(slop);
        TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = stream.getAttribute(PositionIncrementAttribute.class);
        int position = -1;
        ArrayList<Term> multiTerms = new ArrayList<Term>();
        stream.reset();
        while (stream.incrementToken()) {
            int positionIncrement = posIncrAtt.getPositionIncrement();
            if (positionIncrement > 0 && multiTerms.size() > 0) {
                if (this.enablePositionIncrements) {
                    mpqb.add(multiTerms.toArray(new Term[0]), position);
                } else {
                    mpqb.add(multiTerms.toArray(new Term[0]));
                }
                multiTerms.clear();
            }
            position += positionIncrement;
            multiTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        if (this.enablePositionIncrements) {
            mpqb.add(multiTerms.toArray(new Term[0]), position);
        } else {
            mpqb.add(multiTerms.toArray(new Term[0]));
        }
        return mpqb.build();
    }

    protected Query analyzeGraph(TokenStream source, BooleanClause.Occur operator, String field, boolean quoted, int phraseSlop) throws IOException {
        source.reset();
        List<TokenStream> tokenStreams = GraphTokenStreamFiniteStrings.getTokenStreams(source);
        if (tokenStreams.isEmpty()) {
            return null;
        }
        ArrayList<Query> queries = new ArrayList<Query>(tokenStreams.size());
        for (TokenStream ts : tokenStreams) {
            Query query = this.createFieldQuery(ts, operator, field, quoted, phraseSlop);
            if (query == null) continue;
            queries.add(query);
        }
        return new GraphQuery(queries.toArray(new Query[0]));
    }

    protected BooleanQuery.Builder newBooleanQuery() {
        return new BooleanQuery.Builder();
    }

    protected Query newSynonymQuery(Term[] terms) {
        return new SynonymQuery(terms);
    }

    protected Query newTermQuery(Term term) {
        return new TermQuery(term);
    }

    protected MultiPhraseQuery.Builder newMultiPhraseQueryBuilder() {
        return new MultiPhraseQuery.Builder();
    }
}

