/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractBulkIndexByScrollRequest;
import org.elasticsearch.index.reindex.remote.RemoteInfo;
import org.elasticsearch.tasks.TaskId;

public class ReindexRequest
extends AbstractBulkIndexByScrollRequest<ReindexRequest>
implements CompositeIndicesRequest {
    private IndexRequest destination;
    private RemoteInfo remoteInfo;

    public ReindexRequest() {
    }

    public ReindexRequest(SearchRequest search, IndexRequest destination) {
        this(search, destination, true);
    }

    private ReindexRequest(SearchRequest search, IndexRequest destination, boolean setDefaults) {
        super(search, setDefaults);
        this.destination = destination;
    }

    @Override
    protected ReindexRequest self() {
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = super.validate();
        if (this.getSearchRequest().indices() == null || this.getSearchRequest().indices().length == 0) {
            e = ValidateActions.addValidationError((String)"use _all if you really want to copy from all existing indexes", (ActionRequestValidationException)e);
        }
        if (this.getSearchRequest().source().fetchSource() != null && !this.getSearchRequest().source().fetchSource().fetchSource()) {
            e = ValidateActions.addValidationError((String)"_source:false is not supported in this context", (ActionRequestValidationException)e);
        }
        if (this.destination.index() == null) {
            e = ValidateActions.addValidationError((String)"index must be specified", (ActionRequestValidationException)e);
            return e;
        }
        if (!this.routingIsValid()) {
            e = ValidateActions.addValidationError((String)"routing must be unset, [keep], [discard] or [=<some new value>]", (ActionRequestValidationException)e);
        }
        if (this.destination.versionType() == VersionType.INTERNAL && this.destination.version() != -3L && this.destination.version() != -4L) {
            e = ValidateActions.addValidationError((String)("unsupported version for internal versioning [" + this.destination.version() + ']'), (ActionRequestValidationException)e);
        }
        if (this.destination.ttl() != null) {
            e = ValidateActions.addValidationError((String)"setting ttl on destination isn't supported. use scripts instead.", (ActionRequestValidationException)e);
        }
        if (this.destination.timestamp() != null) {
            e = ValidateActions.addValidationError((String)"setting timestamp on destination isn't supported. use scripts instead.", (ActionRequestValidationException)e);
        }
        if (this.getRemoteInfo() != null) {
            if (this.getSearchRequest().source().query() != null) {
                e = ValidateActions.addValidationError((String)"reindex from remote sources should use RemoteInfo's query instead of source's query", (ActionRequestValidationException)e);
            }
            if (this.getSlices() != 1) {
                e = ValidateActions.addValidationError((String)("reindex from remote sources doesn't support workers > 1 but was [" + this.getSlices() + "]"), (ActionRequestValidationException)e);
            }
        }
        return e;
    }

    private boolean routingIsValid() {
        if (this.destination.routing() == null || this.destination.routing().startsWith("=")) {
            return true;
        }
        switch (this.destination.routing()) {
            case "keep": 
            case "discard": {
                return true;
            }
        }
        return false;
    }

    public IndexRequest getDestination() {
        return this.destination;
    }

    public void setRemoteInfo(RemoteInfo remoteInfo) {
        this.remoteInfo = remoteInfo;
    }

    public RemoteInfo getRemoteInfo() {
        return this.remoteInfo;
    }

    @Override
    ReindexRequest forSlice(TaskId slicingTask, SearchRequest slice) {
        ReindexRequest sliced = this.doForSlice(new ReindexRequest(slice, this.destination, false), slicingTask);
        sliced.setRemoteInfo(this.remoteInfo);
        return sliced;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.destination = new IndexRequest();
        this.destination.readFrom(in);
        this.remoteInfo = (RemoteInfo)in.readOptionalWriteable(RemoteInfo::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.destination.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.remoteInfo);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("reindex from ");
        if (this.remoteInfo != null) {
            b.append('[').append(this.remoteInfo).append(']');
        }
        this.searchToString(b);
        b.append(" to [").append(this.destination.index()).append(']');
        if (this.destination.type() != null) {
            b.append('[').append(this.destination.type()).append(']');
        }
        return b.toString();
    }
}

