/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Tools;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.NodeMotionListenerView;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.NodeViewLayoutAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;

public class LeftNodeViewLayout
extends NodeViewLayoutAdapter {
    private static LeftNodeViewLayout instance = null;

    @Override
    protected void layout() {
        int contentHeight = this.getChildContentHeight(true);
        int childVerticalShift = this.getChildVerticalShift(true);
        int childHorizontalShift = this.getChildHorizontalShift();
        int x = Math.max(this.getSpaceAround(), -childHorizontalShift);
        if (this.getView().isContentVisible()) {
            this.getContent().setVisible(true);
            Dimension contentPreferredSize = this.getContent().getPreferredSize();
            int y = Math.max(this.getSpaceAround(), -(childVerticalShift += (contentPreferredSize.height - contentHeight) / 2));
            this.getContent().setBounds(x, y, contentPreferredSize.width, contentPreferredSize.height);
        } else {
            this.getContent().setVisible(false);
            int y = Math.max(this.getSpaceAround(), -childVerticalShift);
            this.getContent().setBounds(x, y, 0, contentHeight);
        }
        this.placeLeftChildren(childVerticalShift);
    }

    static LeftNodeViewLayout getInstance() {
        if (instance == null) {
            instance = new LeftNodeViewLayout();
        }
        return instance;
    }

    @Override
    public void layoutNodeMotionListenerView(NodeMotionListenerView nodeMotionView) {
        NodeView nodeView = nodeMotionView.getMovedView();
        JComponent content = nodeView.getContent();
        this.location.x = content.getWidth();
        this.location.y = 0;
        Tools.convertPointToAncestor((Component)content, this.location, nodeMotionView.getParent());
        nodeMotionView.setLocation(this.location);
        nodeMotionView.setSize(10, content.getHeight());
    }

    @Override
    public Point getMainViewOutPoint(NodeView view, NodeView targetView, Point destinationPoint) {
        MainView mainView = view.getMainView();
        return mainView.getLeftPoint();
    }

    @Override
    public Point getMainViewInPoint(NodeView view) {
        MainView mainView = view.getMainView();
        return mainView.getRightPoint();
    }
}

