/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.util.Hashtable;
import org.gjt.sp.jedit.bsh.UtilEvalError;

public class Capabilities {
    private static boolean accessibility = false;
    private static Hashtable classes = new Hashtable();

    public static boolean haveSwing() {
        return Capabilities.classExists("javax.swing.JButton");
    }

    public static boolean canGenerateInterfaces() {
        return Capabilities.classExists("java.lang.reflect.Proxy");
    }

    public static boolean haveAccessibility() {
        return accessibility;
    }

    public static void setAccessibility(boolean bl) throws Unavailable {
        if (!bl) {
            accessibility = false;
            return;
        }
        if (!Capabilities.classExists("java.lang.reflect.AccessibleObject") || !Capabilities.classExists("org.gjt.sp.jedit.bsh.reflect.ReflectManagerImpl")) {
            throw new Unavailable("Accessibility unavailable");
        }
        try {
            String.class.getDeclaredMethods();
        }
        catch (SecurityException securityException) {
            throw new Unavailable("Accessibility unavailable: " + securityException);
        }
        accessibility = true;
    }

    public static boolean classExists(String string) {
        Object object = classes.get(string);
        if (object == null) {
            try {
                object = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (object != null) {
                classes.put(object, "unused");
            }
        }
        return object != null;
    }

    public static class Unavailable
    extends UtilEvalError {
        public Unavailable(String string) {
            super(string);
        }
    }
}

