/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.nodes.RootNode;

abstract class DebuggerNode
extends ExecutionEventNode {
    protected final EventContext context;
    private volatile Thread cachedThread;
    private boolean cachedThreadDuplicate;
    private volatile ThreadLocal<Boolean> duplicateThreadLocal;

    abstract EventBinding<?> getBinding();

    DebuggerNode(EventContext context) {
        this.context = context;
    }

    Breakpoint getBreakpoint() {
        return null;
    }

    abstract DebuggerSession.SteppingLocation getSteppingLocation();

    final EventContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsDuplicate() {
        Thread thread = Thread.currentThread();
        if (this.cachedThread == thread) {
            this.cachedThreadDuplicate = true;
        } else if (this.cachedThread == null) {
            RootNode rootNode = this.getRootNode();
            synchronized (rootNode) {
                if (this.cachedThread == null) {
                    this.cachedThread = thread;
                    this.cachedThreadDuplicate = true;
                    return;
                }
            }
        }
        this.getDuplicateThreadLocal().set(Boolean.FALSE);
    }

    boolean consumeIsDuplicate() {
        if (this.cachedThread == Thread.currentThread()) {
            if (this.cachedThreadDuplicate) {
                this.cachedThreadDuplicate = false;
                return true;
            }
            return false;
        }
        if (this.cachedThread == null) {
            return false;
        }
        return this.isDuplicateSlowPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadLocal<Boolean> getDuplicateThreadLocal() {
        if (this.duplicateThreadLocal == null) {
            RootNode rootNode = this.getRootNode();
            synchronized (rootNode) {
                if (this.duplicateThreadLocal == null) {
                    this.duplicateThreadLocal = new ThreadLocal();
                }
            }
        }
        return this.duplicateThreadLocal;
    }

    private boolean isDuplicateSlowPath() {
        ThreadLocal<Boolean> suspend = this.getDuplicateThreadLocal();
        Boolean b = suspend.get();
        if (b == null) {
            return true;
        }
        boolean value = b;
        if (!value) {
            this.duplicateThreadLocal.set(Boolean.TRUE);
        }
        return value;
    }
}

