/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.CheckLayoutNodeFactory;
import org.jruby.truffle.language.RubyBaseNode;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.ShapeCachingGuards;

public class CheckLayoutNode
extends RubyBaseNode {
    @Node.Child
    private GetObjectTypeNode getObjectTypeNode = CheckLayoutNodeFactory.GetObjectTypeNodeGen.create(null);

    public boolean isArray(DynamicObject object) {
        return Layouts.ARRAY.isArray(this.getObjectTypeNode.executeGetObjectType(object));
    }

    public boolean isModule(DynamicObject object) {
        return Layouts.MODULE.isModule(this.getObjectTypeNode.executeGetObjectType(object));
    }

    public boolean isString(DynamicObject object) {
        return Layouts.STRING.isString(this.getObjectTypeNode.executeGetObjectType(object));
    }

    @ImportStatic(value={ShapeCachingGuards.class})
    @NodeChild(value="object")
    public static abstract class GetObjectTypeNode
    extends RubyNode {
        public abstract ObjectType executeGetObjectType(DynamicObject var1);

        @Specialization(guards={"object == cachedObject", "cachedShape.isLeaf()"}, assumptions={"cachedShape.getLeafAssumption()"}, limit="getLimit()")
        ObjectType cachedLeafShapeGetObjectType(DynamicObject object, @Cached(value="object") DynamicObject cachedObject, @Cached(value="cachedObject.getShape()") Shape cachedShape) {
            return cachedShape.getObjectType();
        }

        @Specialization(guards={"object.getShape() == cachedShape"}, limit="getLimit()")
        ObjectType cachedShapeGetObjectType(DynamicObject object, @Cached(value="object.getShape()") Shape cachedShape) {
            return cachedShape.getObjectType();
        }

        @Specialization(guards={"updateShape(object)"})
        ObjectType updateShapeAndRetry(DynamicObject object) {
            return this.executeGetObjectType(object);
        }

        @Specialization(contains={"cachedLeafShapeGetObjectType", "cachedShapeGetObjectType", "updateShapeAndRetry"})
        ObjectType uncachedGetObjectType(DynamicObject object) {
            return object.getShape().getObjectType();
        }

        protected int getLimit() {
            return this.getContext().getOptions().IS_A_CACHE;
        }
    }
}

