/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class DelegatingGlobalSearchScope
extends GlobalSearchScope {
    protected final GlobalSearchScope myBaseScope;
    private final Object myEquality;

    public DelegatingGlobalSearchScope(@NotNull GlobalSearchScope baseScope) {
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "com/intellij/psi/search/DelegatingGlobalSearchScope", "<init>"));
        }
        this(baseScope, ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    public DelegatingGlobalSearchScope(@NotNull GlobalSearchScope baseScope, Object ... equality) {
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "com/intellij/psi/search/DelegatingGlobalSearchScope", "<init>"));
        }
        if (equality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equality", "com/intellij/psi/search/DelegatingGlobalSearchScope", "<init>"));
        }
        super(baseScope.getProject());
        this.myBaseScope = baseScope;
        this.myEquality = Arrays.asList(equality);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/DelegatingGlobalSearchScope", "contains"));
        }
        return this.myBaseScope.contains(file2);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/DelegatingGlobalSearchScope", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/DelegatingGlobalSearchScope", "compare"));
        }
        return this.myBaseScope.compare(file1, file2);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/DelegatingGlobalSearchScope", "isSearchInModuleContent"));
        }
        return this.myBaseScope.isSearchInModuleContent(aModule);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/DelegatingGlobalSearchScope", "isSearchInModuleContent"));
        }
        return this.myBaseScope.isSearchInModuleContent(aModule, testSources);
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myBaseScope.isSearchInLibraries();
    }

    @Override
    public boolean isSearchOutsideRootModel() {
        return this.myBaseScope.isSearchOutsideRootModel();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myBaseScope.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/DelegatingGlobalSearchScope", "getDisplayName"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatingGlobalSearchScope that = (DelegatingGlobalSearchScope)o;
        if (!this.myBaseScope.equals(that.myBaseScope)) {
            return false;
        }
        return this.myEquality.equals(that.myEquality);
    }

    @Override
    public int hashCode() {
        int result2 = this.myBaseScope.hashCode();
        result2 = 31 * result2 + this.myEquality.hashCode();
        return result2;
    }
}

