/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.util.AstUtil;

public final class JsArrayLiteral
extends JsLiteral {
    private final List<JsExpression> expressions;

    public JsArrayLiteral() {
        this.expressions = new SmartList<JsExpression>();
    }

    public JsArrayLiteral(List<JsExpression> expressions) {
        this.expressions = expressions;
    }

    public List<JsExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitArray(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.expressions);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptList(this.expressions);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsArrayLiteral deepCopy() {
        JsArrayLiteral jsArrayLiteral = new JsArrayLiteral(AstUtil.deepCopy(this.expressions)).withMetadataFrom(this);
        if (jsArrayLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsArrayLiteral", "deepCopy"));
        }
        return jsArrayLiteral;
    }
}

