/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.initializer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.initializer.InitializerUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

public final class InitializerVisitor
extends TranslatorVisitor<Void> {
    @Override
    protected Void emptyResult(@NotNull TranslationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "emptyResult"));
        }
        return null;
    }

    @Override
    public final Void visitProperty(@NotNull KtProperty property, @NotNull TranslationContext context) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitProperty"));
        }
        PropertyDescriptor descriptor2 = BindingUtils.getPropertyDescriptor(context.bindingContext(), property);
        JsExpression value = PropertyTranslatorKt.translateDelegateOrInitializerExpression(context, property);
        JsStatement statement = null;
        KtExpression initializer2 = property.getInitializer();
        KtExpression delegate2 = property.getDelegateExpression();
        if (initializer2 != null) {
            assert (value != null);
            statement = InitializerUtils.generateInitializerForProperty(context, descriptor2, value);
        } else if (delegate2 != null) {
            assert (value != null);
            statement = InitializerUtils.generateInitializerForDelegate(descriptor2, value);
        } else if (Boolean.TRUE.equals(context.bindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2))) {
            JsExpression defaultValue = InitializerVisitor.generateDefaultValue(descriptor2, context);
            statement = TranslationUtils.assignmentToBackingField(context, descriptor2, defaultValue).makeStmt();
        } else if (JsDescriptorUtils.isSimpleFinalProperty(descriptor2)) {
            JsExpression defaultValue = InitializerVisitor.generateDefaultValue(descriptor2, context);
            JsName propertyName = context.getNameForDescriptor(descriptor2);
            statement = JsAstUtils.assignment(new JsNameRef(propertyName, (JsExpression)JsLiteral.THIS), defaultValue).makeStmt();
        }
        if (statement != null && !JsAstUtils.isEmptyStatement(statement)) {
            context.addStatementsToCurrentBlock(JsAstUtils.flattenStatement(statement));
        }
        return null;
    }

    @NotNull
    private static JsExpression generateDefaultValue(@NotNull PropertyDescriptor property, @NotNull TranslationContext context) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "generateDefaultValue"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "generateDefaultValue"));
        }
        if (property.isLateInit()) {
            JsExpression jsExpression = Namer.getUndefinedExpression();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "generateDefaultValue"));
            }
            return jsExpression;
        }
        KotlinType type2 = property.getType();
        if (KotlinBuiltIns.isInt(type2) || KotlinBuiltIns.isFloat(type2) || KotlinBuiltIns.isDouble(type2) || KotlinBuiltIns.isByte(type2) || KotlinBuiltIns.isShort(type2)) {
            JsNumberLiteral jsNumberLiteral = context.program().getNumberLiteral(0);
            if (jsNumberLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "generateDefaultValue"));
            }
            return jsNumberLiteral;
        }
        if (KotlinBuiltIns.isBoolean(type2)) {
            JsLiteral.JsBooleanLiteral jsBooleanLiteral = JsLiteral.FALSE;
            if (jsBooleanLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "generateDefaultValue"));
            }
            return jsBooleanLiteral;
        }
        JsNullLiteral jsNullLiteral = JsLiteral.NULL;
        if (jsNullLiteral == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "generateDefaultValue"));
        }
        return jsNullLiteral;
    }

    @Override
    public Void visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer2, @NotNull TranslationContext context) {
        if (initializer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitAnonymousInitializer"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitAnonymousInitializer"));
        }
        KtExpression initializerBody = initializer2.getBody();
        if (initializerBody != null) {
            context.addStatementsToCurrentBlock(JsAstUtils.flattenStatement(Translation.translateAsStatementAndMergeInBlockIfNeeded(initializerBody, context)));
        }
        return null;
    }

    @Override
    public Void visitDeclaration(@NotNull KtDeclaration expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitDeclaration"));
        }
        return null;
    }

    @Override
    public Void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, TranslationContext data) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/js/translate/initializer/InitializerVisitor", "visitSecondaryConstructor"));
        }
        return null;
    }
}

