/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.parosproxy.paros.Constant;

public class ZapTextComponentUndoManager
extends UndoManager
implements PropertyChangeListener {
    private static final long serialVersionUID = -5728632360771625298L;
    private final JTextComponent textComponent;
    private final UndoAction undoAction;
    private final RedoAction redoAction;
    private boolean enabled;
    private UndoManagerPolicy policy;

    public ZapTextComponentUndoManager(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            throw new NullPointerException("The textComponent must not be null.");
        }
        this.textComponent = jTextComponent;
        this.undoAction = new UndoAction(this);
        this.redoAction = new RedoAction(this);
        this.enabled = false;
        this.policy = null;
        this.setUndoManagerPolicy(UndoManagerPolicy.DEFAULT);
    }

    public final void setUndoManagerPolicy(UndoManagerPolicy undoManagerPolicy) throws NullPointerException {
        if (undoManagerPolicy == null) {
            throw new NullPointerException("The policy must not be null.");
        }
        if (this.policy == undoManagerPolicy) {
            return;
        }
        UndoManagerPolicy undoManagerPolicy2 = this.policy;
        this.policy = undoManagerPolicy;
        if (undoManagerPolicy2 == UndoManagerPolicy.DEFAULT) {
            this.textComponent.removePropertyChangeListener("editable", this);
            this.textComponent.removePropertyChangeListener("enabled", this);
        }
        if (this.policy == UndoManagerPolicy.DEFAULT) {
            this.textComponent.addPropertyChangeListener("editable", this);
            this.textComponent.addPropertyChangeListener("enabled", this);
        }
        this.handleUndoManagerPolicy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("document".equals(string)) {
            if (this.enabled) {
                ((Document)propertyChangeEvent.getOldValue()).removeUndoableEditListener(this);
                ((Document)propertyChangeEvent.getNewValue()).addUndoableEditListener(this);
                if (this.policy == UndoManagerPolicy.DEFAULT) {
                    this.handleUndoManagerDefaultPolicy();
                }
            }
        } else if (this.policy == UndoManagerPolicy.DEFAULT && ("editable".equals(string) || "enabled".equals(string))) {
            this.handleUndoManagerDefaultPolicy();
        }
    }

    private void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            if (bl) {
                this.textComponent.addPropertyChangeListener("document", this);
                this.textComponent.getDocument().addUndoableEditListener(this);
                this.textComponent.getActionMap().put("Undo", this.undoAction);
                this.textComponent.getActionMap().put("Redo", this.redoAction);
                this.textComponent.getInputMap().put(UndoAction.KEY_STROKE, "Undo");
                this.textComponent.getInputMap().put(RedoAction.KEY_STROKE, "Redo");
            } else {
                this.textComponent.removePropertyChangeListener("document", this);
                this.textComponent.getDocument().removeUndoableEditListener(this);
                this.textComponent.getActionMap().remove("Undo");
                this.textComponent.getActionMap().remove("Redo");
                this.textComponent.getInputMap().remove(UndoAction.KEY_STROKE);
                this.textComponent.getInputMap().remove(RedoAction.KEY_STROKE);
            }
        }
    }

    private void handleUndoManagerPolicy() {
        switch (this.policy) {
            case ALWAYS_DISABLED: {
                this.setEnabled(false);
                break;
            }
            case ALWAYS_ENABLED: {
                this.setEnabled(true);
                break;
            }
            default: {
                this.handleUndoManagerDefaultPolicy();
            }
        }
    }

    private void handleUndoManagerDefaultPolicy() {
        this.setEnabled(this.textComponent.isEditable() && this.textComponent.isEnabled());
    }

    private static final class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -7098526742716575130L;
        public static final String ACTION_NAME = "Redo";
        public static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(Constant.ACCELERATOR_REDO);
        private UndoManager undoManager;

        public RedoAction(UndoManager undoManager) {
            super(ACTION_NAME);
            this.undoManager = undoManager;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this.undoManager.canRedo()) {
                    this.undoManager.redo();
                }
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
    }

    private static final class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 6681683056944213164L;
        public static final String ACTION_NAME = "Undo";
        public static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(Constant.ACCELERATOR_UNDO);
        private UndoManager undoManager;

        public UndoAction(UndoManager undoManager) {
            super(ACTION_NAME);
            this.undoManager = undoManager;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this.undoManager.canUndo()) {
                    this.undoManager.undo();
                }
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
    }

    public static enum UndoManagerPolicy {
        DEFAULT,
        ALWAYS_ENABLED,
        ALWAYS_DISABLED;

    }
}

