/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.widgets;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.lang.ArrayUtils;
import org.zaproxy.zap.extension.users.UsersTableModel;
import org.zaproxy.zap.users.User;

class UsersListModel
extends AbstractListModel<User>
implements ComboBoxModel<User> {
    private static final long serialVersionUID = 5648260449088479312L;
    private User selectedItem;
    private UsersTableModel tableModel;
    private User[] customUsers;

    UsersListModel(UsersTableModel usersTableModel) {
        this.tableModel = usersTableModel;
        this.tableModel.addTableModelListener(new TableModelListenerImpl());
    }

    @Override
    public User getElementAt(int n) {
        if (n < this.tableModel.getRowCount()) {
            return (User)this.tableModel.getElement(n);
        }
        if (this.customUsers != null) {
            return this.customUsers[n - this.tableModel.getRowCount()];
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.tableModel.getUsers().size() + (this.customUsers == null ? 0 : this.customUsers.length);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object == null) {
            if (this.selectedItem == null) {
                return;
            }
            this.setSelectedItemImpl(null);
            return;
        }
        if (!(object instanceof User)) {
            return;
        }
        if (this.selectedItem != null && this.selectedItem.equals(object)) {
            return;
        }
        if (this.getIndexOf(object) == -1) {
            return;
        }
        this.setSelectedItemImpl((User)object);
    }

    private void setSelectedItemImpl(User user) {
        this.selectedItem = user;
        this.fireContentsChanged(this, -1, -1);
    }

    public void setSelectedInternalItem(User user) {
        User user2 = null;
        int n = this.getIndexOf(user);
        if (n != -1) {
            user2 = this.getElementAt(n);
        } else if (this.getSize() > 0) {
            user2 = this.getElementAt(0);
        }
        this.setSelectedItemImpl(user2);
    }

    public int getIndexOf(Object object) {
        int n = this.tableModel.getUsers().indexOf(object);
        if (n < 0 && this.customUsers != null) {
            return this.tableModel.getUsers().size() + ArrayUtils.indexOf(this.customUsers, object);
        }
        return n;
    }

    public void setCustomUsers(User[] userArray) {
        User[] userArray2 = this.customUsers;
        int n = this.tableModel.getUsers().size();
        this.customUsers = userArray;
        if (userArray2 == null || userArray2.length == 0) {
            if (userArray != null && userArray.length != 0) {
                this.fireIntervalAdded(this, n, n + this.customUsers.length - 1);
            }
        } else if (userArray == null || userArray.length == 0) {
            this.fireIntervalRemoved(this, n, n + userArray2.length - 1);
        } else {
            this.fireContentsChanged(this, n, n + Math.max(this.customUsers.length, userArray2.length) - 1);
        }
    }

    private class TableModelListenerImpl
    implements TableModelListener {
        private TableModelListenerImpl() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            switch (tableModelEvent.getType()) {
                case 1: {
                    if (UsersListModel.this.selectedItem == null) {
                        this.selectFirstUser();
                    }
                    UsersListModel.this.fireIntervalAdded(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    break;
                }
                case 0: {
                    if (UsersListModel.this.selectedItem != null) {
                        int n = UsersListModel.this.getIndexOf(UsersListModel.this.selectedItem);
                        if (n == -1) {
                            this.selectionFallback();
                        } else {
                            User user = UsersListModel.this.getElementAt(n);
                            if (user != UsersListModel.this.selectedItem) {
                                UsersListModel.this.setSelectedItemImpl(user);
                            }
                        }
                    } else {
                        this.selectionFallback();
                    }
                    UsersListModel.this.fireContentsChanged(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    break;
                }
                case -1: {
                    if (UsersListModel.this.selectedItem != null && UsersListModel.this.getIndexOf(UsersListModel.this.selectedItem) == -1) {
                        this.selectionFallback();
                    }
                    UsersListModel.this.fireIntervalRemoved(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    break;
                }
            }
        }

        private void selectFirstUser() {
            UsersListModel.this.setSelectedItemImpl(UsersListModel.this.getElementAt(0));
        }

        private void selectionFallback() {
            if (UsersListModel.this.getSize() != 0) {
                this.selectFirstUser();
            } else if (UsersListModel.this.selectedItem != null) {
                UsersListModel.this.setSelectedItemImpl(null);
            }
        }
    }
}

