/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.EventLoop;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.font.PrismFontLoader;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.runtime.async.AbstractRemoteResource;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.sg.PGArc;
import com.sun.javafx.sg.PGCanvas;
import com.sun.javafx.sg.PGCircle;
import com.sun.javafx.sg.PGCubicCurve;
import com.sun.javafx.sg.PGEllipse;
import com.sun.javafx.sg.PGGroup;
import com.sun.javafx.sg.PGImageView;
import com.sun.javafx.sg.PGLine;
import com.sun.javafx.sg.PGMediaView;
import com.sun.javafx.sg.PGPath;
import com.sun.javafx.sg.PGPolygon;
import com.sun.javafx.sg.PGPolyline;
import com.sun.javafx.sg.PGQuadCurve;
import com.sun.javafx.sg.PGRectangle;
import com.sun.javafx.sg.PGRegion;
import com.sun.javafx.sg.PGSVGPath;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.PGText;
import com.sun.javafx.sg.prism.NGArc;
import com.sun.javafx.sg.prism.NGCanvas;
import com.sun.javafx.sg.prism.NGCircle;
import com.sun.javafx.sg.prism.NGCubicCurve;
import com.sun.javafx.sg.prism.NGEllipse;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.javafx.sg.prism.NGImageView;
import com.sun.javafx.sg.prism.NGLine;
import com.sun.javafx.sg.prism.NGMediaView;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPath;
import com.sun.javafx.sg.prism.NGPolygon;
import com.sun.javafx.sg.prism.NGPolyline;
import com.sun.javafx.sg.prism.NGQuadCurve;
import com.sun.javafx.sg.prism.NGRectangle;
import com.sun.javafx.sg.prism.NGRegion;
import com.sun.javafx.sg.prism.NGSVGPath;
import com.sun.javafx.sg.prism.NGText;
import com.sun.javafx.tk.FileChooserType;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.ScreenConfigurationAccessor;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.TKDragGestureListener;
import com.sun.javafx.tk.TKDragSourceListener;
import com.sun.javafx.tk.TKDropTargetListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKScreenConfigurationListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.TKSystemMenu;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.desktop.AppletWindow;
import com.sun.javafx.tk.desktop.DesktopToolkit;
import com.sun.javafx.tk.desktop.MasterTimer;
import com.sun.javafx.tk.quantum.CursorUtils;
import com.sun.javafx.tk.quantum.EmbeddedStage;
import com.sun.javafx.tk.quantum.GlassAppletWindow;
import com.sun.javafx.tk.quantum.GlassDragEvent;
import com.sun.javafx.tk.quantum.GlassPrismInputMethodEvent;
import com.sun.javafx.tk.quantum.GlassPrismKeyEvent;
import com.sun.javafx.tk.quantum.GlassPrismMouseEvent;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.GlassSystemMenu;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.PathIteratorHelper;
import com.sun.javafx.tk.quantum.PopupStage;
import com.sun.javafx.tk.quantum.PrismEventUtils;
import com.sun.javafx.tk.quantum.PrismImageLoader2;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import com.sun.javafx.tk.quantum.QuantumRenderer;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.BasicStroke;
import com.sun.prism.ExternalImageTools;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderingContext;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.camera.PrismParallelCameraImpl;
import com.sun.prism.camera.PrismPerspectiveCameraImpl;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.Stop;
import com.sun.prism.render.CompletionListener;
import com.sun.prism.render.RenderJob;
import com.sun.prism.render.ToolkitInterface;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.animation.AbstractMasterTimer;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrImage;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.ConditionalFeature;
import javafx.geometry.Dimension2D;
import javafx.scene.image.Image;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.RadialGradient;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.SVGPath;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.StageStyle;

public class QuantumToolkit
extends DesktopToolkit
implements Launchable,
ToolkitInterface {
    private static boolean verbose = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("quantum.verbose");
        }
    });
    private static boolean debug = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("quantum.debug");
        }
    });
    private static Integer pulseHZ = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            return Integer.getInteger("javafx.animation.pulse");
        }
    });
    private AtomicBoolean toolkitRunning = new AtomicBoolean(false);
    private AtomicBoolean animationRunning = new AtomicBoolean(false);
    private AtomicBoolean nextPulseRequested = new AtomicBoolean(false);
    private AtomicBoolean pulseRunning = new AtomicBoolean(false);
    private CountDownLatch launchLatch = new CountDownLatch(1);
    protected final int PULSE_INTERVAL = (int)(TimeUnit.SECONDS.toMillis(1L) / (long)this.getRefreshRate());
    protected final int FULLSPEED_INTERVAL = 1;
    private float _maxPixelScale;
    private Runnable pulseRunnable;
    private Runnable userRunnable;
    private Runnable timerRunnable;
    private Timer pulseTimer = null;
    private Thread shutdownHook = null;
    private PaintCollector collector;
    private QuantumRenderer renderer;
    private GraphicsPipeline pipeline;
    private ClassLoader ccl;
    private HashMap<Object, EventLoop> eventLoopMap = null;
    private static ScreenConfigurationAccessor screenAccessor = new ScreenConfigurationAccessor(){

        @Override
        public int getMinX(Object object) {
            return ((Screen)object).getX();
        }

        @Override
        public int getMinY(Object object) {
            return ((Screen)object).getY();
        }

        @Override
        public int getWidth(Object object) {
            return ((Screen)object).getWidth();
        }

        @Override
        public int getHeight(Object object) {
            return ((Screen)object).getHeight();
        }

        @Override
        public int getVisualMinX(Object object) {
            return ((Screen)object).getVisibleX();
        }

        @Override
        public int getVisualMinY(Object object) {
            return ((Screen)object).getVisibleY();
        }

        @Override
        public int getVisualWidth(Object object) {
            return ((Screen)object).getVisibleWidth();
        }

        @Override
        public int getVisualHeight(Object object) {
            return ((Screen)object).getVisibleHeight();
        }

        @Override
        public float getDPI(Object object) {
            return ((Screen)object).getResolutionX();
        }
    };
    private Map contextMap = Collections.synchronizedMap(new HashMap());
    private DelayedRunnable animationRunnable;
    static BasicStroke tmpStroke = new BasicStroke();
    private QuantumClipboard clipboard;
    private GlassSystemMenu systemMenu = new GlassSystemMenu();
    private QuantumClipboard dragSourceClipboard;
    private GlassScene dragSourceScene;

    @Override
    public boolean init() {
        if (PlatformUtil.isMac()) {
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("os.version");
                }
            });
            if (string.startsWith("10.4") || string.startsWith("10.5")) {
                throw new RuntimeException("JavaFX requires Mac OSX 10.6 or higher to run");
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    System.setProperty("java.awt.headless", "true");
                    return null;
                }
            });
        }
        this.renderer = QuantumRenderer.getInstance();
        this.collector = PaintCollector.createInstance(this);
        this.pipeline = GraphicsPipeline.getPipeline();
        if (PrismSettings.shutdownHook) {
            this.shutdownHook = new Thread("Glass/Prism Shutdown Hook"){

                @Override
                public void run() {
                    QuantumToolkit.this.dispose();
                }
            };
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Runtime.getRuntime().addShutdownHook(QuantumToolkit.this.shutdownHook);
                    return null;
                }
            });
        }
        return true;
    }

    @Override
    public void startup(Runnable runnable) {
        this.ccl = Thread.currentThread().getContextClassLoader();
        try {
            this.userRunnable = runnable;
            Application.Run(null, this);
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        try {
            this.launchLatch.await();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void assertToolkitRunning() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishLaunching(String[] stringArray) {
        Thread thread = Thread.currentThread();
        if (!this.toolkitRunning.getAndSet(true)) {
            thread.setName("JavaFX Application Thread");
            thread.setContextClassLoader(this.ccl);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    System.out.println(thread.getName() + " uncaught: " + throwable.getClass().getName());
                    throwable.printStackTrace();
                }
            });
            QuantumToolkit.setFxUserThread(thread);
            this.renderer.createResourceFactory();
            this.pulseRunnable = new Runnable(){

                @Override
                public void run() {
                    QuantumToolkit.this.pulse();
                }
            };
            this.timerRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        QuantumToolkit.this.postPulse();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(System.err);
                    }
                }
            };
            this.pulseTimer = Application.GetApplication().createTimer(this.timerRunnable);
            Application.GetApplication().setEventHandler(new Application.EventHandler(){

                @Override
                public void handleQuitAction(Application application, long l) {
                    GlassStage.requestClosingAllWindows();
                }
            });
        }
        this.launchLatch.countDown();
        try {
            Application.invokeAndWait(this.userRunnable);
            if (this.getMasterTimer().isFullspeed()) {
                this.pulseTimer.start(1);
            } else {
                this.pulseTimer.start(this.PULSE_INTERVAL);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        finally {
            if (verbose) {
                System.err.println(" vsync: " + PrismSettings.isVsyncEnabled + " vpipe: " + this.pipeline.isVsyncSupported());
            }
            PerformanceTracker.logEvent("Toolkit.startup - finished");
        }
    }

    protected boolean isVsyncEnabled() {
        return PrismSettings.isVsyncEnabled && this.pipeline.isVsyncSupported() && this.windowVisible(Window.getWindows());
    }

    private boolean windowVisible(List<Window> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Window window = list.get(i);
            if (!window.isVisible() || window.isMinimized()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkFxUserThread() {
        super.checkFxUserThread();
        this.renderer.checkRendererIdle();
    }

    protected static Thread getFxUserThread() {
        return Toolkit.getFxUserThread();
    }

    @Override
    public Future addRenderJob(RenderJob renderJob) {
        return this.renderer.submitRenderJob(renderJob);
    }

    protected void postPulse() {
        if (this.toolkitRunning.get() && (this.animationRunning.get() || this.nextPulseRequested.get() || this.collector.hasDirty().get()) && !this.setPulseRunning()) {
            Application.postOnEventQueue(this.pulseRunnable);
            if (debug) {
                System.err.println("QT.postPulse@(" + System.nanoTime() + "): " + this.pulseString());
            }
        } else if (debug) {
            System.err.println("QT.postPulse#(" + System.nanoTime() + ") DROP: " + this.pulseString());
        }
    }

    private String pulseString() {
        return (this.toolkitRunning.get() ? "T" : "t") + (this.animationRunning.get() ? "A" : "a") + (this.pulseRunning.get() ? "P" : "p") + (this.nextPulseRequested.get() ? "N" : "n") + (this.collector.hasDirty().get() ? "D" : "d");
    }

    private boolean setPulseRunning() {
        return this.pulseRunning.getAndSet(true);
    }

    protected void endPulseRunning() {
        this.pulseRunning.set(false);
        if (debug) {
            System.err.println("QT.endPulse: " + System.nanoTime());
        }
    }

    protected void pulse() {
        if (debug) {
            System.err.println("PULSE:(" + System.nanoTime() + "): " + this.pulseString());
        }
        if (!this.toolkitRunning.get()) {
            return;
        }
        try {
            this.nextPulseRequested.set(false);
            if (this.animationRunnable != null) {
                this.animationRunning.set(true);
                this.animationRunnable.run();
            } else {
                this.animationRunning.set(false);
            }
            this.firePulse();
            this.collector.renderAll();
            View.notifyRenderingEnd();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    protected void vsyncHint() {
        if (this.isVsyncEnabled()) {
            if (debug) {
                System.err.println("QT.vsyncHint: postPulse: " + System.nanoTime());
            }
            this.postPulse();
        }
    }

    @Override
    public AppletWindow createAppletWindow(long l, String string) {
        GlassAppletWindow glassAppletWindow = new GlassAppletWindow(l, string);
        WindowStage.setAppletWindow(glassAppletWindow);
        return glassAppletWindow;
    }

    @Override
    public void closeAppletWindow() {
        GlassAppletWindow glassAppletWindow = WindowStage.getAppletWindow();
        if (null != glassAppletWindow) {
            glassAppletWindow.dispose();
            WindowStage.setAppletWindow(null);
        }
    }

    @Override
    public TKStage createTKStage(StageStyle stageStyle) {
        this.assertToolkitRunning();
        return new WindowStage(verbose, stageStyle).init(this.systemMenu);
    }

    @Override
    public TKStage createTKStage(StageStyle stageStyle, boolean bl, Modality modality, TKStage tKStage) {
        this.assertToolkitRunning();
        return new WindowStage(verbose, stageStyle, bl, modality, tKStage).init(this.systemMenu);
    }

    @Override
    public Object enterNestedEventLoop(Object object) {
        this.checkFxUserThread();
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.eventLoopMap == null) {
            this.eventLoopMap = new HashMap();
        }
        if (this.eventLoopMap.containsKey(object)) {
            throw new IllegalArgumentException("Key already associated with a running event loop: " + object);
        }
        EventLoop eventLoop = Application.GetApplication().createEventLoop();
        this.eventLoopMap.put(object, eventLoop);
        return eventLoop.enter();
    }

    @Override
    public void exitNestedEventLoop(Object object, Object object2) {
        this.checkFxUserThread();
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.eventLoopMap == null || !this.eventLoopMap.containsKey(object)) {
            throw new IllegalArgumentException("Key not associated with a running event loop: " + object);
        }
        EventLoop eventLoop = this.eventLoopMap.get(object);
        this.eventLoopMap.remove(object);
        eventLoop.leave(object2);
    }

    @Override
    public TKStage createTKPopupStage(StageStyle stageStyle, Object object) {
        this.assertToolkitRunning();
        return new PopupStage(verbose, stageStyle, object).init(this.systemMenu);
    }

    @Override
    public TKStage createTKEmbeddedStage(HostInterface hostInterface) {
        this.assertToolkitRunning();
        return new EmbeddedStage(hostInterface);
    }

    @Override
    public ScreenConfigurationAccessor setScreenConfigurationListener(final TKScreenConfigurationListener tKScreenConfigurationListener) {
        Screen.setCallback(new Screen.SettingsChangedCallback(){

            @Override
            public void settingsChanged() {
                QuantumToolkit.notifyScreenListener(tKScreenConfigurationListener);
            }
        });
        return screenAccessor;
    }

    private static void notifyScreenListener(TKScreenConfigurationListener tKScreenConfigurationListener) {
        tKScreenConfigurationListener.screenConfigurationChanged();
    }

    @Override
    public Object getPrimaryScreen() {
        return Screen.getMainScreen();
    }

    @Override
    public List<?> getScreens() {
        return Screen.getScreens();
    }

    public float getMaxPixelScale() {
        if (this._maxPixelScale == 0.0f) {
            try {
                float f = 0.0f;
                for (Object obj : this.getScreens()) {
                    f = Math.max(f, ((Screen)obj).getScale());
                }
                this._maxPixelScale = f;
            }
            catch (Exception exception) {
                return 1.0f;
            }
        }
        return this._maxPixelScale;
    }

    @Override
    public ImageLoader loadImage(String string, int n, int n2, boolean bl, boolean bl2) {
        return new PrismImageLoader2(string, n, n2, bl, this.getMaxPixelScale(), bl2);
    }

    @Override
    public ImageLoader loadImage(InputStream inputStream, int n, int n2, boolean bl, boolean bl2) {
        return new PrismImageLoader2(inputStream, n, n2, bl, bl2);
    }

    public AbstractRemoteResource<? extends ImageLoader> loadImageAsync(AsyncOperationListener asyncOperationListener, String string, int n, int n2, boolean bl, boolean bl2) {
        return new PrismImageLoader2.AsyncImageLoader(asyncOperationListener, string, n, n2, bl, bl2);
    }

    @Override
    public void defer(Runnable runnable) {
        if (!this.toolkitRunning.get()) {
            throw new IllegalStateException("Attempt to call defer when toolkit not running");
        }
        Application.invokeLater(runnable);
    }

    @Override
    public void exit() {
        this.notifyShutdownHooks();
        this.pulseTimer.stop();
        Application application = Application.GetApplication();
        application.terminate();
        this.dispose();
        super.exit();
    }

    public void dispose() {
        if (this.toolkitRunning.compareAndSet(true, false)) {
            this.renderer.stopRenderer();
            if (PrismSettings.shutdownHook) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean isForwardTraversalKey(KeyEvent keyEvent) {
        return keyEvent.getCode() == KeyCode.TAB && keyEvent.getEventType() == KeyEvent.KEY_PRESSED && !keyEvent.isShiftDown();
    }

    @Override
    public boolean isBackwardTraversalKey(KeyEvent keyEvent) {
        return keyEvent.getCode() == KeyCode.TAB && keyEvent.getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isShiftDown();
    }

    @Override
    public Map<Object, Object> getContextMap() {
        return this.contextMap;
    }

    @Override
    public int getRefreshRate() {
        if (pulseHZ == null) {
            return 60;
        }
        return pulseHZ;
    }

    @Override
    public void setAnimationRunnable(DelayedRunnable delayedRunnable) {
        if (delayedRunnable != null) {
            this.animationRunning.set(true);
        }
        this.animationRunnable = delayedRunnable;
    }

    @Override
    public void requestNextPulse() {
        this.nextPulseRequested.set(true);
    }

    @Override
    public void waitFor(Toolkit.Task task) {
        if (task.isFinished()) {
            return;
        }
    }

    @Override
    public PrismPerspectiveCameraImpl createPerspectiveCamera() {
        return new PrismPerspectiveCameraImpl();
    }

    @Override
    public PrismParallelCameraImpl createParallelCamera() {
        return PrismParallelCameraImpl.getInstance();
    }

    @Override
    protected Object createColorPaint(Color color) {
        return new com.sun.prism.paint.Color((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getOpacity());
    }

    private com.sun.prism.paint.Color toPrismColor(Color color) {
        return (com.sun.prism.paint.Color)color.impl_getPlatformPaint();
    }

    private List<Stop> convertStops(List<javafx.scene.paint.Stop> list) {
        ArrayList<Stop> arrayList = new ArrayList<Stop>(list.size());
        for (javafx.scene.paint.Stop stop : list) {
            arrayList.add(new Stop(this.toPrismColor(stop.getColor()), (float)stop.getOffset()));
        }
        return arrayList;
    }

    @Override
    protected Object createLinearGradientPaint(javafx.scene.paint.LinearGradient linearGradient) {
        int n = 2;
        CycleMethod cycleMethod = linearGradient.getCycleMethod();
        if (cycleMethod == CycleMethod.NO_CYCLE) {
            n = 0;
        } else if (cycleMethod == CycleMethod.REFLECT) {
            n = 1;
        }
        List<Stop> list = this.convertStops(linearGradient.getStops());
        return new LinearGradient((float)linearGradient.getStartX(), (float)linearGradient.getStartY(), (float)linearGradient.getEndX(), (float)linearGradient.getEndY(), null, linearGradient.isProportional(), n, list);
    }

    @Override
    protected Object createRadialGradientPaint(RadialGradient radialGradient) {
        float f = (float)radialGradient.getCenterX();
        float f2 = (float)radialGradient.getCenterY();
        float f3 = (float)radialGradient.getFocusAngle();
        float f4 = (float)radialGradient.getFocusDistance();
        int n = 0;
        n = radialGradient.getCycleMethod() == CycleMethod.NO_CYCLE ? 0 : (radialGradient.getCycleMethod() == CycleMethod.REFLECT ? 1 : 2);
        List<Stop> list = this.convertStops(radialGradient.getStops());
        return new com.sun.prism.paint.RadialGradient(f, f2, f3, f4, (float)radialGradient.getRadius(), null, radialGradient.isProportional(), n, list);
    }

    @Override
    protected Object createImagePatternPaint(ImagePattern imagePattern) {
        if (imagePattern.getImage() == null) {
            return com.sun.prism.paint.Color.TRANSPARENT;
        }
        return new com.sun.prism.paint.ImagePattern((com.sun.prism.Image)imagePattern.getImage().impl_getPlatformImage(), (float)imagePattern.getX(), (float)imagePattern.getY(), (float)imagePattern.getWidth(), (float)imagePattern.getHeight(), imagePattern.isProportional());
    }

    private void initStroke(PGShape.StrokeType strokeType, double d, PGShape.StrokeLineCap strokeLineCap, PGShape.StrokeLineJoin strokeLineJoin, float f, float[] fArray, float f2) {
        int n = strokeType == PGShape.StrokeType.CENTERED ? 0 : (strokeType == PGShape.StrokeType.INSIDE ? 1 : 2);
        int n2 = strokeLineCap == PGShape.StrokeLineCap.BUTT ? 0 : (strokeLineCap == PGShape.StrokeLineCap.SQUARE ? 2 : 1);
        int n3 = strokeLineJoin == PGShape.StrokeLineJoin.BEVEL ? 2 : (strokeLineJoin == PGShape.StrokeLineJoin.MITER ? 0 : 1);
        tmpStroke.set(n, (float)d, n2, n3, f);
        if (fArray != null && fArray.length > 0) {
            tmpStroke.set(fArray, f2);
        } else {
            tmpStroke.set(null, 0.0f);
        }
    }

    @Override
    public void accumulateStrokeBounds(Shape shape, float[] fArray, PGShape.StrokeType strokeType, double d, PGShape.StrokeLineCap strokeLineCap, PGShape.StrokeLineJoin strokeLineJoin, float f, BaseTransform baseTransform) {
        this.initStroke(strokeType, d, strokeLineCap, strokeLineJoin, f, null, 0.0f);
        if (baseTransform.isTranslateOrIdentity()) {
            tmpStroke.accumulateShapeBounds(fArray, shape, baseTransform);
        } else {
            Shape.accumulate(fArray, tmpStroke.createStrokedShape(shape), baseTransform);
        }
    }

    @Override
    public boolean strokeContains(Shape shape, double d, double d2, PGShape.StrokeType strokeType, double d3, PGShape.StrokeLineCap strokeLineCap, PGShape.StrokeLineJoin strokeLineJoin, float f) {
        this.initStroke(strokeType, d3, strokeLineCap, strokeLineJoin, f, null, 0.0f);
        return tmpStroke.createStrokedShape(shape).contains((float)d, (float)d2);
    }

    @Override
    public Shape createStrokedShape(Shape shape, PGShape.StrokeType strokeType, double d, PGShape.StrokeLineCap strokeLineCap, PGShape.StrokeLineJoin strokeLineJoin, float f, float[] fArray, float f2) {
        this.initStroke(strokeType, d, strokeLineCap, strokeLineJoin, f, fArray, f2);
        return tmpStroke.createStrokedShape(shape);
    }

    @Override
    public Dimension2D getBestCursorSize(int n, int n2) {
        return CursorUtils.getBestCursorSize(n, n2);
    }

    @Override
    public int getMaximumCursorColors() {
        return 2;
    }

    @Override
    public int getKeyCodeForChar(String string) {
        return string.length() == 1 ? com.sun.glass.events.KeyEvent.getKeyCodeForChar(string.charAt(0)) : 0;
    }

    @Override
    public MouseEvent convertMouseEventToFX(Object object) {
        if (object instanceof GlassPrismMouseEvent) {
            return PrismEventUtils.glassMouseEventToFX((GlassPrismMouseEvent)object);
        }
        if (object instanceof MouseEvent) {
            return (MouseEvent)object;
        }
        return null;
    }

    @Override
    public KeyEvent convertKeyEventToFX(Object object) {
        if (object instanceof GlassPrismKeyEvent) {
            return PrismEventUtils.glassKeyEventToFX((GlassPrismKeyEvent)object);
        }
        if (object instanceof KeyEvent) {
            return (KeyEvent)object;
        }
        return null;
    }

    @Override
    public InputMethodEvent convertInputMethodEventToFX(Object object) {
        if (object instanceof GlassPrismInputMethodEvent) {
            return PrismEventUtils.glassInputMethodEventToFX((GlassPrismInputMethodEvent)object);
        }
        if (object instanceof InputMethodEvent) {
            return (InputMethodEvent)object;
        }
        return null;
    }

    @Override
    public PathElement[] convertShapeToFXPath(Object object) {
        if (object == null) {
            return new PathElement[0];
        }
        ArrayList<MoveTo> arrayList = new ArrayList<MoveTo>();
        Shape shape = (Shape)object;
        PathIterator pathIterator = shape.getPathIterator(null);
        PathIteratorHelper pathIteratorHelper = new PathIteratorHelper(pathIterator);
        PathIteratorHelper.Struct struct = new PathIteratorHelper.Struct();
        while (!pathIteratorHelper.isDone()) {
            PathElement pathElement;
            boolean bl = pathIteratorHelper.getWindingRule() == 0;
            int n = pathIteratorHelper.currentSegment(struct);
            if (n == 0) {
                pathElement = new MoveTo(struct.f0, struct.f1);
            } else if (n == 1) {
                pathElement = new LineTo(struct.f0, struct.f1);
            } else if (n == 2) {
                pathElement = new QuadCurveTo(struct.f0, struct.f1, struct.f2, struct.f3);
            } else if (n == 3) {
                pathElement = new CubicCurveTo(struct.f0, struct.f1, struct.f2, struct.f3, struct.f4, struct.f5);
            } else if (n == 4) {
                pathElement = new ClosePath();
            } else {
                throw new IllegalStateException("Invalid element type: " + n);
            }
            pathIteratorHelper.next();
            arrayList.add((MoveTo)pathElement);
        }
        return arrayList.toArray(new PathElement[arrayList.size()]);
    }

    @Override
    public HitInfo convertHitInfoToFX(Object object) {
        Integer n = (Integer)object;
        HitInfo hitInfo = new HitInfo();
        hitInfo.setCharIndex(n);
        hitInfo.setLeading(true);
        return hitInfo;
    }

    @Override
    public Filterable toFilterable(Image image) {
        return PrImage.create((com.sun.prism.Image)image.impl_getPlatformImage());
    }

    @Override
    public FilterContext getFilterContext(Object object) {
        if (object == null || !(object instanceof Screen)) {
            return PrFilterContext.getDefaultInstance();
        }
        Screen screen = (Screen)object;
        return PrFilterContext.getInstance(screen);
    }

    @Override
    public AbstractMasterTimer getMasterTimer() {
        return MasterTimer.getInstance();
    }

    @Override
    public FontLoader getFontLoader() {
        return PrismFontLoader.getInstance();
    }

    @Override
    public PGArc createPGArc() {
        return new NGArc();
    }

    @Override
    public PGCircle createPGCircle() {
        return new NGCircle();
    }

    @Override
    public PGCubicCurve createPGCubicCurve() {
        return new NGCubicCurve();
    }

    @Override
    public PGEllipse createPGEllipse() {
        return new NGEllipse();
    }

    @Override
    public PGLine createPGLine() {
        return new NGLine();
    }

    @Override
    public PGPath createPGPath() {
        return new NGPath();
    }

    @Override
    public PGSVGPath createPGSVGPath() {
        return new NGSVGPath();
    }

    @Override
    public PGPolygon createPGPolygon() {
        return new NGPolygon();
    }

    @Override
    public PGPolyline createPGPolyline() {
        return new NGPolyline();
    }

    @Override
    public PGQuadCurve createPGQuadCurve() {
        return new NGQuadCurve();
    }

    @Override
    public PGRectangle createPGRectangle() {
        return new NGRectangle();
    }

    @Override
    public PGImageView createPGImageView() {
        return new NGImageView();
    }

    @Override
    public PGMediaView createPGMediaView() {
        return new NGMediaView();
    }

    @Override
    public PGGroup createPGGroup() {
        return new NGGroup();
    }

    @Override
    public PGText createPGText() {
        return new NGText();
    }

    @Override
    public PGRegion createPGRegion() {
        return new NGRegion();
    }

    @Override
    public PGCanvas createPGCanvas() {
        return new NGCanvas();
    }

    @Override
    public Object createSVGPathObject(SVGPath sVGPath) {
        int n = sVGPath.getFillRule() == FillRule.NON_ZERO ? 1 : 0;
        Path2D path2D = new Path2D(n);
        path2D.appendSVGPath(sVGPath.getContent());
        return path2D;
    }

    @Override
    public Path2D createSVGPath2D(SVGPath sVGPath) {
        int n = sVGPath.getFillRule() == FillRule.NON_ZERO ? 1 : 0;
        Path2D path2D = new Path2D(n);
        path2D.appendSVGPath(sVGPath.getContent());
        return path2D;
    }

    @Override
    public boolean imageContains(Object object, float f, float f2) {
        if (object == null) {
            return false;
        }
        com.sun.prism.Image image = (com.sun.prism.Image)object;
        int n = (int)f + image.getMinX();
        int n2 = (int)f2 + image.getMinY();
        if (image.getPixelFormat().isOpaque()) {
            return true;
        }
        if (image.getPixelFormat() == PixelFormat.INT_ARGB_PRE) {
            IntBuffer intBuffer = (IntBuffer)image.getPixelBuffer();
            int n3 = n + n2 * image.getRowLength();
            if (n3 >= intBuffer.limit()) {
                return false;
            }
            return (intBuffer.get(n3) & 0xFF000000) != 0;
        }
        if (image.getPixelFormat() == PixelFormat.BYTE_BGRA_PRE) {
            ByteBuffer byteBuffer = (ByteBuffer)image.getPixelBuffer();
            int n4 = n * image.getBytesPerPixelUnit() + n2 * image.getScanlineStride() + 3;
            if (n4 >= byteBuffer.limit()) {
                return false;
            }
            return (byteBuffer.get(n4) & 0xFF) != 0;
        }
        if (image.getPixelFormat() == PixelFormat.BYTE_ALPHA) {
            ByteBuffer byteBuffer = (ByteBuffer)image.getPixelBuffer();
            int n5 = n * image.getBytesPerPixelUnit() + n2 * image.getScanlineStride();
            if (n5 >= byteBuffer.limit()) {
                return false;
            }
            return (byteBuffer.get(n5) & 0xFF) != 0;
        }
        return true;
    }

    @Override
    public boolean isSupported(ConditionalFeature conditionalFeature) {
        if (conditionalFeature == ConditionalFeature.SCENE3D) {
            return GraphicsPipeline.getPipeline().is3DSupported();
        }
        if (conditionalFeature == ConditionalFeature.EFFECT) {
            return GraphicsPipeline.getPipeline().isEffectSupported();
        }
        if (conditionalFeature == ConditionalFeature.SHAPE_CLIP) {
            return true;
        }
        if (conditionalFeature == ConditionalFeature.INPUT_METHOD) {
            return false;
        }
        if (conditionalFeature == ConditionalFeature.TRANSPARENT_WINDOW) {
            return Application.GetApplication().supportsTransparentWindows();
        }
        return false;
    }

    @Override
    public TKClipboard getSystemClipboard() {
        if (this.clipboard == null) {
            this.clipboard = QuantumClipboard.getClipboardInstance(new ClipboardAssistance("SYSTEM"));
        }
        return this.clipboard;
    }

    @Override
    public TKSystemMenu getSystemMenu() {
        return this.systemMenu;
    }

    @Override
    public TKClipboard getNamedClipboard(String string) {
        return null;
    }

    @Override
    public DragEvent convertDragRecognizedEventToFX(Object object, Dragboard dragboard) {
        return PrismEventUtils.glassDragGestureToFX((GlassDragEvent)object, dragboard);
    }

    @Override
    public DragEvent convertDragSourceEventToFX(Object object, Dragboard dragboard) {
        return PrismEventUtils.glassDragSourceEventToFX((GlassDragEvent)object, dragboard);
    }

    @Override
    public DragEvent convertDropTargetEventToFX(Object object, Dragboard dragboard) {
        return PrismEventUtils.glassDropTargetEventToFX((GlassDragEvent)object, dragboard);
    }

    @Override
    public Dragboard createDragboard() {
        QuantumClipboard quantumClipboard = QuantumClipboard.getDragboardInstance(new ClipboardAssistance("DND"){

            @Override
            public void actionPerformed(final int n) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        if (QuantumToolkit.this.dragSourceClipboard != null && QuantumToolkit.this.dragSourceScene != null && ((QuantumToolkit)QuantumToolkit.this).dragSourceScene.dragSourceListener != null) {
                            Dragboard dragboard = Dragboard.impl_create(QuantumToolkit.this.dragSourceClipboard);
                            GlassDragEvent glassDragEvent = new GlassDragEvent(2, 0, 0, 0, 0, dragboard, 0, QuantumToolkit.this.dragSourceScene, n);
                            ((QuantumToolkit)QuantumToolkit.this).dragSourceScene.dragSourceListener.dragDropEnd(glassDragEvent);
                        }
                        QuantumToolkit.this.dragSourceClipboard = null;
                        QuantumToolkit.this.dragSourceScene = null;
                        return null;
                    }
                }, QuantumToolkit.this.dragSourceScene.getAccessControlContext());
            }
        });
        return Dragboard.impl_create(quantumClipboard);
    }

    @Override
    public void startDrag(Object object, Set<TransferMode> set, TKDragSourceListener tKDragSourceListener, Dragboard dragboard) {
        GlassScene glassScene;
        Object object2;
        if (dragboard == null) {
            throw new IllegalArgumentException("dragboard should not be null");
        }
        if (object instanceof GlassDragEvent) {
            object2 = (GlassDragEvent)object;
            glassScene = ((GlassDragEvent)object2).getGlassScene();
        } else if (object instanceof GlassScene) {
            glassScene = (GlassScene)object;
        } else {
            throw new IllegalArgumentException("o should be either a GlassScene, or a GlassDragEvent instance");
        }
        glassScene.setTKDragSourceListener(tKDragSourceListener);
        this.dragSourceClipboard = object2 = (QuantumClipboard)dragboard.impl_getPeer();
        this.dragSourceScene = glassScene;
        ((QuantumClipboard)object2).setSupportedTransferMode(set);
        ((QuantumClipboard)object2).flush();
        ((QuantumClipboard)object2).close();
    }

    @Override
    public void enableDrop(TKScene tKScene, TKDropTargetListener tKDropTargetListener) {
        assert (tKScene instanceof GlassScene);
        GlassScene glassScene = (GlassScene)tKScene;
        glassScene.setTKDropTargetListener(tKDropTargetListener);
    }

    @Override
    public void registerDragGestureListener(TKScene tKScene, Set<TransferMode> set, TKDragGestureListener tKDragGestureListener) {
        assert (tKScene instanceof GlassScene);
        GlassScene glassScene = (GlassScene)tKScene;
        glassScene.setTKDragGestureListener(tKDragGestureListener);
    }

    @Override
    public boolean isAppletDragSupported() {
        return false;
    }

    @Override
    public void installInputMethodRequests(TKScene tKScene, InputMethodRequests inputMethodRequests) {
        assert (tKScene instanceof GlassScene);
        GlassScene glassScene = (GlassScene)tKScene;
        glassScene.setInputMethodRequests(inputMethodRequests);
    }

    @Override
    public boolean isExternalFormatSupported(Class clazz) {
        return ExternalImageTools.isFormatSupported(clazz);
    }

    @Override
    public ImageLoader loadPlatformImage(Object object) {
        if (object instanceof QuantumImage) {
            return (QuantumImage)object;
        }
        if (object instanceof com.sun.prism.Image) {
            return new QuantumImage((com.sun.prism.Image)object);
        }
        ExternalImageTools.IImporter iImporter = ExternalImageTools.getImporter(object);
        if (iImporter != null) {
            return new QuantumImage(iImporter.loadExternalImage(object));
        }
        throw new UnsupportedOperationException("unsupported class for loadPlatformImage");
    }

    @Override
    public PlatformImage createPlatformImage(int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n * n2 * 4);
        return com.sun.prism.Image.fromByteBgraPreData(byteBuffer, n, n2);
    }

    @Override
    public Object renderToImage(Toolkit.ImageRenderingContext imageRenderingContext) {
        Object object = imageRenderingContext.platformImage;
        final Toolkit.ImageRenderingContext imageRenderingContext2 = imageRenderingContext;
        final Paint paint = imageRenderingContext.platformPaint instanceof Paint ? (Paint)imageRenderingContext.platformPaint : null;
        RenderJob renderJob = new RenderJob(new Runnable(){

            private com.sun.prism.paint.Color getClearColor() {
                if (paint == null) {
                    return com.sun.prism.paint.Color.WHITE;
                }
                if (paint.getType() == Paint.Type.COLOR) {
                    return (com.sun.prism.paint.Color)paint;
                }
                if (paint.isOpaque()) {
                    return com.sun.prism.paint.Color.TRANSPARENT;
                }
                return com.sun.prism.paint.Color.WHITE;
            }

            private void draw(Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.setDepthBuffer(imageRenderingContext2.depthBuffer);
                graphics.clear(this.getClearColor());
                if (paint != null && paint.getType() != Paint.Type.COLOR) {
                    graphics.getRenderTarget().setOpaque(paint.isOpaque());
                    graphics.setPaint(paint);
                    graphics.fillQuad(0.0f, 0.0f, n3, n4);
                }
                if (n != 0 || n2 != 0) {
                    graphics.translate(-n, -n2);
                }
                if (imageRenderingContext2.transform != null) {
                    graphics.transform(imageRenderingContext2.transform);
                }
                if (imageRenderingContext2.root != null) {
                    if (imageRenderingContext2.camera instanceof PrismCameraImpl) {
                        graphics.setCamera((PrismCameraImpl)imageRenderingContext2.camera);
                    }
                    NGNode nGNode = (NGNode)imageRenderingContext2.root;
                    nGNode.render(graphics);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
                if (!resourceFactory.isDeviceReady()) {
                    return;
                }
                int n = imageRenderingContext2.x;
                int n2 = imageRenderingContext2.y;
                int n3 = imageRenderingContext2.width;
                int n4 = imageRenderingContext2.height;
                if (n3 <= 0 || n4 <= 0) {
                    return;
                }
                RenderingContext renderingContext = resourceFactory.createRenderingContext(null);
                try {
                    renderingContext.begin();
                    QuantumImage quantumImage = imageRenderingContext2.platformImage instanceof QuantumImage ? (QuantumImage)imageRenderingContext2.platformImage : new QuantumImage(null);
                    RTTexture rTTexture = quantumImage.getRT(n3, n4, resourceFactory);
                    if (rTTexture == null) {
                        return;
                    }
                    Graphics graphics = rTTexture.createGraphics();
                    this.draw(graphics, n, n2, n3, n4);
                    int[] nArray = quantumImage.rt.getPixels();
                    if (nArray != null) {
                        quantumImage.setImage(com.sun.prism.Image.fromIntArgbPreData(nArray, n3, n4));
                    } else {
                        IntBuffer intBuffer = IntBuffer.allocate(n3 * n4);
                        if (quantumImage.rt.readPixels(intBuffer)) {
                            quantumImage.setImage(com.sun.prism.Image.fromIntArgbPreData(intBuffer, n3, n4));
                        } else {
                            quantumImage.dispose();
                            quantumImage = null;
                        }
                    }
                    imageRenderingContext2.platformImage = quantumImage;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                finally {
                    Disposer.cleanUp();
                    renderingContext.end();
                }
            }
        });
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        renderJob.setCompletionListener(new CompletionListener(){

            @Override
            public void done(RenderJob renderJob) {
                countDownLatch.countDown();
            }
        });
        Future future = this.addRenderJob(renderJob);
        while (true) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
        Object object2 = imageRenderingContext2.platformImage;
        imageRenderingContext2.platformImage = object;
        return object2;
    }

    @Override
    public Object toExternalImage(Object object, Object object2) {
        boolean bl = object instanceof com.sun.prism.Image;
        ExternalImageTools.IExporter iExporter = bl && object2 != null ? ExternalImageTools.getExporter(object2) : null;
        return iExporter != null ? iExporter.exportPrismImage((com.sun.prism.Image)object, object2) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> showFileChooser(TKStage tKStage, String string, File file, String string2, FileChooserType fileChooserType, List<FileChooser.ExtensionFilter> list) {
        WindowStage windowStage = null;
        try {
            windowStage = this.blockOwnerStage(tKStage);
            List<File> list2 = CommonDialogs.showFileChooser(tKStage instanceof WindowStage ? ((WindowStage)tKStage).getPlatformWindow() : null, file, string2, string, fileChooserType == FileChooserType.SAVE ? 1 : 0, fileChooserType == FileChooserType.OPEN_MULTIPLE, QuantumToolkit.convertExtensionFilters(list));
            return list2;
        }
        finally {
            if (windowStage != null) {
                windowStage.setEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File showDirectoryChooser(TKStage tKStage, String string, File file) {
        WindowStage windowStage = null;
        try {
            windowStage = this.blockOwnerStage(tKStage);
            File file2 = CommonDialogs.showFolderChooser(tKStage instanceof WindowStage ? ((WindowStage)tKStage).getPlatformWindow() : null, file, string);
            return file2;
        }
        finally {
            if (windowStage != null) {
                windowStage.setEnabled(true);
            }
        }
    }

    private WindowStage blockOwnerStage(TKStage tKStage) {
        TKStage tKStage2;
        if (tKStage instanceof WindowStage && (tKStage2 = ((WindowStage)tKStage).getOwner()) instanceof WindowStage) {
            WindowStage windowStage = (WindowStage)tKStage2;
            windowStage.setEnabled(false);
            return windowStage;
        }
        return null;
    }

    private static List<CommonDialogs.ExtensionFilter> convertExtensionFilters(List<FileChooser.ExtensionFilter> list) {
        CommonDialogs.ExtensionFilter[] extensionFilterArray = new CommonDialogs.ExtensionFilter[list.size()];
        int n = 0;
        for (FileChooser.ExtensionFilter extensionFilter : list) {
            extensionFilterArray[n++] = new CommonDialogs.ExtensionFilter(extensionFilter.getDescription(), extensionFilter.getExtensions());
        }
        return Arrays.asList(extensionFilterArray);
    }

    @Override
    public long getMultiClickTime() {
        return View.getMultiClickTime();
    }

    @Override
    public int getMultiClickMaxX() {
        return View.getMultiClickMaxX();
    }

    @Override
    public int getMultiClickMaxY() {
        return View.getMultiClickMaxY();
    }

    static AccessControlContext intersectWithCurrentContext(final AccessControlContext accessControlContext) {
        if (accessControlContext == null) {
            return null;
        }
        final AccessControlContext accessControlContext2 = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                try {
                    Class<?> clazz = Class.forName("sun.misc.SharedSecrets");
                    Method method = clazz.getMethod("getJavaSecurityAccess", null);
                    Object object = method.invoke(clazz, new Object[0]);
                    Class<?> clazz2 = Class.forName("sun.misc.JavaSecurityAccess");
                    Method method2 = clazz2.getMethod("doIntersectionPrivilege", PrivilegedAction.class, AccessControlContext.class, AccessControlContext.class);
                    return (AccessControlContext)method2.invoke(object, new PrivilegedAction<AccessControlContext>(){

                        @Override
                        public AccessControlContext run() {
                            return AccessController.getContext();
                        }
                    }, accessControlContext2, accessControlContext);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    static class QuantumImage
    implements ImageLoader,
    ResourceFactoryListener {
        private RTTexture rt;
        private com.sun.prism.Image image;
        private ResourceFactory rf;

        QuantumImage(com.sun.prism.Image image) {
            this.image = image;
        }

        RTTexture getRT(int n, int n2, ResourceFactory resourceFactory) {
            boolean bl;
            boolean bl2 = bl = this.rt != null && this.rf == resourceFactory && this.rt.getContentWidth() == n && this.rt.getContentHeight() == n2;
            if (!bl) {
                if (this.rt != null) {
                    this.rt.dispose();
                }
                if (this.rf != null) {
                    this.rf.removeFactoryListener(this);
                    this.rf = null;
                }
                this.rt = resourceFactory.createRTTexture(n, n2);
                if (this.rt != null) {
                    this.rf = resourceFactory;
                    this.rf.addFactoryListener(this);
                }
            }
            return this.rt;
        }

        void dispose() {
            if (this.rt != null) {
                this.rt.dispose();
                this.rt = null;
            }
        }

        void setImage(com.sun.prism.Image image) {
            this.image = image;
        }

        @Override
        public boolean getError() {
            return this.image == null;
        }

        @Override
        public int getFrameCount() {
            return 1;
        }

        @Override
        public PlatformImage[] getFrames() {
            return new PlatformImage[]{this.image};
        }

        @Override
        public PlatformImage getFrame(int n) {
            return this.image;
        }

        @Override
        public int getFrameDelay(int n) {
            return 0;
        }

        @Override
        public int getWidth() {
            return this.image.getWidth();
        }

        @Override
        public int getHeight() {
            return this.image.getHeight();
        }

        @Override
        public void factoryReset() {
            this.dispose();
        }

        @Override
        public void factoryReleased() {
            this.dispose();
        }
    }
}

