/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.TruffleOptions;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

final class TypeAndClass<T> {
    static final TypeAndClass<Object> ANY = new TypeAndClass<Object>(null, Object.class);
    private final Object type;
    final Class<T> clazz;

    TypeAndClass(Type type, Class<T> clazz) {
        this.type = type;
        this.clazz = clazz;
    }

    T cast(Object o) {
        return this.clazz.cast(o);
    }

    TypeAndClass<?> getParameterType(int i) {
        if (!TruffleOptions.AOT && this.type instanceof ParameterizedType) {
            ParameterizedType parametrizedType = (ParameterizedType)this.type;
            Type[] arr = parametrizedType.getActualTypeArguments();
            Class elementClass = Object.class;
            if (arr.length > i) {
                Type elementType = arr[i];
                if (elementType instanceof ParameterizedType) {
                    elementType = ((ParameterizedType)elementType).getRawType();
                }
                if (elementType instanceof Class) {
                    elementClass = (Class)elementType;
                }
            }
            return new TypeAndClass<Object>(arr[i], elementClass);
        }
        return ANY;
    }

    public String toString() {
        return "[" + this.clazz + ": " + Objects.toString(this.type) + "]";
    }

    static TypeAndClass<?> forReturnType(Method method) {
        if (method == null || method.getReturnType() == Void.TYPE) {
            return ANY;
        }
        return new TypeAndClass(method.getGenericReturnType(), method.getReturnType());
    }
}

