/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.aot;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;

public interface RootedFileVisitor<T>
extends FileVisitor<T> {
    public void setRoot(T var1);

    public T getRoot();

    public static String rubyJarPath() {
        String[] paths;
        String svmJarPath = RootedFileVisitor.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        String parentDir = new File(svmJarPath).getParent();
        for (String path : paths = new String[]{parentDir + "/../mx.imports/binary/jruby/mxbuild/dists/ruby.jar", parentDir + "/../../../jruby/mxbuild/dists/ruby.jar", parentDir + "/../../../main/mxbuild/dists/ruby.jar"}) {
            File ret = new File(path);
            if (!ret.exists()) continue;
            try {
                return ret.getCanonicalPath();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public static void visitEachFileOnClassPath(RootedFileVisitor<Path> visitor) {
        try (FileSystem jarFileSystem = FileSystems.newFileSystem(URI.create("jar:file:" + RootedFileVisitor.rubyJarPath()), Collections.emptyMap());){
            Path root = jarFileSystem.getPath("/", new String[0]);
            visitor.setRoot(root);
            Files.walkFileTree(root, visitor);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }
}

