/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format;

import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;

public enum FormatEncoding {
    DEFAULT(ASCIIEncoding.INSTANCE),
    ASCII_8BIT(ASCIIEncoding.INSTANCE),
    US_ASCII(USASCIIEncoding.INSTANCE),
    UTF_8(UTF8Encoding.INSTANCE);

    private final Encoding encoding;

    private FormatEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public Encoding getEncodingForLength(int length) {
        if (length == 0) {
            return USASCIIEncoding.INSTANCE;
        }
        return this.encoding;
    }

    public FormatEncoding unifyWith(FormatEncoding other) {
        if (this == DEFAULT) {
            return other;
        }
        if (other == DEFAULT) {
            return this;
        }
        switch (other) {
            case ASCII_8BIT: 
            case US_ASCII: {
                return ASCII_8BIT;
            }
            case UTF_8: {
                switch (this) {
                    case ASCII_8BIT: 
                    case US_ASCII: {
                        return ASCII_8BIT;
                    }
                    case UTF_8: {
                        return UTF_8;
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }
}

