/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.MissingValue;
import org.jruby.truffle.core.format.exceptions.InvalidFormatException;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.string.StringUtils;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadUTF8CharacterNode
extends FormatNode {
    private final ConditionProfile rangeProfile = ConditionProfile.createBinaryProfile();

    @Specialization(guards={"isNull(source)"})
    public void read(VirtualFrame frame, Object source) {
        this.advanceSourcePosition(frame, 1);
        throw new IllegalStateException();
    }

    @Specialization
    public Object read(VirtualFrame frame, byte[] source, @Cached(value="create()") BranchProfile errorProfile) {
        int length;
        int index = this.getSourcePosition(frame);
        int sourceLength = this.getSourceLength(frame);
        assert (index != -1);
        if (this.rangeProfile.profile(index >= sourceLength)) {
            return MissingValue.INSTANCE;
        }
        long codepoint = source[index] & 0xFF;
        if (codepoint >> 7 == 0L) {
            length = 1;
            codepoint &= 0x7FL;
        } else if (codepoint >> 5 == 6L) {
            length = 2;
            codepoint &= 0x1FL;
        } else if (codepoint >> 4 == 14L) {
            length = 3;
            codepoint &= 0xFL;
        } else if (codepoint >> 3 == 30L) {
            length = 4;
            codepoint &= 7L;
        } else if (codepoint >> 2 == 62L) {
            length = 5;
            codepoint &= 3L;
        } else if (codepoint >> 1 == 126L) {
            length = 6;
            codepoint &= 1L;
        } else {
            length = 1;
        }
        if (index + length > sourceLength) {
            errorProfile.enter();
            throw new InvalidFormatException(this.formatError(index, sourceLength, length));
        }
        for (int n = 1; n < length; ++n) {
            codepoint <<= 6;
            codepoint |= (long)(source[index + n] & 0x3F);
        }
        this.setSourcePosition(frame, index + length);
        return codepoint;
    }

    @CompilerDirectives.TruffleBoundary
    private String formatError(int index, int sourceLength, int length) {
        return StringUtils.format("malformed UTF-8 character (expected %d bytes, given %d bytes)", length, sourceLength - index);
    }
}

