/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.hash.HashGuards;
import org.jruby.truffle.core.hash.SetNode;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=SetNode.class)
public final class SetNodeGen
extends SetNode
implements SpecializedNode {
    @Node.Child
    private RubyNode hash_;
    @Node.Child
    private RubyNode key_;
    @Node.Child
    private RubyNode value_;
    @Node.Child
    private RubyNode byIdentity_;
    @CompilerDirectives.CompilationFinal
    private Class<?> byIdentityType_;
    @Node.Child
    private BaseNode_ specialization_;

    private SetNodeGen(RubyNode hash, RubyNode key, RubyNode value, RubyNode byIdentity) {
        this.hash_ = hash;
        this.key_ = key;
        this.value_ = value;
        this.byIdentity_ = byIdentity;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeSet(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
        return this.specialization_.execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static SetNode create(RubyNode hash, RubyNode key, RubyNode value, RubyNode byIdentity) {
        return new SetNodeGen(hash, key, value, byIdentity);
    }

    @GeneratedBy(methodName="setBuckets(VirtualFrame, DynamicObject, Object, Object, boolean, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile)", value=SetNode.class)
    private static final class SetBucketsNode_
    extends BaseNode_ {
        private final ConditionProfile byIdentityProfile;
        private final ConditionProfile foundProfile;
        private final ConditionProfile bucketCollisionProfile;
        private final ConditionProfile appendingProfile;
        private final ConditionProfile resizeProfile;

        SetBucketsNode_(SetNodeGen root, ConditionProfile byIdentityProfile, ConditionProfile foundProfile, ConditionProfile bucketCollisionProfile, ConditionProfile appendingProfile, ConditionProfile resizeProfile) {
            super(root, 3);
            this.byIdentityProfile = byIdentityProfile;
            this.foundProfile = foundProfile;
            this.bucketCollisionProfile = bucketCollisionProfile;
            this.appendingProfile = appendingProfile;
            this.resizeProfile = resizeProfile;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean byIdentityValue_;
            DynamicObject hashValue_;
            try {
                hashValue_ = this.root.hash_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object keyValue = this.root.key_.execute(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_(frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), keyValue, valueValue, byIdentityValue);
            }
            Object keyValue_ = this.root.key_.execute(frameValue);
            Object valueValue_ = this.root.value_.execute(frameValue);
            try {
                byIdentityValue_ = this.root.byIdentity_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, ex.getResult());
            }
            if (HashGuards.isBucketHash(hashValue_)) {
                return this.root.setBuckets(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_, this.byIdentityProfile, this.foundProfile, this.bucketCollisionProfile, this.appendingProfile, this.resizeProfile);
            }
            return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            if (HashGuards.isBucketHash(hashValue)) {
                return this.root.setBuckets(frameValue, hashValue, keyValue, valueValue, byIdentityValue, this.byIdentityProfile, this.foundProfile, this.bucketCollisionProfile, this.appendingProfile, this.resizeProfile);
            }
            return this.getNext().execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isBucketHash(hashValue_)) {
                    return this.root.setBuckets(frameValue, hashValue_, keyValue, valueValue, byIdentityValue_, this.byIdentityProfile, this.foundProfile, this.bucketCollisionProfile, this.appendingProfile, this.resizeProfile);
                }
            }
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root, ConditionProfile byIdentityProfile, ConditionProfile foundProfile, ConditionProfile bucketCollisionProfile, ConditionProfile appendingProfile, ConditionProfile resizeProfile) {
            return new SetBucketsNode_(root, byIdentityProfile, foundProfile, bucketCollisionProfile, appendingProfile, resizeProfile);
        }
    }

    @GeneratedBy(methodName="setPackedArray(VirtualFrame, DynamicObject, Object, Object, boolean, ConditionProfile, ConditionProfile, BranchProfile)", value=SetNode.class)
    private static final class SetPackedArrayNode_
    extends BaseNode_ {
        private final ConditionProfile byIdentityProfile;
        private final ConditionProfile strategyProfile;
        private final BranchProfile extendProfile;

        SetPackedArrayNode_(SetNodeGen root, ConditionProfile byIdentityProfile, ConditionProfile strategyProfile, BranchProfile extendProfile) {
            super(root, 2);
            this.byIdentityProfile = byIdentityProfile;
            this.strategyProfile = strategyProfile;
            this.extendProfile = extendProfile;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean byIdentityValue_;
            DynamicObject hashValue_;
            try {
                hashValue_ = this.root.hash_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object keyValue = this.root.key_.execute(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_(frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), keyValue, valueValue, byIdentityValue);
            }
            Object keyValue_ = this.root.key_.execute(frameValue);
            Object valueValue_ = this.root.value_.execute(frameValue);
            try {
                byIdentityValue_ = this.root.byIdentity_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, ex.getResult());
            }
            if (HashGuards.isPackedHash(hashValue_)) {
                return this.root.setPackedArray(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_, this.byIdentityProfile, this.strategyProfile, this.extendProfile);
            }
            return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            if (HashGuards.isPackedHash(hashValue)) {
                return this.root.setPackedArray(frameValue, hashValue, keyValue, valueValue, byIdentityValue, this.byIdentityProfile, this.strategyProfile, this.extendProfile);
            }
            return this.getNext().execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isPackedHash(hashValue_)) {
                    return this.root.setPackedArray(frameValue, hashValue_, keyValue, valueValue, byIdentityValue_, this.byIdentityProfile, this.strategyProfile, this.extendProfile);
                }
            }
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root, ConditionProfile byIdentityProfile, ConditionProfile strategyProfile, BranchProfile extendProfile) {
            return new SetPackedArrayNode_(root, byIdentityProfile, strategyProfile, extendProfile);
        }
    }

    @GeneratedBy(methodName="setNull(VirtualFrame, DynamicObject, Object, Object, boolean, ConditionProfile)", value=SetNode.class)
    private static final class SetNullNode_
    extends BaseNode_ {
        private final ConditionProfile byIdentityProfile;

        SetNullNode_(SetNodeGen root, ConditionProfile byIdentityProfile) {
            super(root, 1);
            this.byIdentityProfile = byIdentityProfile;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean byIdentityValue_;
            DynamicObject hashValue_;
            try {
                hashValue_ = this.root.hash_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object keyValue = this.root.key_.execute(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                Object byIdentityValue = this.executeByIdentity_(frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), keyValue, valueValue, byIdentityValue);
            }
            Object keyValue_ = this.root.key_.execute(frameValue);
            Object valueValue_ = this.root.value_.execute(frameValue);
            try {
                byIdentityValue_ = this.root.byIdentity_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, ex.getResult());
            }
            if (HashGuards.isNullHash(hashValue_)) {
                return this.root.setNull(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_, this.byIdentityProfile);
            }
            return this.getNext().execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            if (HashGuards.isNullHash(hashValue)) {
                return this.root.setNull(frameValue, hashValue, keyValue, valueValue, byIdentityValue, this.byIdentityProfile);
            }
            return this.getNext().execute1(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                boolean byIdentityValue_ = (Boolean)byIdentityValue;
                if (HashGuards.isNullHash(hashValue_)) {
                    return this.root.setNull(frameValue, hashValue_, keyValue, valueValue, byIdentityValue_, this.byIdentityProfile);
                }
            }
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root, ConditionProfile byIdentityProfile) {
            return new SetNullNode_(root, byIdentityProfile);
        }
    }

    @GeneratedBy(value=SetNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(SetNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, hashValue, keyValue, valueValue, byIdentityValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            return this.getNext().execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=SetNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(SetNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            return this.uninitialized((Frame)frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        static BaseNode_ create(SetNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=SetNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected SetNodeGen root;

        BaseNode_(SetNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (SetNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.hash_, this.root.key_, this.root.value_, this.root.byIdentity_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            return this.execute_((VirtualFrame)frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

        public Object execute1(VirtualFrame frameValue, DynamicObject hashValue, Object keyValue, Object valueValue, boolean byIdentityValue) {
            return this.execute_(frameValue, hashValue, keyValue, valueValue, byIdentityValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object hashValue_ = this.root.hash_.execute(frameValue);
            Object keyValue_ = this.root.key_.execute(frameValue);
            Object valueValue_ = this.root.value_.execute(frameValue);
            Object byIdentityValue_ = this.executeByIdentity_(frameValue);
            return this.execute_(frameValue, hashValue_, keyValue_, valueValue_, byIdentityValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object hashValue, Object keyValue, Object valueValue, Object byIdentityValue) {
            if (hashValue instanceof DynamicObject && byIdentityValue instanceof Boolean) {
                DynamicObject hashValue_ = (DynamicObject)hashValue;
                if (HashGuards.isNullHash(hashValue_)) {
                    ConditionProfile byIdentityProfile1 = ConditionProfile.createBinaryProfile();
                    return SetNullNode_.create(this.root, byIdentityProfile1);
                }
                if (HashGuards.isPackedHash(hashValue_)) {
                    ConditionProfile byIdentityProfile2 = ConditionProfile.createBinaryProfile();
                    ConditionProfile strategyProfile2 = ConditionProfile.createBinaryProfile();
                    BranchProfile extendProfile2 = BranchProfile.create();
                    return SetPackedArrayNode_.create(this.root, byIdentityProfile2, strategyProfile2, extendProfile2);
                }
                if (HashGuards.isBucketHash(hashValue_)) {
                    ConditionProfile byIdentityProfile3 = ConditionProfile.createBinaryProfile();
                    ConditionProfile foundProfile3 = ConditionProfile.createBinaryProfile();
                    ConditionProfile bucketCollisionProfile3 = ConditionProfile.createBinaryProfile();
                    ConditionProfile appendingProfile3 = ConditionProfile.createBinaryProfile();
                    ConditionProfile resizeProfile3 = ConditionProfile.createBinaryProfile();
                    return SetBucketsNode_.create(this.root, byIdentityProfile3, foundProfile3, bucketCollisionProfile3, appendingProfile3, resizeProfile3);
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeByIdentity_(Frame frameValue) {
            Object object;
            Class byIdentityType_ = this.root.byIdentityType_;
            if (byIdentityType_ == Boolean.TYPE) {
                return this.root.byIdentity_.executeBoolean((VirtualFrame)frameValue);
            }
            if (byIdentityType_ != null) return this.root.byIdentity_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.byIdentity_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.byIdentityType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.byIdentityType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.byIdentityType_ = _type;
            return object;
        }
    }
}

