/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.RopeBuffer;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;

public class StringGuards {
    public static boolean isSingleByteOptimizable(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return Layouts.STRING.getRope(string).isSingleByteOptimizable();
    }

    public static boolean is7Bit(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.codeRange(string) == CodeRange.CR_7BIT;
    }

    public static boolean isAsciiCompatible(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return Layouts.STRING.getRope(string).getEncoding().isAsciiCompatible();
    }

    public static boolean isFixedWidthEncoding(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return Layouts.STRING.getRope(string).getEncoding().isFixedWidth();
    }

    public static boolean isValidUtf8(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringGuards.isValidCodeRange(string) && Layouts.STRING.getRope(string).getEncoding().isUTF8();
    }

    public static boolean isEmpty(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return Layouts.STRING.getRope(string).isEmpty();
    }

    public static boolean isBrokenCodeRange(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.codeRange(string) == CodeRange.CR_BROKEN;
    }

    public static boolean isValidCodeRange(DynamicObject string) {
        return StringOperations.codeRange(string) == CodeRange.CR_VALID;
    }

    public static boolean isRopeBuffer(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.rope(string) instanceof RopeBuffer;
    }
}

