/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.loader;

import com.oracle.truffle.api.source.Source;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.truffle.aot.RootedFileVisitor;
import org.jruby.truffle.aot.SimpleRootedFileVisitor;

public final class JRubySourceLoaderSupport {
    public static final Map<String, CoreLibraryFile> allCoreLibraryFiles = JRubySourceLoaderSupport.getCoreLibrary();

    public static String canonicalizeResourcePath(String path) {
        String tmpPath = path;
        if (path.startsWith("truffle:")) {
            tmpPath = path.substring("truffle:".length());
        } else if (path.startsWith("jruby:")) {
            tmpPath = path.substring("jruby:".length());
        } else if (tmpPath.startsWith("core:/")) {
            tmpPath = tmpPath.substring("core:/".length());
        } else if (tmpPath.startsWith("uri:classloader:/")) {
            tmpPath = tmpPath.substring("uri:classloader:/".length());
        }
        if (tmpPath.startsWith("/")) {
            tmpPath = tmpPath.substring(1);
        }
        try {
            return new URI(tmpPath).normalize().getPath();
        }
        catch (URISyntaxException e) {
            return tmpPath;
        }
    }

    private static Set<String> getCoreLibraryFiles() {
        final HashSet<String> coreLibraryFiles = new HashSet<String>();
        SimpleRootedFileVisitor<Path> visitor = new SimpleRootedFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fileName = ((Path)this.getRoot()).relativize(file).toString();
                if (fileName.endsWith(".rb")) {
                    coreLibraryFiles.add(fileName);
                }
                return FileVisitResult.CONTINUE;
            }
        };
        RootedFileVisitor.visitEachFileOnClassPath((RootedFileVisitor<Path>)visitor);
        return coreLibraryFiles;
    }

    private static Map<String, CoreLibraryFile> getCoreLibrary() {
        HashMap<String, CoreLibraryFile> coreLibrary = new HashMap<String, CoreLibraryFile>();
        Set<String> coreLibraryFiles = JRubySourceLoaderSupport.getCoreLibraryFiles();
        try (FileSystem jarFileSystem = FileSystems.newFileSystem(URI.create("jar:file:" + RootedFileVisitor.rubyJarPath()), Collections.emptyMap());){
            for (String name : coreLibraryFiles) {
                Path filePath = jarFileSystem.getPath("/" + name, new String[0]);
                try {
                    BufferedReader reader = Files.newBufferedReader(filePath);
                    Throwable throwable = null;
                    try {
                        if (reader != null) {
                            Source source = Source.fromReader(reader, name);
                            byte[] code = source.getCode().getBytes(StandardCharsets.UTF_8);
                            coreLibrary.put(name, new CoreLibraryFile(code, null));
                            continue;
                        }
                        throw new Error("Unable to load ruby core library file " + name);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return coreLibrary;
    }

    public static class CoreLibraryMethod {
        public final String name;
        public final byte[] code;

        public CoreLibraryMethod(String name, byte[] code) {
            this.name = name;
            this.code = code;
        }
    }

    public static class CoreLibraryFile {
        public final byte[] code;
        public final Map<Integer, CoreLibraryMethod> methods;

        public CoreLibraryFile(byte[] code, Map<Integer, CoreLibraryMethod> methods) {
            this.code = code;
            this.methods = methods;
        }
    }
}

