/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.TextTranslator;
import freemind.controller.Controller;
import freemind.main.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ColorProperty
extends PropertyBean
implements PropertyControl,
ActionListener {
    String description;
    String label;
    Color color;
    JButton mButton;
    final JPopupMenu menu = new JPopupMenu();
    private final String defaultColor;
    private final TextTranslator mTranslator;

    public ColorProperty(String description, String label, String defaultColor, TextTranslator pTranslator) {
        this.description = description;
        this.label = label;
        this.defaultColor = defaultColor;
        this.mTranslator = pTranslator;
        this.mButton = new JButton();
        this.mButton.addActionListener(this);
        this.color = Color.BLACK;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setValue(String value) {
        this.setColorValue(Tools.xmlToColor(value));
    }

    @Override
    public String getValue() {
        return Tools.colorToXml(this.getColorValue());
    }

    @Override
    public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
        JLabel label = builder.append(pTranslator.getText(this.getLabel()), (Component)this.mButton);
        label.setToolTipText(pTranslator.getText(this.getDescription()));
        JMenuItem item = new JMenuItem(this.mTranslator.getText("ColorProperty.ResetColor"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorProperty.this.setValue(ColorProperty.this.defaultColor);
            }
        });
        this.menu.add(item);
        this.mButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    ColorProperty.this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    ColorProperty.this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Color result = Controller.showCommonJColorChooserDialog(this.mButton.getRootPane(), this.mTranslator.getText(this.getLabel()), this.getColorValue());
        if (result != null) {
            this.setColorValue(result);
            this.firePropertyChangeEvent();
        }
    }

    private void setColorValue(Color result) {
        this.color = result;
        if (result == null) {
            result = Color.WHITE;
        }
        this.mButton.setBackground(result);
        this.mButton.setText(Tools.colorToXml(result));
    }

    private Color getColorValue() {
        return this.color;
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mButton.setEnabled(pEnabled);
    }
}

