/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.resolvedCallUtil;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u0002\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u0002\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u0006\u0012\u0002\b\u00030\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u0002\u001a\u001c\u0010\b\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u00022\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0002\u001a\u0016\u0010\u000b\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\t\u001a\u00020\f\u001a+\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000f*\u0006\u0012\u0002\b\u00030\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a8\u0006\u0011"}, d2={"getDispatchReceiverWithSmartCast", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getExplicitReceiverValue", "getImplicitReceiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "hasBothReceivers", "", "hasSafeNullableReceiver", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "hasThisOrNoDispatchReceiver", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "makeNullableTypeIfSafeReceiver", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/annotations/NotNull;", "type", "kotlin-compiler"})
public final class ResolvedCallUtilKt {
    public static final boolean hasThisOrNoDispatchReceiver(@NotNull ResolvedCall<?> $receiver, @NotNull BindingContext context) {
        KtExpression expression;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ReceiverValue dispatchReceiverValue = $receiver.getDispatchReceiver();
        if ($receiver.getResultingDescriptor().getDispatchReceiverParameter() == null || dispatchReceiverValue == null) {
            return true;
        }
        DeclarationDescriptor dispatchReceiverDescriptor = null;
        if (dispatchReceiverValue instanceof ImplicitReceiver) {
            dispatchReceiverDescriptor = ((ImplicitReceiver)dispatchReceiverValue).getDeclarationDescriptor();
        } else if (dispatchReceiverValue instanceof ClassValueReceiver) {
            dispatchReceiverDescriptor = ((ClassValueReceiver)dispatchReceiverValue).getClassQualifier().getDescriptor();
        } else if (dispatchReceiverValue instanceof ExpressionReceiver && (expression = KtPsiUtil.deparenthesize(((ExpressionReceiver)dispatchReceiverValue).getExpression())) instanceof KtThisExpression) {
            dispatchReceiverDescriptor = (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, ((KtThisExpression)expression).getInstanceReference());
        }
        return Intrinsics.areEqual(dispatchReceiverDescriptor, DescriptorUtilsKt.getOwnerForEffectiveDispatchReceiverParameter($receiver.getResultingDescriptor()));
    }

    @Nullable
    public static final ReceiverValue getExplicitReceiverValue(@NotNull ResolvedCall<?> $receiver) {
        ReceiverValue receiverValue;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        switch (ResolvedCallUtilKt$WhenMappings.$EnumSwitchMapping$0[$receiver.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                receiverValue = $receiver.getDispatchReceiver();
                if (receiverValue != null) break;
                Intrinsics.throwNpe();
                break;
            }
            case 2: 
            case 3: {
                receiverValue = $receiver.getExtensionReceiver();
                if (receiverValue != null) break;
                Intrinsics.throwNpe();
                break;
            }
            default: {
                receiverValue = null;
            }
        }
        return receiverValue;
    }

    @Nullable
    public static final ImplicitReceiver getImplicitReceiverValue(@NotNull ResolvedCall<?> $receiver) {
        ReceiverValue receiverValue;
        ReceiverValue receiverValue2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        switch (ResolvedCallUtilKt$WhenMappings.$EnumSwitchMapping$1[$receiver.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                receiverValue2 = $receiver.getExtensionReceiver();
                if (receiverValue2 != null) break;
                receiverValue2 = $receiver.getDispatchReceiver();
                break;
            }
            case 2: {
                receiverValue2 = $receiver.getExtensionReceiver();
                break;
            }
            case 3: {
                receiverValue2 = $receiver.getDispatchReceiver();
                break;
            }
            default: {
                receiverValue2 = receiverValue = (ReceiverValue)null;
            }
        }
        if (!(receiverValue2 instanceof ImplicitReceiver)) {
            receiverValue = null;
        }
        return (ImplicitReceiver)receiverValue;
    }

    private static final boolean hasSafeNullableReceiver(@NotNull ResolvedCall<?> $receiver, CallResolutionContext<?> context) {
        Object object;
        block5: {
            block4: {
                if (!CallUtilKt.isSafeCall($receiver.getCall())) {
                    return false;
                }
                object = ResolvedCallUtilKt.getExplicitReceiverValue($receiver);
                if (object == null) break block4;
                ReceiverValue receiverValue = object;
                ReceiverValue it = receiverValue;
                object = DataFlowValueFactory.createDataFlowValue(it, (ResolutionContext)context);
                if (object != null) break block5;
            }
            return false;
        }
        Object receiverValue = object;
        return context.dataFlowInfo.getStableNullability((DataFlowValue)receiverValue).canBeNull();
    }

    @Nullable
    public static final KotlinType makeNullableTypeIfSafeReceiver(@NotNull ResolvedCall<?> $receiver, @Nullable KotlinType type2, @NotNull CallResolutionContext<?> context) {
        KotlinType kotlinType;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        KotlinType kotlinType2 = type2;
        if (kotlinType2 != null) {
            KotlinType kotlinType3 = kotlinType2;
            KotlinType it = kotlinType3;
            kotlinType = TypeUtils.makeNullableIfNeeded(type2, ResolvedCallUtilKt.hasSafeNullableReceiver($receiver, context));
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    public static final boolean hasBothReceivers(@NotNull ResolvedCall<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getDispatchReceiver() != null && $receiver.getExtensionReceiver() != null;
    }

    @Nullable
    public static final ReceiverValue getDispatchReceiverWithSmartCast(@NotNull ResolvedCall<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SmartCastUtilKt.getReceiverValueWithSmartCast($receiver.getDispatchReceiver(), $receiver.getSmartCastDispatchReceiverType());
    }
}

