/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.CachedTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.HostLimitQueue;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoaderJob;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class TMSCachedTileLoader
implements TileLoader,
CachedTileLoader {
    protected final ICacheAccess<String, BufferedImageCacheEntry> cache;
    protected final int connectTimeout;
    protected final int readTimeout;
    protected final Map<String, String> headers;
    protected final TileLoaderListener listener;
    public static final IntegerProperty THREAD_LIMIT = new IntegerProperty("imagery.tms.tmsloader.maxjobs", 25);
    public static final IntegerProperty HOST_LIMIT = new IntegerProperty("imagery.tms.tmsloader.maxjobsperhost", 6);
    private static ThreadPoolExecutor DEFAULT_DOWNLOAD_JOB_DISPATCHER = TMSCachedTileLoader.getNewThreadPoolExecutor("TMS-downloader-%d");
    private ThreadPoolExecutor downloadExecutor = DEFAULT_DOWNLOAD_JOB_DISPATCHER;

    public TMSCachedTileLoader(TileLoaderListener tileLoaderListener, ICacheAccess<String, BufferedImageCacheEntry> iCacheAccess, int n, int n2, Map<String, String> map) {
        CheckParameterUtil.ensureParameterNotNull(iCacheAccess, "cache");
        this.cache = iCacheAccess;
        this.connectTimeout = n;
        this.readTimeout = n2;
        this.headers = map;
        this.listener = tileLoaderListener;
    }

    public static ThreadPoolExecutor getNewThreadPoolExecutor(String string, int n) {
        HostLimitQueue hostLimitQueue = new HostLimitQueue(HOST_LIMIT.get());
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(0, n, 300L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)hostLimitQueue, Utils.newThreadFactory(string, 5));
        hostLimitQueue.setExecutor(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ThreadPoolExecutor getNewThreadPoolExecutor(String string) {
        return TMSCachedTileLoader.getNewThreadPoolExecutor(string, THREAD_LIMIT.get());
    }

    @Override
    public TileJob createTileLoaderJob(Tile tile) {
        return new TMSCachedTileLoaderJob(this.listener, tile, this.cache, this.connectTimeout, this.readTimeout, this.headers, this.getDownloadExecutor());
    }

    @Override
    public void clearCache(TileSource tileSource) {
        this.cache.remove(tileSource.getName() + ':');
    }

    public String getStats() {
        return this.cache.getStats();
    }

    @Override
    public void cancelOutstandingTasks() {
        for (Runnable runnable : this.downloadExecutor.getQueue()) {
            if (!this.downloadExecutor.remove(runnable) || !(runnable instanceof TMSCachedTileLoaderJob)) continue;
            ((TMSCachedTileLoaderJob)runnable).handleJobCancellation();
        }
    }

    public void setDownloadExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.downloadExecutor = threadPoolExecutor;
    }

    public ThreadPoolExecutor getDownloadExecutor() {
        return this.downloadExecutor;
    }
}

