/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl.pem;

import java.io.IOException;
import org.bouncycastle.operator.OperatorCreationException;
import org.jruby.ext.openssl.impl.pem.PEMDecryptor;
import org.jruby.ext.openssl.impl.pem.PEMDecryptorProvider;
import org.jruby.ext.openssl.impl.pem.PEMException;
import org.jruby.ext.openssl.impl.pem.PEMKeyPair;
import org.jruby.ext.openssl.impl.pem.PEMKeyPairParser;

public class PEMEncryptedKeyPair {
    private final String dekAlgName;
    private final byte[] iv;
    private final byte[] keyBytes;
    private final PEMKeyPairParser parser;

    PEMEncryptedKeyPair(String dekAlgName, byte[] iv, byte[] keyBytes, PEMKeyPairParser parser) {
        this.dekAlgName = dekAlgName;
        this.iv = iv;
        this.keyBytes = keyBytes;
        this.parser = parser;
    }

    public PEMKeyPair decryptKeyPair(PEMDecryptorProvider keyDecryptorProvider) throws IOException {
        try {
            PEMDecryptor keyDecryptor = keyDecryptorProvider.get(this.dekAlgName);
            return this.parser.parse(keyDecryptor.decrypt(this.keyBytes, this.iv));
        }
        catch (IOException e) {
            throw e;
        }
        catch (OperatorCreationException e) {
            throw new PEMException("cannot create extraction operator: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PEMException("exception processing key pair: " + e.getMessage(), e);
        }
    }
}

