/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.Execute;
import com.oracle.truffle.api.interop.ForeignObjectAccessHeadNode;
import com.oracle.truffle.api.interop.GetSize;
import com.oracle.truffle.api.interop.HasSize;
import com.oracle.truffle.api.interop.IsBoxed;
import com.oracle.truffle.api.interop.IsExecutable;
import com.oracle.truffle.api.interop.IsNull;
import com.oracle.truffle.api.interop.Keys;
import com.oracle.truffle.api.interop.KnownMessage;
import com.oracle.truffle.api.interop.Read;
import com.oracle.truffle.api.interop.Unbox;
import com.oracle.truffle.api.interop.Write;
import com.oracle.truffle.api.nodes.Node;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Message {
    public static final Message READ = Read.INSTANCE;
    public static final Message UNBOX = Unbox.INSTANCE;
    public static final Message WRITE = Write.INSTANCE;
    public static final Message IS_EXECUTABLE = IsExecutable.INSTANCE;
    public static final Message IS_NULL = IsNull.INSTANCE;
    public static final Message HAS_SIZE = HasSize.INSTANCE;
    public static final Message GET_SIZE = GetSize.INSTANCE;
    public static final Message IS_BOXED = IsBoxed.INSTANCE;
    public static final Message KEYS = Keys.INSTANCE;
    private static final Map<String, Message> CLASS_TO_MESSAGE = new ConcurrentHashMap<String, Message>();

    protected Message() {
        Message.registerClass(this);
    }

    public static Message createExecute(int argumentsLength) {
        return Execute.create(423430, argumentsLength);
    }

    public static Message createInvoke(int argumentsLength) {
        return Execute.create(423429, argumentsLength);
    }

    public static Message createNew(int argumentsLength) {
        return Execute.create(423428, argumentsLength);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public final Node createNode() {
        return new ForeignObjectAccessHeadNode(this);
    }

    public static String toString(Message message) {
        if (READ == message) {
            return "READ";
        }
        if (WRITE == message) {
            return "WRITE";
        }
        if (UNBOX == message) {
            return "UNBOX";
        }
        if (GET_SIZE == message) {
            return "GET_SIZE";
        }
        if (HAS_SIZE == message) {
            return "HAS_SIZE";
        }
        if (IS_NULL == message) {
            return "IS_NULL";
        }
        if (IS_BOXED == message) {
            return "IS_BOXED";
        }
        if (IS_EXECUTABLE == message) {
            return "IS_EXECUTABLE";
        }
        if (KEYS == message) {
            return "KEYS";
        }
        if (message instanceof Execute) {
            return ((Execute)message).name();
        }
        return message.getClass().getName();
    }

    public static Message valueOf(String messageId) {
        Message instance;
        switch (messageId) {
            case "READ": {
                return READ;
            }
            case "WRITE": {
                return WRITE;
            }
            case "UNBOX": {
                return UNBOX;
            }
            case "GET_SIZE": {
                return GET_SIZE;
            }
            case "HAS_SIZE": {
                return HAS_SIZE;
            }
            case "IS_NULL": {
                return IS_NULL;
            }
            case "IS_BOXED": {
                return IS_BOXED;
            }
            case "IS_EXECUTABLE": {
                return IS_EXECUTABLE;
            }
            case "KEYS": {
                return KEYS;
            }
            case "EXECUTE": {
                return Message.createExecute(0);
            }
            case "NEW": {
                return Message.createNew(0);
            }
            case "INVOKE": {
                return Message.createInvoke(0);
            }
        }
        if (!TruffleOptions.AOT) {
            Message.initializeMessageClass(messageId);
        }
        if ((instance = CLASS_TO_MESSAGE.get(messageId)) == null) {
            throw new IllegalArgumentException("Cannot find existing message instance for " + messageId);
        }
        return instance;
    }

    @CompilerDirectives.TruffleBoundary
    private static void initializeMessageClass(String message) throws IllegalArgumentException {
        try {
            ClassLoader l = Message.class.getClassLoader();
            if (l == null) {
                l = ClassLoader.getSystemClassLoader();
            }
            Class.forName(message, false, l).newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot find message for " + message, ex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void registerClass(Message message) {
        if (message instanceof KnownMessage) {
            return;
        }
        String key = message.getClass().getName();
        CLASS_TO_MESSAGE.putIfAbsent(key, message);
    }
}

