/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsDocCommentImpl;
import com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.PsiMemberStub;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class ClsMemberImpl<T extends PsiMemberStub>
extends ClsRepositoryPsiElement<T>
implements PsiDocCommentOwner,
PsiNameIdentifierOwner {
    private final NotNullLazyValue<PsiDocComment> myDocComment;
    private final NotNullLazyValue<PsiIdentifier> myNameIdentifier;

    protected ClsMemberImpl(T stub) {
        super(stub);
        this.myDocComment = !stub.isDeprecated() ? null : new AtomicNotNullLazyValue<PsiDocComment>(){

            @Override
            @NotNull
            protected PsiDocComment compute() {
                ClsDocCommentImpl clsDocCommentImpl = new ClsDocCommentImpl(ClsMemberImpl.this);
                if (clsDocCommentImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMemberImpl$1", "compute"));
                }
                return clsDocCommentImpl;
            }
        };
        this.myNameIdentifier = new AtomicNotNullLazyValue<PsiIdentifier>(){

            @Override
            @NotNull
            protected PsiIdentifier compute() {
                ClsIdentifierImpl clsIdentifierImpl = new ClsIdentifierImpl(ClsMemberImpl.this, ClsMemberImpl.this.getName());
                if (clsIdentifierImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMemberImpl$2", "compute"));
                }
                return clsIdentifierImpl;
            }
        };
    }

    @Override
    public PsiDocComment getDocComment() {
        return this.myDocComment != null ? this.myDocComment.getValue() : null;
    }

    @Override
    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = this.myNameIdentifier.getValue();
        if (psiIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMemberImpl", "getNameIdentifier"));
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((PsiMemberStub)this.getStub()).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsMemberImpl", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/compiled/ClsMemberImpl", "setName"));
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name2);
        return this;
    }
}

