/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.RetinaImage;
import com.intellij.util.SVGLoader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageLoader
implements Serializable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ImageLoader");
    private static final ConcurrentMap<String, Image> ourCache = ContainerUtil.createConcurrentSoftValueMap();
    public static final Component ourComponent = new Component(){};

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            LOG.info(ex);
        }
        return !mediatracker.isErrorID(1);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling, ImageFilter filter2) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        final float scaleFactor = ImageLoader.calcScaleFactor(allowFloatScaling);
        final boolean scaleImages = scaleFactor > 1.0f && !UIUtil.isRetina();
        boolean loadRetinaImages = UIUtil.isRetina() || scaleImages;
        return ImageDescList.create(url.toString(), null, UIUtil.isUnderDarcula(), loadRetinaImages, allowFloatScaling).load(ImageConverterChain.create().withFilter(filter2).withRetina().with(new ImageConverter(){

            @Override
            public Image convert(Image source, ImageDesc desc) {
                if (source != null && scaleImages && desc.type != ImageDesc.Type.SVG) {
                    if (desc.path.contains("@2x")) {
                        return ImageLoader.scaleImage(source, scaleFactor / 2.0f);
                    }
                    return ImageLoader.scaleImage(source, scaleFactor);
                }
                return source;
            }
        }));
    }

    private static float calcScaleFactor(boolean allowFloatScaling) {
        float scaleFactor;
        float f = allowFloatScaling ? JBUI.scale(1.0f) : (scaleFactor = JBUI.scale(1.0f) > 1.5f ? 2.0f : 1.0f);
        assert (scaleFactor >= 1.0f) : "By design, only scale factors >= 1.0 are supported";
        return scaleFactor;
    }

    @NotNull
    private static Image scaleImage(Image image, float scale) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            Image image2 = image;
            if (image2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ImageLoader", "scaleImage"));
            }
            return image2;
        }
        int width = (int)(scale * (float)w);
        int height = (int)(scale * (float)h);
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ImageLoader", "scaleImage"));
        }
        return bufferedImage;
    }

    @Nullable
    public static Image loadFromUrl(URL url, boolean dark, boolean retina, ImageFilter filter2) {
        return ImageDescList.create(url.toString(), null, dark, retina, true).load(ImageConverterChain.create().withFilter(filter2).withRetina());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image load(@NotNull InputStream inputStream, int scale) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/ImageLoader", "load"));
        }
        if (scale <= 0) {
            throw new IllegalArgumentException("Scale must be 1 or greater");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream2 = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream2.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream2.getInternalBuffer(), 0, outputStream2.size());
            ImageLoader.waitForImage(image);
            return image;
        }
        catch (Exception ex) {
            LOG.error(ex);
            return null;
        }
    }

    private static class ImageConverterChain
    extends ArrayList<ImageConverter> {
        private ImageConverterChain() {
        }

        public static ImageConverterChain create() {
            return new ImageConverterChain();
        }

        public ImageConverterChain withFilter(final ImageFilter filter2) {
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    return ImageUtil.filter(source, filter2);
                }
            });
        }

        public ImageConverterChain withRetina() {
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    if (source != null && UIUtil.isRetina() && desc.scale > 1.0f) {
                        return RetinaImage.createFrom(source, (int)desc.scale, ourComponent);
                    }
                    return source;
                }
            });
        }

        public ImageConverterChain with(ImageConverter f) {
            this.add(f);
            return this;
        }

        public Image convert(Image image, ImageDesc desc) {
            for (ImageConverter f : this) {
                image = f.convert(image, desc);
            }
            return image;
        }
    }

    private static interface ImageConverter {
        public Image convert(@Nullable Image var1, ImageDesc var2);
    }

    private static class ImageDescList
    extends ArrayList<ImageDesc> {
        private ImageDescList() {
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters) {
            if (converters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converters", "com/intellij/util/ImageLoader$ImageDescList", "load"));
            }
            for (ImageDesc desc : this) {
                try {
                    Image image = desc.load();
                    if (image == null) continue;
                    LOG.debug("Loaded image: " + desc);
                    return converters.convert(image, desc);
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }

        public static ImageDescList create(@NotNull String file2, @Nullable Class cls, boolean dark, boolean retina, boolean allowFloatScaling) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ImageLoader$ImageDescList", "create"));
            }
            ImageDescList vars = new ImageDescList();
            if (retina || dark) {
                String name2 = FileUtil.getNameWithoutExtension(file2);
                String ext = FileUtilRt.getExtension(file2);
                float scale = ImageLoader.calcScaleFactor(allowFloatScaling);
                if (Registry.is("ide.svg.icon") && dark) {
                    vars.add(new ImageDesc(name2 + "_dark.svg", cls, UIUtil.isRetina() ? 2.0f : scale, ImageDesc.Type.SVG));
                }
                if (Registry.is("ide.svg.icon")) {
                    vars.add(new ImageDesc(name2 + ".svg", cls, UIUtil.isRetina() ? 2.0f : scale, ImageDesc.Type.SVG));
                }
                if (dark && retina) {
                    vars.add(new ImageDesc(name2 + "@2x_dark." + ext, cls, 2.0f, ImageDesc.Type.PNG));
                }
                if (dark) {
                    vars.add(new ImageDesc(name2 + "_dark." + ext, cls, 1.0f, ImageDesc.Type.PNG));
                }
                if (retina) {
                    vars.add(new ImageDesc(name2 + "@2x." + ext, cls, 2.0f, ImageDesc.Type.PNG));
                }
            }
            vars.add(new ImageDesc(file2, cls, 1.0f, ImageDesc.Type.PNG, true));
            return vars;
        }
    }

    private static class ImageDesc {
        public final String path;
        @Nullable
        public final Class cls;
        public final float scale;
        public final Type type;
        public final boolean original;

        public ImageDesc(String path, Class cls, float scale, Type type2) {
            this(path, cls, scale, type2, false);
        }

        public ImageDesc(String path, Class cls, float scale, Type type2, boolean original) {
            this.path = path;
            this.cls = cls;
            this.scale = scale;
            this.type = type2;
            this.original = original;
        }

        @Nullable
        public Image load() throws IOException {
            Image image;
            String cacheKey = null;
            InputStream stream2 = null;
            URL url = null;
            if (this.cls != null && (stream2 = this.cls.getResourceAsStream(this.path)) == null) {
                return null;
            }
            if (stream2 == null) {
                cacheKey = this.path;
                image = (Image)ourCache.get(cacheKey);
                if (image != null) {
                    return image;
                }
                url = new URL(this.path);
                URLConnection connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    if (!this.original) {
                        return null;
                    }
                    connection.addRequestProperty("User-Agent", "IntelliJ");
                }
                stream2 = connection.getInputStream();
            }
            if ((image = this.type.load(url, stream2, this.scale)) != null && cacheKey != null) {
                ourCache.put(cacheKey, image);
            }
            return image;
        }

        public String toString() {
            return this.path + ", scale: " + this.scale + ", type: " + (Object)((Object)this.type);
        }

        public static enum Type {
            PNG,
            SVG{

                @Override
                public Image load(URL url, InputStream is, float scale) throws IOException {
                    return SVGLoader.load(url, is, scale);
                }
            }
            ,
            UNDEFINED;


            public Image load(URL url, InputStream stream2, float scale) throws IOException {
                return ImageLoader.load(stream2, (int)scale);
            }
        }
    }
}

