/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");
    private static final Method acquireConstructorAccessorMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "acquireConstructorAccessor", new Class[0]);
    private static final Method getConstructorAccessorMethod = ReflectionUtil.getDeclaredMethod(Constructor.class, "getConstructorAccessor", new Class[0]);
    private static final Function<Class, Iterable<Class>> CLASS_STRUCTURE = new Function<Class, Iterable<Class>>(){

        @Override
        public Iterable<Class> fun(Class aClass2) {
            return JBIterable.of(aClass2.getSuperclass()).append(aClass2.getInterfaces());
        }
    };

    private ReflectionUtil() {
    }

    @NotNull
    public static Field findField(@NotNull Class clazz, final @Nullable Class type2, final @NotNull String name2) throws NoSuchFieldException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "findField"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "findField"));
        }
        Field result2 = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return name2.equals(field.getName()) && (type2 == null || field.getType().equals(type2));
            }
        });
        if (result2 != null) {
            Field field = result2;
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "findField"));
            }
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name2 + " type: " + type2);
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, final @Nullable(value="null means any type") Class<?> fieldType, final @NotNull String fieldName) throws NoSuchFieldException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        Field result2 = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return fieldName.equals(field.getName()) && (fieldType == null || fieldType.isAssignableFrom(field.getType()));
            }
        });
        if (result2 != null) {
            Field field = result2;
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "findAssignableField"));
            }
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    private static Field processFields(@NotNull Class clazz, @NotNull Condition<Field> checker) {
        Class<?>[] interfaces;
        Field result2;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "processFields"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "com/intellij/util/ReflectionUtil", "processFields"));
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!checker.value(field)) continue;
            field.setAccessible(true);
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (result2 = ReflectionUtil.processFields(superClass, checker)) != null) {
            return result2;
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            Field result3 = ReflectionUtil.processFields(each, checker);
            if (result3 == null) continue;
            return result3;
        }
        return null;
    }

    public static void resetField(@NotNull Class clazz, @Nullable(value="null means of any type") Class type2, @NotNull String name2) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type2, name2));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(@Nullable Object object, @NotNull Field field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/util/ReflectionUtil", "resetField"));
        }
        field.setAccessible(true);
        Class<?> type2 = field.getType();
        try {
            if (type2.isPrimitive()) {
                if (Boolean.TYPE.equals(type2)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type2)) {
                    field.set(object, 0);
                } else if (Double.TYPE.equals(type2)) {
                    field.set(object, 0.0);
                } else if (Float.TYPE.equals(type2)) {
                    field.set(object, Float.valueOf(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            LOG.info(e);
        }
    }

    @Nullable
    public static Method findMethod(@NotNull Collection<Method> methods2, @NonNls @NotNull String name2, Class ... parameters2) {
        if (methods2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        for (Method method : methods2) {
            if (!name2.equals(method.getName()) || !Arrays.equals(parameters2, method.getParameterTypes())) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@NotNull Class aClass2, @NonNls @NotNull String name2, Class ... parameters2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getMethod"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "getMethod"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "getMethod"));
        }
        return ReflectionUtil.findMethod(ReflectionUtil.getClassPublicMethods(aClass2, false), name2, parameters2);
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class aClass2, @NonNls @NotNull String name2, Class ... parameters2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "getDeclaredMethod"));
        }
        return ReflectionUtil.findMethod(ReflectionUtil.getClassDeclaredMethods(aClass2, false), name2, parameters2);
    }

    @Nullable
    public static Field getDeclaredField(@NotNull Class aClass2, final @NonNls @NotNull String name2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getDeclaredField"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ReflectionUtil", "getDeclaredField"));
        }
        return ReflectionUtil.processFields(aClass2, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return name2.equals(field.getName());
            }
        });
    }

    @NotNull
    public static List<Method> getClassPublicMethods(@NotNull Class aClass2, boolean includeSynthetic) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getClassPublicMethods"));
        }
        Method[] methods2 = aClass2.getMethods();
        List<Method> list2 = includeSynthetic ? Arrays.asList(methods2) : ReflectionUtil.filterRealMethods(methods2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getClassPublicMethods"));
        }
        return list2;
    }

    @NotNull
    public static List<Method> getClassDeclaredMethods(@NotNull Class aClass2, boolean includeSynthetic) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getClassDeclaredMethods"));
        }
        Method[] methods2 = aClass2.getDeclaredMethods();
        List<Method> list2 = includeSynthetic ? Arrays.asList(methods2) : ReflectionUtil.filterRealMethods(methods2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getClassDeclaredMethods"));
        }
        return list2;
    }

    @NotNull
    private static List<Method> filterRealMethods(@NotNull Method[] methods2) {
        if (methods2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/util/ReflectionUtil", "filterRealMethods"));
        }
        ArrayList<Method> result2 = ContainerUtil.newArrayList();
        for (Method method : methods2) {
            if (method.isSynthetic()) continue;
            result2.add(method);
        }
        ArrayList<Method> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "filterRealMethods"));
        }
        return arrayList;
    }

    @Nullable
    public static Class getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String methodName, Class ... parameters2) {
        if (instanceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceClass", "com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        Method method = ReflectionUtil.getMethod(instanceClass, methodName, parameters2);
        return method == null ? null : method.getDeclaringClass();
    }

    public static <T> T getField(@NotNull Class objectClass, @Nullable Object object, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/util/ReflectionUtil", "getField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/util/ReflectionUtil", "getField"));
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            Object t = field.get(object);
            return (T)t;
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static <T> T getStaticFieldValue(@NotNull Class objectClass, @Nullable(value="null means any type") Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/util/ReflectionUtil", "getStaticFieldValue"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/util/ReflectionUtil", "getStaticFieldValue"));
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field " + objectClass + "." + fieldName + " is not static");
            }
            Object t = field.get(null);
            return (T)t;
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    @NotNull
    public static <T> Constructor<T> getDefaultConstructor(@NotNull Class<T> aClass2) {
        Constructor<T> constructor;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "getDefaultConstructor"));
        }
        try {
            Constructor<T> constructor2 = aClass2.getConstructor(new Class[0]);
            constructor2.setAccessible(true);
            constructor = constructor2;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in " + aClass2, e);
        }
        if (constructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getDefaultConstructor"));
        }
        return constructor;
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> aClass2) {
        Constructor<T> constructor;
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ReflectionUtil", "newInstance"));
        }
        try {
            constructor = aClass2.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException e) {
                T t = aClass2.newInstance();
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "newInstance"));
                }
                return t;
            }
        }
        catch (Exception e) {
            for (Annotation annotation2 : aClass2.getAnnotations()) {
                String name2 = annotation2.annotationType().getName();
                if (!name2.equals("kotlin.Metadata") && !name2.equals("kotlin.jvm.internal.KotlinClass")) continue;
                Constructor<?>[] constructors2 = aClass2.getDeclaredConstructors();
                Exception exception = e;
                block10: for (Constructor<?> constructor1 : constructors2) {
                    Object obj;
                    try {
                        Object t;
                        Class<?>[] parameterTypes;
                        try {
                            constructor1.setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        for (Class<?> type2 : parameterTypes = constructor1.getParameterTypes()) {
                            if (type2.getName().equals("kotlin.jvm.internal.DefaultConstructorMarker")) continue block10;
                        }
                        obj = t = constructor1.newInstance(new Object[parameterTypes.length]);
                    }
                    catch (Exception e1) {
                        exception = e1;
                    }
                    if (obj == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "newInstance"));
                    }
                    return (T)obj;
                }
                throw new RuntimeException(exception);
            }
            throw new RuntimeException(e);
        }
        T t = constructor.newInstance(new Object[0]);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "newInstance"));
        }
        return t;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor, Object ... args) {
        T t;
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        try {
            t = constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        return t;
    }

    @Nullable
    public static Class getGrandCallerClass() {
        int stackFrameCount = 3;
        Class callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(++stackFrameCount);
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(2);
        }
        return callerClass;
    }

    @Nullable
    public static Class findCallerClass(int framesToSkip) {
        try {
            Class[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, @NotNull Class<?> descendant) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/util/ReflectionUtil", "isAssignable"));
        }
        if (descendant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descendant", "com/intellij/util/ReflectionUtil", "isAssignable"));
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    private static class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        public Class[] getStack() {
            return this.getClassContext();
        }
    }
}

