/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.VariableRemapper;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InnerClassesLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "InnerClassTransformer", "kotlin-compiler"})
public final class InnerClassesLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull(irClass, "irClass");
        new InnerClassTransformer(irClass).lowerInnerClass();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public InnerClassesLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u0006\u0010\u001d\u001a\u00020\u0017J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u0006*\u00020\rH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InnerClassesLowering$InnerClassTransformer;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/InnerClassesLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "oldConstructorParameterToNew", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/ValueDescriptor;", "getOldConstructorParameterToNew", "()Ljava/util/HashMap;", "outerThisFieldDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getOuterThisFieldDescriptor", "()Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "setOuterThisFieldDescriptor", "(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;)V", "createOuterThisField", "", "lowerConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irConstructor", "lowerConstructorParameterUsages", "lowerConstructors", "lowerInnerClass", "lowerOuterThisReferences", "getClassDescriptorForImplicitThis", "kotlin-compiler"})
    private final class InnerClassTransformer {
        @NotNull
        private final ClassDescriptor classDescriptor;
        @NotNull
        public PropertyDescriptor outerThisFieldDescriptor;
        @NotNull
        private final HashMap<ValueDescriptor, ValueDescriptor> oldConstructorParameterToNew;
        @NotNull
        private final IrClass irClass;

        @NotNull
        public final ClassDescriptor getClassDescriptor() {
            return this.classDescriptor;
        }

        @NotNull
        public final PropertyDescriptor getOuterThisFieldDescriptor() {
            PropertyDescriptor propertyDescriptor = this.outerThisFieldDescriptor;
            if (propertyDescriptor == null) {
                Intrinsics.throwUninitializedPropertyAccessException("outerThisFieldDescriptor");
            }
            return propertyDescriptor;
        }

        public final void setOuterThisFieldDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
            Intrinsics.checkParameterIsNotNull(propertyDescriptor, "<set-?>");
            this.outerThisFieldDescriptor = propertyDescriptor;
        }

        @NotNull
        public final HashMap<ValueDescriptor, ValueDescriptor> getOldConstructorParameterToNew() {
            return this.oldConstructorParameterToNew;
        }

        public final void lowerInnerClass() {
            if (!this.irClass.getDescriptor().isInner()) {
                return;
            }
            this.createOuterThisField();
            this.lowerConstructors();
            this.lowerConstructorParameterUsages();
            this.lowerOuterThisReferences();
        }

        private final void createOuterThisField() {
            this.outerThisFieldDescriptor = InnerClassesLowering.this.getContext().getSpecialDescriptorsFactory().getOuterThisFieldDescriptor(this.irClass.getDescriptor());
            List<IrDeclaration> list2 = this.irClass.getDeclarations();
            int n = this.irClass.getStartOffset();
            int n2 = this.irClass.getEndOffset();
            IrDeclarationOrigin irDeclarationOrigin = JvmLoweredDeclarationOrigin.FIELD_FOR_OUTER_THIS.INSTANCE;
            PropertyDescriptor propertyDescriptor = this.outerThisFieldDescriptor;
            if (propertyDescriptor == null) {
                Intrinsics.throwUninitializedPropertyAccessException("outerThisFieldDescriptor");
            }
            list2.add(new IrFieldImpl(n, n2, irDeclarationOrigin, propertyDescriptor));
        }

        private final void lowerConstructors() {
            List<IrDeclaration> $receiver$iv = this.irClass.getDeclarations();
            int i$iv = 0;
            while (i$iv < $receiver$iv.size()) {
                IrDeclaration item$iv = $receiver$iv.get(i$iv);
                IrDeclaration irMember = item$iv;
                List transformed$iv = irMember instanceof IrConstructor ? AddToStdlibKt.singletonList(this.lowerConstructor((IrConstructor)irMember)) : null;
                if (transformed$iv == null) {
                    ++i$iv;
                    continue;
                }
                $receiver$iv.addAll(i$iv, transformed$iv);
                $receiver$iv.remove(i$iv += transformed$iv.size());
            }
        }

        private final IrConstructor lowerConstructor(IrConstructor irConstructor) {
            int instanceInitializerIndex;
            IrBlockBody blockBody;
            ValueParameterDescriptor valueParameterDescriptor;
            Object object;
            ValueParameterDescriptor outerThisValueParameter;
            ClassConstructorDescriptor newDescriptor;
            int endOffset;
            int startOffset;
            block11: {
                int n;
                ClassConstructorDescriptor oldDescriptor = irConstructor.getDescriptor();
                startOffset = irConstructor.getStartOffset();
                endOffset = irConstructor.getEndOffset();
                newDescriptor = InnerClassesLowering.this.getContext().getSpecialDescriptorsFactory().getInnerClassConstructorWithOuterThisParameter(oldDescriptor);
                outerThisValueParameter = newDescriptor.getValueParameters().get(0);
                Iterable $receiver$iv = oldDescriptor.getValueParameters();
                for (Object element$iv : $receiver$iv) {
                    ValueParameterDescriptor iterator2;
                    ValueParameterDescriptor oldValueParameter = (ValueParameterDescriptor)element$iv;
                    object = this.oldConstructorParameterToNew;
                    Intrinsics.checkExpressionValueIsNotNull(oldValueParameter, "oldValueParameter");
                    Intrinsics.checkExpressionValueIsNotNull(newDescriptor.getValueParameters().get(oldValueParameter.getIndex() + 1), "newDescriptor.valueParam\u2026ValueParameter.index + 1]");
                    object.put(iterator2, valueParameterDescriptor);
                }
                IrBody irBody = irConstructor.getBody();
                if (!(irBody instanceof IrBlockBody)) {
                    irBody = null;
                }
                IrBlockBody irBlockBody = (IrBlockBody)irBody;
                if (irBlockBody == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Unexpected constructor body: " + irConstructor.getBody())));
                }
                blockBody = irBlockBody;
                List<IrStatement> $receiver$iv2 = blockBody.getStatements();
                int index$iv = 0;
                for (Object e : $receiver$iv2) {
                    IrStatement it = (IrStatement)e;
                    if (it instanceof IrInstanceInitializerCall) {
                        n = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                n = instanceInitializerIndex = -1;
            }
            if (instanceInitializerIndex >= 0) {
                List<IrStatement> list2 = blockBody.getStatements();
                PropertyDescriptor propertyDescriptor = this.outerThisFieldDescriptor;
                if (propertyDescriptor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("outerThisFieldDescriptor");
                }
                ReceiverParameterDescriptor receiverParameterDescriptor = this.classDescriptor.getThisAsReceiverParameter();
                Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor, "classDescriptor.thisAsReceiverParameter");
                IrExpression irExpression = new IrGetValueImpl(startOffset, endOffset, receiverParameterDescriptor, null, 8, null);
                ValueParameterDescriptor valueParameterDescriptor2 = outerThisValueParameter;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "outerThisValueParameter");
                list2.add(instanceInitializerIndex, new IrSetFieldImpl(startOffset, endOffset, propertyDescriptor, irExpression, new IrGetValueImpl(startOffset, endOffset, valueParameterDescriptor2, null, 8, null), null, null, 96, null));
            } else {
                ValueParameterDescriptor valueParameterDescriptor3;
                block12: {
                    Iterable iterable = blockBody.getStatements();
                    object = iterable;
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        valueParameterDescriptor = iterator2.next();
                        IrStatement it = (IrStatement)((Object)valueParameterDescriptor);
                        if (!(it instanceof IrDelegatingConstructorCall)) continue;
                        valueParameterDescriptor3 = valueParameterDescriptor;
                        break block12;
                    }
                    valueParameterDescriptor3 = null;
                }
                IrStatement irStatement = (IrStatement)((Object)valueParameterDescriptor3);
                if (irStatement == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Delegating constructor call expected: " + DumpIrTreeKt.dump(irConstructor))));
                }
                if (irStatement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall");
                }
                IrDelegatingConstructorCall delegatingConstructorCall = (IrDelegatingConstructorCall)irStatement;
                int n = delegatingConstructorCall.getStartOffset();
                int n2 = delegatingConstructorCall.getEndOffset();
                ValueParameterDescriptor valueParameterDescriptor4 = outerThisValueParameter;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor4, "outerThisValueParameter");
                delegatingConstructorCall.setDispatchReceiver(new IrGetValueImpl(n, n2, valueParameterDescriptor4, null, 8, null));
            }
            return new IrConstructorImpl(startOffset, endOffset, irConstructor.getOrigin(), newDescriptor, blockBody);
        }

        private final void lowerConstructorParameterUsages() {
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new VariableRemapper((Map<ValueDescriptor, ? extends ValueDescriptor>)this.oldConstructorParameterToNew));
        }

        private final void lowerOuterThisReferences() {
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new IrElementTransformerVoid(this){
                final /* synthetic */ InnerClassTransformer this$0;

                @NotNull
                public IrExpression visitGetValue(@NotNull IrGetValue expression) {
                    Intrinsics.checkParameterIsNotNull(expression, "expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression, this);
                    ClassDescriptor classDescriptor = InnerClassTransformer.access$getClassDescriptorForImplicitThis(this.this$0, expression.getDescriptor());
                    if (classDescriptor == null) {
                        return expression;
                    }
                    ClassDescriptor implicitThisClass = classDescriptor;
                    if (Intrinsics.areEqual(implicitThisClass, this.this$0.getClassDescriptor())) {
                        return expression;
                    }
                    int startOffset = expression.getStartOffset();
                    int endOffset = expression.getEndOffset();
                    IrStatementOrigin origin = expression.getOrigin();
                    ReceiverParameterDescriptor receiverParameterDescriptor = this.this$0.getClassDescriptor().getThisAsReceiverParameter();
                    Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor, "classDescriptor.thisAsReceiverParameter");
                    IrExpression irThis = new IrGetValueImpl(startOffset, endOffset, receiverParameterDescriptor, origin);
                    ClassDescriptor innerClass = this.this$0.getClassDescriptor();
                    while (Intrinsics.areEqual(innerClass, implicitThisClass) ^ true) {
                        if (!innerClass.isInner()) {
                            return expression;
                        }
                        PropertyDescriptor outerThisField = this.this$0.InnerClassesLowering.this.getContext().getSpecialDescriptorsFactory().getOuterThisFieldDescriptor(innerClass);
                        irThis = new IrGetFieldImpl(startOffset, endOffset, outerThisField, irThis, origin, null, 32, null);
                        DeclarationDescriptor outer = this.this$0.getClassDescriptor().getContainingDeclaration();
                        DeclarationDescriptor declarationDescriptor = outer;
                        if (!(declarationDescriptor instanceof ClassDescriptor)) {
                            declarationDescriptor = null;
                        }
                        if ((ClassDescriptor)declarationDescriptor != null) continue;
                        throw (Throwable)((Object)new AssertionError((Object)("Unexpected containing declaration for inner class " + innerClass + ": " + outer)));
                    }
                    return irThis;
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final ClassDescriptor getClassDescriptorForImplicitThis(@NotNull ValueDescriptor $receiver) {
            ReceiverValue receiverValue;
            if ($receiver instanceof ReceiverParameterDescriptor && (receiverValue = ((ReceiverParameterDescriptor)$receiver).getValue()) instanceof ImplicitClassReceiver) {
                return ((ImplicitClassReceiver)receiverValue).getClassDescriptor();
            }
            return null;
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        public InnerClassTransformer(@NotNull IrClass irClass) {
            Intrinsics.checkParameterIsNotNull(irClass, "irClass");
            this.irClass = irClass;
            this.classDescriptor = this.irClass.getDescriptor();
            this.oldConstructorParameterToNew = new HashMap();
        }

        @Nullable
        public static final /* synthetic */ ClassDescriptor access$getClassDescriptorForImplicitThis(InnerClassTransformer $this, @NotNull ValueDescriptor $receiver) {
            return $this.getClassDescriptorForImplicitThis($receiver);
        }
    }
}

