/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callResolverUtil;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptorImpl;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u0096\u0001\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\tH\u0002\u001a\u0013\u0010\u001a\u001a\u00070\t\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u0019\u001a\u00020\t\u001a\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\t\u001a\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\t\u001a\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020'\u001a\u000e\u0010(\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t\u001a\u0016\u0010)\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010*\u001a\u00020\t\u001a\u001e\u0010+\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\t2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u001a \u0010.\u001a\u00020\u0003*\u00020/2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u00100\u001a\u0004\u0018\u000101H\u0002\u001a\u0014\u00102\u001a\u0004\u0018\u00010\u000e*\u0002032\u0006\u00104\u001a\u000205\u001a\u0012\u00106\u001a\u00020\u001f*\u00020\u00152\u0006\u00107\u001a\u000208\u001a\u0014\u00109\u001a\u00020\u001f*\u00020\u00152\u0006\u00107\u001a\u000208H\u0002\u00a8\u0006:"}, d2={"createResolutionCandidatesForConstructors", "", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate;", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "lexicalScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "typeWithConstructors", "Lorg/jetbrains/kotlin/types/KotlinType;", "knownSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "getEffectiveExpectedType", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getErasedReceiverType", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getParameterArgumentsOfCallableType", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "type", "getReturnTypeForCallable", "Lorg/jetbrains/annotations/NotNull;", "getSuperCallExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "hasUnknownFunctionParameter", "", "hasUnknownReturnType", "isBinaryRemOperator", "isConventionCall", "isInfixCall", "isInvokeCallOnExpressionWithBothReceivers", "isInvokeCallOnVariable", "isOrOverridesSynthesized", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "replaceReturnTypeByUnknown", "replaceReturnTypeForCallable", "given", "replaceTypeArguments", "Lorg/jetbrains/kotlin/types/SimpleType;", "newArguments", "getConstructorDescriptorForResolution", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "getCorrespondingParameterForFunctionArgument", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "hasInferredReturnType", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "hasReturnTypeDependentOnUninferredParams", "kotlin-compiler"})
public final class CallResolverUtilKt {
    public static final boolean hasUnknownFunctionParameter(@NotNull KotlinType type2) {
        boolean bl;
        block2: {
            boolean bl2;
            Intrinsics.checkParameterIsNotNull(type2, "type");
            boolean bl3 = bl2 = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
            if (_Assertions.ENABLED && !bl2) {
                String string = "type " + type2 + " is not a function or property";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable $receiver$iv = CallResolverUtilKt.getParameterArgumentsOfCallableType(type2);
            for (Object element$iv : $receiver$iv) {
                TypeProjection it = (TypeProjection)element$iv;
                if (!(TypeUtilsKt.contains(it.getType(), hasUnknownFunctionParameter.2.1.INSTANCE) || ErrorUtils.containsUninferredParameter(it.getType()))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasUnknownReturnType(@NotNull KotlinType type2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean bl2 = bl = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return ErrorUtils.containsErrorType(CallResolverUtilKt.getReturnTypeForCallable(type2));
    }

    @NotNull
    public static final KotlinType replaceReturnTypeForCallable(@NotNull KotlinType type2, @NotNull KotlinType given) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(given, "given");
        boolean bl2 = bl = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList<TypeProjectionImpl> newArguments2 = Lists.newArrayList();
        newArguments2.addAll((Collection)CallResolverUtilKt.getParameterArgumentsOfCallableType(type2));
        newArguments2.add(new TypeProjectionImpl(Variance.INVARIANT, given));
        ArrayList<TypeProjectionImpl> arrayList = newArguments2;
        Intrinsics.checkExpressionValueIsNotNull(arrayList, "newArguments");
        return CallResolverUtilKt.replaceTypeArguments(type2, (List<? extends TypeProjection>)arrayList);
    }

    @NotNull
    public static final KotlinType replaceReturnTypeByUnknown(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        SimpleType simpleType2 = TypeUtils.DONT_CARE;
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "DONT_CARE");
        return CallResolverUtilKt.replaceReturnTypeForCallable(type2, simpleType2);
    }

    private static final SimpleType replaceTypeArguments(KotlinType type2, List<? extends TypeProjection> newArguments2) {
        return KotlinTypeFactory.simpleType(type2.getAnnotations(), type2.getConstructor(), newArguments2, type2.isMarkedNullable(), type2.getMemberScope());
    }

    private static final List<TypeProjection> getParameterArgumentsOfCallableType(KotlinType type2) {
        return CollectionsKt.dropLast(type2.getArguments(), 1);
    }

    @NotNull
    public static final KotlinType getReturnTypeForCallable(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return CollectionsKt.last(type2.getArguments()).getType();
    }

    private static final boolean hasReturnTypeDependentOnUninferredParams(@NotNull CallableDescriptor $receiver, ConstraintSystem constraintSystem) {
        boolean bl;
        block2: {
            KotlinType returnType;
            KotlinType kotlinType = $receiver.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType kotlinType2 = returnType = kotlinType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "returnType");
            List<TypeVariable> nestedTypeVariables = ConstraintSystemUtilsKt.getNestedTypeVariables(constraintSystem, kotlinType2);
            Iterable $receiver$iv = nestedTypeVariables;
            for (Object element$iv : $receiver$iv) {
                TypeVariable it = (TypeVariable)element$iv;
                if (!(constraintSystem.getTypeBounds(it).getValue() == null)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasInferredReturnType(@NotNull CallableDescriptor $receiver, @NotNull ConstraintSystem constraintSystem) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(constraintSystem, "constraintSystem");
        if (CallResolverUtilKt.hasReturnTypeDependentOnUninferredParams($receiver, constraintSystem)) {
            return false;
        }
        return !constraintSystem.getStatus().hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor2) {
        TypeConstructor typeConstructor2;
        Intrinsics.checkParameterIsNotNull(receiverParameterDescriptor, "receiverParameterDescriptor");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        KotlinType receiverType = receiverParameterDescriptor.getType();
        for (TypeParameterDescriptor typeParameter : descriptor2.getTypeParameters()) {
            if (!Intrinsics.areEqual(typeParameter.getTypeConstructor(), receiverType.getConstructor())) continue;
            receiverType = TypeIntersector.getUpperBoundsAsType(typeParameter);
        }
        List fakeTypeArguments = ContainerUtil.newSmartList();
        for (TypeProjection typeProjection : receiverType.getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        if (receiverType.getConstructor() instanceof IntersectionTypeConstructor) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)receiverType.getConstructor().getSupertypes();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                void supertype;
                Iterable $receiver$iv2;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection = destination$iv$iv;
                Iterable iterable2 = $receiver$iv2 = (Iterable)supertype.getArguments();
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                for (Object item$iv$iv2 : $receiver$iv$iv2) {
                    void it;
                    TypeProjection typeProjection = (TypeProjection)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(it.getProjectionKind(), TypeUtils.DONT_CARE);
                    collection2.add(typeProjectionImpl);
                }
                List fakeArguments = (List)destination$iv$iv2;
                KotlinType kotlinType2 = TypeSubstitutionKt.replace$default((KotlinType)supertype, fakeArguments, null, 2, null);
                collection.add(kotlinType2);
            }
            List superTypesWithFakeArguments = (List)destination$iv$iv;
            typeConstructor2 = new IntersectionTypeConstructor(superTypesWithFakeArguments);
        } else {
            typeConstructor2 = receiverType.getConstructor();
        }
        TypeConstructor receiverTypeConstructor = typeConstructor2;
        Annotations annotations2 = receiverType.getAnnotations();
        List list2 = fakeTypeArguments;
        Intrinsics.checkExpressionValueIsNotNull(list2, "fakeTypeArguments");
        boolean bl = receiverType.isMarkedNullable();
        MemberScope memberScope2 = ErrorUtils.createErrorScope("Error scope for erased receiver type", true);
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "ErrorUtils.createErrorSc\u2026/*throwExceptions=*/true)");
        return KotlinTypeFactory.simpleType(annotations2, receiverTypeConstructor, list2, bl, memberScope2);
    }

    public static final boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (Intrinsics.areEqual((Object)descriptor2.getKind(), (Object)CallableMemberDescriptor.Kind.SYNTHESIZED)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)descriptor2.getKind(), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) {
            boolean bl;
            block3: {
                Iterable $receiver$iv = descriptor2.getOverriddenDescriptors();
                for (Object element$iv : $receiver$iv) {
                    CallableMemberDescriptor it;
                    CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
                    if (CallResolverUtilKt.isOrOverridesSynthesized(callableMemberDescriptor)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static final boolean isBinaryRemOperator(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        KtElement ktElement = call2.getCallElement();
        if (!(ktElement instanceof KtBinaryExpression)) {
            ktElement = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktElement;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression callElement = ktBinaryExpression;
        IElementType operator = callElement.getOperationToken();
        if (!(operator instanceof KtToken)) {
            return false;
        }
        Name name2 = OperatorConventions.getNameForOperationSymbol((KtToken)operator, true, true);
        return ((ImmutableSet)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.keySet()).contains(name2);
    }

    public static final boolean isConventionCall(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        if (call2 instanceof CallTransformer.CallForImplicitInvoke) {
            return true;
        }
        KtElement callElement = call2.getCallElement();
        if (callElement instanceof KtArrayAccessExpression || callElement instanceof KtDestructuringDeclarationEntry) {
            return true;
        }
        KtExpression ktExpression = call2.getCalleeExpression();
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            ktExpression = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)ktExpression;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression calleeExpression = ktOperationReferenceExpression;
        return calleeExpression.isConventionOperator();
    }

    public static final boolean isInfixCall(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        KtExpression ktExpression = call2.getCalleeExpression();
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            ktExpression = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)ktExpression;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression operationRefExpression = ktOperationReferenceExpression;
        PsiElement psiElement = operationRefExpression.getParent();
        if (!(psiElement instanceof KtBinaryExpression)) {
            psiElement = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        return binaryExpression.getOperationReference() == operationRefExpression && operationRefExpression.getOperationSignTokenType() == null;
    }

    public static final boolean isInvokeCallOnVariable(@NotNull Call call2) {
        ReceiverValue dispatchReceiver;
        Intrinsics.checkParameterIsNotNull(call2, "call");
        if (call2.getCallType() != Call.CallType.INVOKE) {
            return false;
        }
        ReceiverValue receiverValue = dispatchReceiver = call2.getDispatchReceiver();
        if (receiverValue == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver");
        }
        KtExpression expression = ((ExpressionReceiver)receiverValue).getExpression();
        return expression instanceof KtSimpleNameExpression;
    }

    public static final boolean isInvokeCallOnExpressionWithBothReceivers(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        if (call2.getCallType() != Call.CallType.INVOKE || CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
            return false;
        }
        return call2.getExplicitReceiver() != null && call2.getDispatchReceiver() != null;
    }

    @Nullable
    public static final KtSuperExpression getSuperCallExpression(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        Receiver receiver = call2.getExplicitReceiver();
        if (!(receiver instanceof ExpressionReceiver)) {
            receiver = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiver;
        KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        if (!(ktExpression instanceof KtSuperExpression)) {
            ktExpression = null;
        }
        return (KtSuperExpression)ktExpression;
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument) {
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        if (argument.getSpreadElement() != null) {
            if (parameterDescriptor.getVarargElementType() == null) {
                SimpleType simpleType2 = TypeUtils.DONT_CARE;
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "DONT_CARE");
                return simpleType2;
            }
            KotlinType kotlinType = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameterDescriptor.type");
            return kotlinType;
        }
        KotlinType varargElementType = parameterDescriptor.getVarargElementType();
        if (varargElementType != null) {
            return varargElementType;
        }
        KotlinType kotlinType = parameterDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameterDescriptor.type");
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<ResolutionCandidate<ConstructorDescriptor>> createResolutionCandidatesForConstructors(@NotNull LexicalScope lexicalScope, @NotNull Call call2, @NotNull KotlinType typeWithConstructors, @Nullable TypeSubstitutor knownSubstitutor) {
        void $receiver$iv$iv;
        ReceiverValue dispatchReceiver;
        ExplicitReceiverKind receiverKind;
        Object substitutedOuterClassType;
        TypeAliasDescriptor typeAliasDescriptor;
        Intrinsics.checkParameterIsNotNull(lexicalScope, "lexicalScope");
        Intrinsics.checkParameterIsNotNull(call2, "call");
        Intrinsics.checkParameterIsNotNull(typeWithConstructors, "typeWithConstructors");
        ClassifierDescriptor classifierDescriptor = typeWithConstructors.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor classWithConstructors = (ClassDescriptor)classifierDescriptor;
        UnwrappedType unwrappedType = typeWithConstructors.unwrap();
        if (unwrappedType instanceof AbbreviatedType) {
            ClassifierDescriptor classifierDescriptor2 = ((AbbreviatedType)unwrappedType).getAbbreviation().getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor2 instanceof TypeAliasDescriptor)) {
                classifierDescriptor2 = null;
            }
            typeAliasDescriptor = (TypeAliasDescriptor)classifierDescriptor2;
        } else {
            typeAliasDescriptor = null;
        }
        TypeAliasDescriptor typeAliasDescriptor2 = typeAliasDescriptor;
        Collection<ClassConstructorDescriptor> constructors2 = classWithConstructors.getConstructors();
        if (constructors2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if (classWithConstructors.isInner()) {
            ClassConstructorDescriptor classConstructorDescriptor;
            block13: {
                Annotated annotated;
                DeclarationDescriptor declarationDescriptor = classWithConstructors.getContainingDeclaration();
                if (!(declarationDescriptor instanceof ClassDescriptor)) {
                    declarationDescriptor = null;
                }
                if ((annotated = (ClassDescriptor)declarationDescriptor) == null || (annotated = annotated.getDefaultType()) == null) {
                    return CollectionsKt.emptyList();
                }
                Annotated outerClassType = annotated;
                Object object = knownSubstitutor;
                if (object == null || (object = ((TypeSubstitutor)object).substitute((KotlinType)outerClassType, Variance.INVARIANT)) == null) {
                    Annotated annotated2 = outerClassType;
                    Intrinsics.checkExpressionValueIsNotNull(annotated2, "outerClassType");
                    object = (KotlinType)annotated2;
                }
                substitutedOuterClassType = object;
                Iterable $receiver$iv = ScopeUtilsKt.getImplicitReceiversHierarchy(lexicalScope);
                for (ClassConstructorDescriptor element$iv : $receiver$iv) {
                    ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)((Object)element$iv);
                    if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(it.getType(), (KotlinType)substitutedOuterClassType)) continue;
                    classConstructorDescriptor = element$iv;
                    break block13;
                }
                classConstructorDescriptor = null;
            }
            ReceiverParameterDescriptor receiverParameterDescriptor = (ReceiverParameterDescriptor)((Object)classConstructorDescriptor);
            if (receiverParameterDescriptor == null) {
                return CollectionsKt.emptyList();
            }
            ReceiverParameterDescriptor receiver = receiverParameterDescriptor;
            receiverKind = ExplicitReceiverKind.DISPATCH_RECEIVER;
            dispatchReceiver = receiver.getValue();
        } else {
            receiverKind = ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
            dispatchReceiver = null;
        }
        Iterable $receiver$iv = constructors2;
        substitutedOuterClassType = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ClassConstructorDescriptor element$iv;
            element$iv = (ClassConstructorDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            ConstructorDescriptor constructorDescriptor = CallResolverUtilKt.getConstructorDescriptorForResolution((ClassConstructorDescriptor)it, knownSubstitutor, typeAliasDescriptor2);
            ResolutionCandidate<CallableDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, (CallableDescriptor)constructorDescriptor, dispatchReceiver, receiverKind, knownSubstitutor);
            collection.add(resolutionCandidate);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Collection createResolutionCandidatesForConstructors$default(LexicalScope lexicalScope, Call call2, KotlinType kotlinType, TypeSubstitutor typeSubstitutor2, int n, Object object) {
        if ((n & 8) != 0) {
            typeSubstitutor2 = null;
        }
        return CallResolverUtilKt.createResolutionCandidatesForConstructors(lexicalScope, call2, kotlinType, typeSubstitutor2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ConstructorDescriptor getConstructorDescriptorForResolution(@NotNull ClassConstructorDescriptor $receiver, TypeSubstitutor knownSubstitutor, TypeAliasDescriptor typeAliasDescriptor) {
        ConstructorDescriptor constructorDescriptor;
        if (typeAliasDescriptor != null) {
            TypeSubstitutor typeSubstitutor2 = knownSubstitutor;
            if (typeSubstitutor2 == null) {
                TypeSubstitutor typeSubstitutor3 = TypeSubstitutor.EMPTY;
                typeSubstitutor2 = typeSubstitutor3;
                Intrinsics.checkExpressionValueIsNotNull(typeSubstitutor3, "TypeSubstitutor.EMPTY");
            }
            TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = TypeAliasConstructorDescriptorImpl.Companion.createIfAvailable(typeAliasDescriptor, $receiver, typeSubstitutor2, true);
            if (typeAliasConstructorDescriptor == null) throw (Throwable)((Object)new AssertionError((Object)("Failed to create type alias constructor with substitutor: " + knownSubstitutor)));
            constructorDescriptor = typeAliasConstructorDescriptor;
            return constructorDescriptor;
        } else {
            constructorDescriptor = $receiver;
        }
        return constructorDescriptor;
    }

    @Nullable
    public static final ValueParameterDescriptor getCorrespondingParameterForFunctionArgument(@NotNull KtLambdaExpression $receiver, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Object object = KtPsiUtil.getParentCallIfPresent($receiver);
        if (object == null || (object = CallUtilKt.getResolvedCall((KtElement)object, bindingContext)) == null) {
            return null;
        }
        Object resolvedCall2 = object;
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(resolvedCall2.getCall(), $receiver);
        if (valueArgument == null) {
            return null;
        }
        ValueArgument valueArgument2 = valueArgument;
        ArgumentMapping argumentMapping = resolvedCall2.getArgumentMapping(valueArgument2);
        if (!(argumentMapping instanceof ArgumentMatch)) {
            argumentMapping = null;
        }
        ArgumentMatch argumentMatch = (ArgumentMatch)argumentMapping;
        if (argumentMatch == null) {
            return null;
        }
        ArgumentMatch mapping2 = argumentMatch;
        return mapping2.getValueParameter();
    }
}

