/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J=\u0010\f\u001a\n \u000e*\u0004\u0018\u0001H\rH\r\"\u0004\b\u0000\u0010\r\"\u0004\b\u0001\u0010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u0002H\u000fH\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0016R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/CharValue;", "Lorg/jetbrains/kotlin/resolve/constants/IntegerValueConstant;", "", "value", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(CLorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "type", "Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/annotations/NotNull;", "getType", "()Lorg/jetbrains/kotlin/types/SimpleType;", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;", "data", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getPrintablePart", "", "c", "isPrintableUnicode", "", "toString", "kotlin-compiler"})
public final class CharValue
extends IntegerValueConstant<Character> {
    @NotNull
    private final SimpleType type;

    @Override
    @NotNull
    public SimpleType getType() {
        return this.type;
    }

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitCharValue(this, data);
    }

    @Override
    @NotNull
    public String toString() {
        String string = "\\u%04X ('%s')";
        Object[] objectArray = new Object[]{(int)((Character)this.getValue()).charValue(), this.getPrintablePart(((Character)this.getValue()).charValue())};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(this, *args)");
        return string2;
    }

    private final String getPrintablePart(char c) {
        String string;
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
        }
        if (this.isPrintableUnicode(c)) {
            String string2 = Character.toString(c);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "Character.toString(c)");
        } else {
            string = "?";
        }
        return string;
    }

    private final boolean isPrintableUnicode(char c) {
        byte t = (byte)Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    public CharValue(char value, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        super(Character.valueOf(value));
        this.type = builtIns.getCharType();
    }
}

