/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.SVGColor;
import org.apache.batik.svggen.SVGConverter;
import org.apache.batik.svggen.SVGCustomPaint;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGLinearGradient;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.apache.batik.svggen.SVGTexturePaint;

public class SVGPaint
implements SVGConverter {
    private SVGLinearGradient svgLinearGradient;
    private SVGTexturePaint svgTexturePaint;
    private SVGColor svgColor;
    private SVGCustomPaint svgCustomPaint;
    private SVGGeneratorContext generatorContext;

    public SVGPaint(SVGGeneratorContext sVGGeneratorContext) {
        this.svgLinearGradient = new SVGLinearGradient(sVGGeneratorContext);
        this.svgTexturePaint = new SVGTexturePaint(sVGGeneratorContext);
        this.svgCustomPaint = new SVGCustomPaint(sVGGeneratorContext);
        this.svgColor = new SVGColor(sVGGeneratorContext);
        this.generatorContext = sVGGeneratorContext;
    }

    @Override
    public List getDefinitionSet() {
        LinkedList linkedList = new LinkedList(this.svgLinearGradient.getDefinitionSet());
        linkedList.addAll(this.svgTexturePaint.getDefinitionSet());
        linkedList.addAll(this.svgCustomPaint.getDefinitionSet());
        linkedList.addAll(this.svgColor.getDefinitionSet());
        return linkedList;
    }

    public SVGTexturePaint getTexturePaintConverter() {
        return this.svgTexturePaint;
    }

    public SVGLinearGradient getGradientPaintConverter() {
        return this.svgLinearGradient;
    }

    public SVGCustomPaint getCustomPaintConverter() {
        return this.svgCustomPaint;
    }

    public SVGColor getColorConverter() {
        return this.svgColor;
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return this.toSVG(graphicContext.getPaint());
    }

    public SVGPaintDescriptor toSVG(Paint paint) {
        SVGPaintDescriptor sVGPaintDescriptor = this.svgCustomPaint.toSVG(paint);
        if (sVGPaintDescriptor == null) {
            if (paint instanceof Color) {
                sVGPaintDescriptor = SVGColor.toSVG((Color)paint, this.generatorContext);
            } else if (paint instanceof GradientPaint) {
                sVGPaintDescriptor = this.svgLinearGradient.toSVG((GradientPaint)paint);
            } else if (paint instanceof TexturePaint) {
                sVGPaintDescriptor = this.svgTexturePaint.toSVG((TexturePaint)paint);
            }
        }
        return sVGPaintDescriptor;
    }
}

