/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import common.JColorButton;
import dguitar.gui.ColorScheme;
import dguitar.gui.DGuitar;
import i18n.Internationalized;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class ColorPanelRhythm
extends JPanel
implements ActionListener,
Internationalized {
    private ColorScheme singleColor;
    private ColorScheme durationColors;
    private ColorScheme lastSelectedColors;
    private int typeOfColoring;
    private ButtonGroup buttonGroup;
    private JRadioButton durationChooseColors;
    private JRadioButton durationDefaultColors;
    private ButtonGroup durationDefaultOrSelected;
    private JRadioButton durationRadioButton;
    private JSeparator jSeparator1;
    private JRadioButton singleRadioButton;
    private JColorButton singleButton;
    private JColorButton[] colors = new JColorButton[8];
    private static JLabel[] durations = new JLabel[8];

    public ColorPanelRhythm() {
        this.initComponents();
        this.postInit();
        this.lastSelectedColors = null;
        this.durationColorsSetEnabled(false);
        this.durationColors = new ColorScheme();
        this.durationColorsUpdate();
        this.singleColor = new ColorScheme(Color.BLACK);
        this.singleButton.setBackground(this.singleColor.getColor());
        this.singleRadioButton.setSelected(true);
        this.typeOfColoring = 0;
        this.durationColorsSetListener(this);
    }

    private JPanel createMiniPanel(Component CompA, Component CompB) {
        JPanel miniPanel = new JPanel();
        miniPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        miniPanel.setLayout(new BorderLayout());
        miniPanel.add(CompA, "North");
        miniPanel.add(CompB, "Center");
        miniPanel.setBackground(Color.WHITE);
        return miniPanel;
    }

    private void setIcon(JLabel label, int i, Image[] imgs) {
        label.setIcon(new ImageIcon(imgs[i]));
    }

    private void postInit() {
        this.singleButton = new JColorButton();
        this.singleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPanelRhythm.this.singleButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.singleButton, gridBagConstraints);
        int i = 0;
        while (i < 8) {
            this.colors[i] = new JColorButton();
            this.colors[i].setActionCommand("" + i);
            ColorPanelRhythm.durations[i] = new JLabel();
            this.setIcon(durations[i], i, DGuitar.Notes);
            JPanel miniPanel = this.createMiniPanel(this.colors[i], durations[i]);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = i++;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)miniPanel, gridBagConstraints);
        }
    }

    private void durationDefaultOrSelectedColors() {
        boolean defaultC = this.durationColors.equals(new ColorScheme());
        if (defaultC) {
            this.durationDefaultColors.setSelected(true);
        } else {
            this.durationChooseColors.setSelected(true);
        }
        this.lastSelectedColors = this.durationColors;
        this.durationColorsSetEnabled(!defaultC);
    }

    private void durationMultipleValuesSet(boolean b) {
        this.durationColorsSetEnabled(b);
        this.singleButton.setEnabled(!b);
        this.durationDefaultColors.setEnabled(b);
        this.durationChooseColors.setEnabled(b);
        if (b) {
            this.durationDefaultOrSelectedColors();
        }
    }

    private void durationColorsSetListener(ActionListener l) {
        if (l != null) {
            int i = 0;
            while (i < 8) {
                JColorButton cbtn = this.colors[i];
                if (cbtn != null) {
                    cbtn.addActionListener(l);
                }
                ++i;
            }
        }
    }

    protected void setColors(ColorScheme ndc, int TypeOfColoring) {
        if (ndc != null) {
            ColorScheme dc = (ColorScheme)ndc.clone();
            this.typeOfColoring = TypeOfColoring;
            if (this.typeOfColoring == 0) {
                this.singleColor = dc;
                this.singleButton.setBackground(this.singleColor.getColor());
                this.singleRadioButton.setSelected(true);
            } else if (this.typeOfColoring == 1) {
                this.durationColors = dc;
                this.durationColorsUpdate();
                this.durationRadioButton.setSelected(true);
                this.durationMultipleValuesSet(true);
            }
        }
    }

    protected boolean selectionChanged() {
        return this.lastSelectedColors != null;
    }

    protected ColorScheme getColors() {
        return this.lastSelectedColors;
    }

    protected void setSingleColor(ColorScheme dc) {
        if (dc != null) {
            this.singleColor = dc;
            this.singleButton.setBackground(this.singleColor.getColor());
            this.singleRadioButton.setSelected(true);
        }
    }

    private void durationColorsUpdate() {
        int i = 0;
        while (i < 8) {
            JColorButton cbtn = this.colors[i];
            if (cbtn != null) {
                cbtn.setBackground(this.durationColors.getColor(i));
            }
            ++i;
        }
    }

    private void durationColorsSetEnabled(boolean b) {
        int i = 0;
        while (i < 8) {
            JColorButton cbtn = this.colors[i];
            if (cbtn != null) {
                cbtn.setEnabled(b);
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        JColorButton cbtn = new JColorButton();
        if (obj.getClass().isInstance(cbtn)) {
            cbtn = (JColorButton)obj;
            try {
                int val = Integer.parseInt(cbtn.getActionCommand());
                this.durationColors.setColor(cbtn.getBackground(), val);
                this.lastSelectedColors = this.durationColors;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.componentsCreate();
    }

    private void componentsCreate() {
        this.buttonGroup = new ButtonGroup();
        this.durationDefaultOrSelected = new ButtonGroup();
        this.singleRadioButton = new JRadioButton();
        this.durationRadioButton = new JRadioButton();
        this.durationDefaultColors = new JRadioButton();
        this.durationChooseColors = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.buttonGroup.add(this.singleRadioButton);
        this.singleRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPanelRhythm.this.singleRadioButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 7.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.singleRadioButton, gridBagConstraints);
        this.buttonGroup.add(this.durationRadioButton);
        this.durationRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPanelRhythm.this.durationRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 8.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.durationRadioButton, gridBagConstraints);
        this.durationDefaultOrSelected.add(this.durationDefaultColors);
        this.durationDefaultColors.setEnabled(false);
        this.durationDefaultColors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPanelRhythm.this.durationDefaultColorsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.durationDefaultColors, gridBagConstraints);
        this.durationDefaultOrSelected.add(this.durationChooseColors);
        this.durationChooseColors.setEnabled(false);
        this.durationChooseColors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorPanelRhythm.this.durationChooseColorsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.durationChooseColors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.setLangText();
    }

    public void setLangText() {
        this.singleRadioButton.setText(DGuitar.lang.getString("colorUnique"));
        this.durationRadioButton.setText(DGuitar.lang.getString("colorDuration"));
        this.durationDefaultColors.setText(DGuitar.lang.getString("colorDefault"));
        this.durationChooseColors.setText(DGuitar.lang.getString("colorSelected"));
    }

    private void singleButtonActionPerformed(ActionEvent evt) {
        Color newC = this.singleButton.getBackground();
        this.singleColor.setColor(newC);
        this.lastSelectedColors = this.singleColor;
    }

    private void durationChooseColorsActionPerformed(ActionEvent evt) {
        this.durationColorsSetEnabled(true);
    }

    private void durationDefaultColorsActionPerformed(ActionEvent evt) {
        this.durationColorsSetEnabled(false);
        this.durationColors = new ColorScheme();
        this.durationColorsUpdate();
        this.lastSelectedColors = this.durationColors;
    }

    private void durationRadioButtonActionPerformed(ActionEvent evt) {
        if (this.durationRadioButton.isSelected()) {
            this.typeOfColoring = 1;
            this.durationMultipleValuesSet(true);
        }
    }

    private void singleRadioButtonActionPerformed(ActionEvent evt) {
        if (this.singleRadioButton.isSelected()) {
            this.singleButton.setEnabled(true);
            this.durationMultipleValuesSet(false);
            Color newC = this.singleButton.getBackground();
            this.singleColor.setColor(newC);
            this.lastSelectedColors = this.singleColor;
            this.typeOfColoring = 0;
        }
    }

    public int getTypeOfColoring() {
        return this.typeOfColoring;
    }
}

