/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.config.CronScheduledFuture;
import org.apache.logging.log4j.core.util.CronExpression;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;

public class ConfigurationScheduler
extends AbstractLifeCycle {
    private static final String SIMPLE_NAME = "Log4j2 " + ConfigurationScheduler.class.getSimpleName();
    private static final int MAX_SCHEDULED_ITEMS = 5;
    private ScheduledExecutorService executorService;
    private int scheduledItems = 0;

    @Override
    public void start() {
        super.start();
        if (this.scheduledItems > 0) {
            LOGGER.debug("{} starting {} threads", (Object)this.scheduledItems, (Object)SIMPLE_NAME);
            this.scheduledItems = Math.min(this.scheduledItems, 5);
            this.executorService = new ScheduledThreadPoolExecutor(this.scheduledItems, Log4jThreadFactory.createDaemonThreadFactory("Scheduled"));
        } else {
            LOGGER.debug("{}: No scheduled items", (Object)SIMPLE_NAME);
        }
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        if (this.executorService != null) {
            LOGGER.debug("{} shutting down threads in {}", (Object)SIMPLE_NAME, (Object)this.executorService);
            this.executorService.shutdown();
        }
        this.setStopped();
        return true;
    }

    public void incrementScheduledItems() {
        if (!this.isStarted()) {
            ++this.scheduledItems;
        } else {
            LOGGER.error("{} attempted to increment scheduled items after start", (Object)SIMPLE_NAME);
        }
    }

    public void decrementScheduledItems() {
        if (!this.isStarted() && this.scheduledItems > 0) {
            --this.scheduledItems;
        }
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executorService.schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executorService.schedule(command, delay, unit);
    }

    public CronScheduledFuture<?> scheduleWithCron(CronExpression cronExpression, Runnable command) {
        Date fireDate = cronExpression.getNextValidTimeAfter(new Date());
        CronRunnable runnable = new CronRunnable(command, cronExpression);
        ScheduledFuture<?> future = this.schedule(runnable, this.nextFireInterval(fireDate), TimeUnit.MILLISECONDS);
        CronScheduledFuture cronScheduledFuture = new CronScheduledFuture(future, fireDate);
        runnable.setScheduledFuture(cronScheduledFuture);
        return cronScheduledFuture;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executorService.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executorService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public long nextFireInterval(Date fireDate) {
        return fireDate.getTime() - new Date().getTime();
    }

    public class CronRunnable
    implements Runnable {
        private final CronExpression cronExpression;
        private final Runnable runnable;
        private CronScheduledFuture<?> scheduledFuture;

        public CronRunnable(Runnable runnable, CronExpression cronExpression) {
            this.cronExpression = cronExpression;
            this.runnable = runnable;
        }

        public void setScheduledFuture(CronScheduledFuture<?> future) {
            this.scheduledFuture = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable ex) {
                LOGGER.error("{} caught error running command", (Object)SIMPLE_NAME, (Object)ex);
            }
            finally {
                Date fireDate = this.cronExpression.getNextValidTimeAfter(new Date());
                ScheduledFuture<?> future = ConfigurationScheduler.this.schedule(this, ConfigurationScheduler.this.nextFireInterval(fireDate), TimeUnit.MILLISECONDS);
                this.scheduledFuture.reset(future, fireDate);
            }
        }
    }
}

