/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class BulkRequest
extends ActionRequest
implements CompositeIndicesRequest,
WriteRequest<BulkRequest> {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(BulkRequest.class));
    private static final int REQUEST_OVERHEAD = 50;
    final List<DocWriteRequest> requests = new ArrayList<DocWriteRequest>();
    List<Object> payloads = null;
    protected TimeValue timeout = BulkShardRequest.DEFAULT_TIMEOUT;
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.NONE;
    private long sizeInBytes = 0L;

    public BulkRequest add(DocWriteRequest ... requests) {
        for (DocWriteRequest request : requests) {
            this.add(request, (Object)null);
        }
        return this;
    }

    public BulkRequest add(DocWriteRequest request) {
        return this.add(request, (Object)null);
    }

    public BulkRequest add(DocWriteRequest request, @Nullable Object payload) {
        if (request instanceof IndexRequest) {
            this.add((IndexRequest)request, payload);
        } else if (request instanceof DeleteRequest) {
            this.add((DeleteRequest)request, payload);
        } else if (request instanceof UpdateRequest) {
            this.add((UpdateRequest)request, payload);
        } else {
            throw new IllegalArgumentException("No support for request [" + request + "]");
        }
        return this;
    }

    public BulkRequest add(Iterable<DocWriteRequest> requests) {
        for (DocWriteRequest request : requests) {
            this.add(request);
        }
        return this;
    }

    public BulkRequest add(IndexRequest request) {
        return this.internalAdd(request, null);
    }

    public BulkRequest add(IndexRequest request, @Nullable Object payload) {
        return this.internalAdd(request, payload);
    }

    BulkRequest internalAdd(IndexRequest request, @Nullable Object payload) {
        Objects.requireNonNull(request, "'request' must not be null");
        this.requests.add(request);
        this.addPayload(payload);
        this.sizeInBytes += (long)((request.source() != null ? request.source().length() : 0) + 50);
        return this;
    }

    public BulkRequest add(UpdateRequest request) {
        return this.internalAdd(request, null);
    }

    public BulkRequest add(UpdateRequest request, @Nullable Object payload) {
        return this.internalAdd(request, payload);
    }

    BulkRequest internalAdd(UpdateRequest request, @Nullable Object payload) {
        Objects.requireNonNull(request, "'request' must not be null");
        this.requests.add(request);
        this.addPayload(payload);
        if (request.doc() != null) {
            this.sizeInBytes += (long)request.doc().source().length();
        }
        if (request.upsertRequest() != null) {
            this.sizeInBytes += (long)request.upsertRequest().source().length();
        }
        if (request.script() != null) {
            this.sizeInBytes += (long)(request.script().getIdOrCode().length() * 2);
        }
        return this;
    }

    public BulkRequest add(DeleteRequest request) {
        return this.add(request, (Object)null);
    }

    public BulkRequest add(DeleteRequest request, @Nullable Object payload) {
        Objects.requireNonNull(request, "'request' must not be null");
        this.requests.add(request);
        this.addPayload(payload);
        this.sizeInBytes += 50L;
        return this;
    }

    private void addPayload(Object payload) {
        if (this.payloads == null) {
            if (payload == null) {
                return;
            }
            this.payloads = new ArrayList<Object>(this.requests.size() + 10);
            for (int i = 1; i < this.requests.size(); ++i) {
                this.payloads.add(null);
            }
        }
        this.payloads.add(payload);
    }

    public List<DocWriteRequest> requests() {
        return this.requests;
    }

    @Nullable
    public List<Object> payloads() {
        return this.payloads;
    }

    public int numberOfActions() {
        return this.requests.size();
    }

    public long estimatedSizeInBytes() {
        return this.sizeInBytes;
    }

    @Deprecated
    public BulkRequest add(byte[] data, int from, int length) throws IOException {
        return this.add(data, from, length, null, null);
    }

    public BulkRequest add(byte[] data, int from, int length, XContentType xContentType) throws IOException {
        return this.add(data, from, length, null, null, xContentType);
    }

    @Deprecated
    public BulkRequest add(byte[] data, int from, int length, @Nullable String defaultIndex, @Nullable String defaultType) throws IOException {
        return this.add(new BytesArray(data, from, length), defaultIndex, defaultType);
    }

    public BulkRequest add(byte[] data, int from, int length, @Nullable String defaultIndex, @Nullable String defaultType, XContentType xContentType) throws IOException {
        return this.add((BytesReference)new BytesArray(data, from, length), defaultIndex, defaultType, xContentType);
    }

    @Deprecated
    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType) throws IOException {
        return this.add(data, defaultIndex, defaultType, null, null, null, null, null, true);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, XContentType xContentType) throws IOException {
        return this.add(data, defaultIndex, defaultType, null, null, null, null, null, true, xContentType);
    }

    @Deprecated
    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, boolean allowExplicitIndex) throws IOException {
        return this.add(data, defaultIndex, defaultType, null, null, null, null, null, allowExplicitIndex);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, boolean allowExplicitIndex, XContentType xContentType) throws IOException {
        return this.add(data, defaultIndex, defaultType, null, null, null, null, null, allowExplicitIndex, xContentType);
    }

    @Deprecated
    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable String defaultRouting, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSourceContext, @Nullable String defaultPipeline, @Nullable Object payload, boolean allowExplicitIndex) throws IOException {
        XContentType xContentType = XContentFactory.xContentType(data);
        return this.add(data, defaultIndex, defaultType, defaultRouting, defaultFields, defaultFetchSourceContext, defaultPipeline, payload, allowExplicitIndex, xContentType);
    }

    public BulkRequest add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable String defaultRouting, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSourceContext, @Nullable String defaultPipeline, @Nullable Object payload, boolean allowExplicitIndex, XContentType xContentType) throws IOException {
        int nextMarker;
        XContent xContent = xContentType.xContent();
        int line = 0;
        int from = 0;
        int length = data.length();
        byte marker = xContent.streamSeparator();
        while ((nextMarker = this.findNextMarker(marker, from, data, length)) != -1) {
            ++line;
            XContentParser parser = xContent.createParser(NamedXContentRegistry.EMPTY, data.slice(from, nextMarker - from));
            Throwable throwable = null;
            try {
                from = nextMarker + 1;
                XContentParser.Token token = parser.nextToken();
                if (token == null) continue;
                assert (token == XContentParser.Token.START_OBJECT);
                token = parser.nextToken();
                assert (token == XContentParser.Token.FIELD_NAME);
                String action = parser.currentName();
                String index = defaultIndex;
                String type = defaultType;
                String id = null;
                String routing = defaultRouting;
                String parent = null;
                FetchSourceContext fetchSourceContext = defaultFetchSourceContext;
                String[] fields = defaultFields;
                String timestamp = null;
                TimeValue ttl = null;
                String opType = null;
                long version = -3L;
                VersionType versionType = VersionType.INTERNAL;
                int retryOnConflict = 0;
                String pipeline = defaultPipeline;
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    String currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token.isValue()) {
                            if ("_index".equals(currentFieldName)) {
                                if (!allowExplicitIndex) {
                                    throw new IllegalArgumentException("explicit index in bulk is not allowed");
                                }
                                index = parser.text();
                                continue;
                            }
                            if ("_type".equals(currentFieldName)) {
                                type = parser.text();
                                continue;
                            }
                            if ("_id".equals(currentFieldName)) {
                                id = parser.text();
                                continue;
                            }
                            if ("_routing".equals(currentFieldName) || "routing".equals(currentFieldName)) {
                                routing = parser.text();
                                continue;
                            }
                            if ("_parent".equals(currentFieldName) || "parent".equals(currentFieldName)) {
                                parent = parser.text();
                                continue;
                            }
                            if ("_timestamp".equals(currentFieldName) || "timestamp".equals(currentFieldName)) {
                                DEPRECATION_LOGGER.deprecated("The [timestamp] parameter of index requests is deprecated", new Object[0]);
                                timestamp = parser.text();
                                continue;
                            }
                            if ("_ttl".equals(currentFieldName) || "ttl".equals(currentFieldName)) {
                                DEPRECATION_LOGGER.deprecated("The [ttl] parameter of index requests is deprecated", new Object[0]);
                                if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                                    ttl = TimeValue.parseTimeValue(parser.text(), null, currentFieldName);
                                    continue;
                                }
                                ttl = new TimeValue(parser.longValue());
                                continue;
                            }
                            if ("op_type".equals(currentFieldName) || "opType".equals(currentFieldName)) {
                                opType = parser.text();
                                continue;
                            }
                            if ("_version".equals(currentFieldName) || "version".equals(currentFieldName)) {
                                version = parser.longValue();
                                continue;
                            }
                            if ("_version_type".equals(currentFieldName) || "_versionType".equals(currentFieldName) || "version_type".equals(currentFieldName) || "versionType".equals(currentFieldName)) {
                                versionType = VersionType.fromString(parser.text());
                                continue;
                            }
                            if ("_retry_on_conflict".equals(currentFieldName) || "_retryOnConflict".equals(currentFieldName)) {
                                retryOnConflict = parser.intValue();
                                continue;
                            }
                            if ("pipeline".equals(currentFieldName)) {
                                pipeline = parser.text();
                                continue;
                            }
                            if ("fields".equals(currentFieldName)) {
                                throw new IllegalArgumentException("Action/metadata line [" + line + "] contains a simple value for parameter [fields] while a list is expected");
                            }
                            if ("_source".equals(currentFieldName)) {
                                fetchSourceContext = FetchSourceContext.fromXContent(parser);
                                continue;
                            }
                            throw new IllegalArgumentException("Action/metadata line [" + line + "] contains an unknown parameter [" + currentFieldName + "]");
                        }
                        if (token == XContentParser.Token.START_ARRAY) {
                            if ("fields".equals(currentFieldName)) {
                                DEPRECATION_LOGGER.deprecated("Deprecated field [fields] used, expected [_source] instead", new Object[0]);
                                List<Object> values = parser.list();
                                fields = values.toArray(new String[values.size()]);
                                continue;
                            }
                            throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected a simple value for field [" + currentFieldName + "] but found [" + (Object)((Object)token) + "]");
                        }
                        if (token == XContentParser.Token.START_OBJECT && "_source".equals(currentFieldName)) {
                            fetchSourceContext = FetchSourceContext.fromXContent(parser);
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NULL) continue;
                        throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected a simple value for field [" + currentFieldName + "] but found [" + (Object)((Object)token) + "]");
                    }
                } else if (token != XContentParser.Token.END_OBJECT) {
                    throw new IllegalArgumentException("Malformed action/metadata line [" + line + "], expected " + (Object)((Object)XContentParser.Token.START_OBJECT) + " or " + (Object)((Object)XContentParser.Token.END_OBJECT) + " but found [" + (Object)((Object)token) + "]");
                }
                if ("delete".equals(action)) {
                    this.add(new DeleteRequest(index, type, id).routing(routing).parent(parent).version(version).versionType(versionType), payload);
                    continue;
                }
                nextMarker = this.findNextMarker(marker, from, data, length);
                if (nextMarker == -1) break;
                ++line;
                if ("index".equals(action)) {
                    if (opType == null) {
                        this.internalAdd(new IndexRequest(index, type, id).routing(routing).parent(parent).timestamp(timestamp).ttl(ttl).version(version).versionType(versionType).setPipeline(pipeline).source(this.sliceTrimmingCarriageReturn(data, from, nextMarker, xContentType), xContentType), payload);
                    } else {
                        this.internalAdd(new IndexRequest(index, type, id).routing(routing).parent(parent).timestamp(timestamp).ttl(ttl).version(version).versionType(versionType).create("create".equals(opType)).setPipeline(pipeline).source(this.sliceTrimmingCarriageReturn(data, from, nextMarker, xContentType), xContentType), payload);
                    }
                } else if ("create".equals(action)) {
                    this.internalAdd(new IndexRequest(index, type, id).routing(routing).parent(parent).timestamp(timestamp).ttl(ttl).version(version).versionType(versionType).create(true).setPipeline(pipeline).source(this.sliceTrimmingCarriageReturn(data, from, nextMarker, xContentType), xContentType), payload);
                } else if ("update".equals(action)) {
                    IndexRequest doc;
                    IndexRequest upsertRequest;
                    UpdateRequest updateRequest = new UpdateRequest(index, type, id).routing(routing).parent(parent).retryOnConflict(retryOnConflict).version(version).versionType(versionType).routing(routing).parent(parent);
                    try (XContentParser sliceParser = xContent.createParser(NamedXContentRegistry.EMPTY, this.sliceTrimmingCarriageReturn(data, from, nextMarker, xContentType));){
                        updateRequest.fromXContent(sliceParser);
                    }
                    if (fetchSourceContext != null) {
                        updateRequest.fetchSource(fetchSourceContext);
                    }
                    if (fields != null) {
                        updateRequest.fields(fields);
                    }
                    if ((upsertRequest = updateRequest.upsertRequest()) != null) {
                        upsertRequest.timestamp(timestamp);
                        upsertRequest.ttl(ttl);
                        upsertRequest.version(version);
                        upsertRequest.versionType(versionType);
                    }
                    if ((doc = updateRequest.doc()) != null) {
                        doc.timestamp(timestamp);
                        doc.ttl(ttl);
                        doc.version(version);
                        doc.versionType(versionType);
                    }
                    this.internalAdd(updateRequest, payload);
                }
                from = nextMarker + 1;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (parser == null) continue;
                if (throwable != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                parser.close();
            }
        }
        return this;
    }

    private BytesReference sliceTrimmingCarriageReturn(BytesReference bytesReference, int from, int nextMarker, XContentType xContentType) {
        int length = XContentType.JSON == xContentType && bytesReference.get(nextMarker - 1) == 13 ? nextMarker - from - 1 : nextMarker - from;
        return bytesReference.slice(from, length);
    }

    public BulkRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public BulkRequest waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Override
    public BulkRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public final BulkRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public final BulkRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".timeout"));
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    private int findNextMarker(byte marker, int from, BytesReference data, int length) {
        for (int i = from; i < length; ++i) {
            if (data.get(i) != marker) continue;
            return i;
        }
        return -1;
    }

    public boolean hasIndexRequestsWithPipelines() {
        for (DocWriteRequest actionRequest : this.requests) {
            IndexRequest indexRequest;
            if (!(actionRequest instanceof IndexRequest) || !Strings.hasText((indexRequest = (IndexRequest)actionRequest).getPipeline())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (DocWriteRequest request : this.requests) {
            ActionRequestValidationException ex;
            if (((WriteRequest)((Object)request)).getRefreshPolicy() != WriteRequest.RefreshPolicy.NONE) {
                validationException = ValidateActions.addValidationError("RefreshPolicy is not supported on an item request. Set it on the BulkRequest instead.", validationException);
            }
            if ((ex = ((WriteRequest)((Object)request)).validate()) == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.requests.add(DocWriteRequest.readDocumentRequest(in));
        }
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
        this.timeout = new TimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.waitForActiveShards.writeTo(out);
        out.writeVInt(this.requests.size());
        for (DocWriteRequest request : this.requests) {
            DocWriteRequest.writeDocumentRequest(out, request);
        }
        this.refreshPolicy.writeTo(out);
        this.timeout.writeTo(out);
    }
}

