

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Defining the Layout of the File{/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Defining the Layout of the File</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="style_behavior.html">Prev</a> </td><th width="60%" align="center">Appendix C. GPSBabel XCSV Style Files</th><td width="20%" align="right"> <a accesskey="n" href="style_define.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="style_layout"></a>Defining the Layout of the File</h2></div></div></div><p>
The first few directives define the layout the physical file itself:
</p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_layout_field"></a>FIELD_DELIMITER</h3></div></div></div><p>
   The field delimiter defines the character(s) that separate the fields in 
   the rows of data inside the XCSV file.  Common field delimiters are commas 
   and tabs. (referred to as "comma separated values" and "tab separated 
   values")
</p><p>
   examples: 
</p><pre class="screen">   FIELD_DELIMITER    COMMA
   FIELD_DELIMITER    ~
</pre><p>
   The directive FIELD_DELIMITER is parsed for STYLE CONSTANTS as defined in 
   the table above.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_layout_field_enclose"></a>FIELD_ENCLOSER</h3></div></div></div><p>
   The field encloser defines the character(s) that surround the field values.
   Common field enclosers are single and double quote marks. Many styles will
   leave this directive unset. If set, it will be applied to all fields.
</p><p>
   examples: 
</p><pre class="screen">   FIELD_ENCLOSER    DOUBLEQUOTE
   FIELD_ENCLOSER    SINGLEQUOTE
</pre><p>
   The directive FIELD_ENCLOSER is parsed for STYLE CONSTANTS as defined in 
   the table above.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_layout_rec"></a>RECORD_DELIMITER</h3></div></div></div><p>
   The record delimiter defines that character(s) that separate ROWS of 
   data (FIELDS) in the XCSV file.  The most common record delimiters
   are NEWLINE and CR (carriage return).
</p><p>
   examples:
</p><pre class="screen">   RECORD_DELIMITER    NEWLINE
   RECORD_DELIMITER    |
</pre><p>
   The directive RECORD_DELIMITER is parsed for STYLE CONSTANTS as defined 
   in the table above.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_layout_badchars"></a>BADCHARS</h3></div></div></div><p>   
   Bad characters are things that should *never* be written into the XCSV
   file as data on output.  GPSBabel automatically includes any non-blank
   FIELD_DELIMITER and FIELD_ENCLOSER and RECORD_DELIMITER characters as
   BADCHARS by default.
</p><p>
   examples: 
</p><pre class="screen">  BADCHARS    COMMA
  BADCHARS    ~|
</pre><p>
   The directive BADCHARS is parsed for STYLE CONSTANTS as defined in the 
   table above.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_layout_prologue"></a>PROLOGUE</h3></div></div></div><p>
   A prologue is basically constant data that is written to the output
   file BEFORE any waypoints are processed.  PROLOGUE can be defined 
   multiple times in the style file, once for each "line" before the data 
   begins.  This is commonly used in XCSV files as a "header" row.  
</p><p>
   examples: 
</p><pre class="screen">  PROLOGUE	OziExplorer Waypoint File Version 1.1
  PROLOGUE	WGS 84
  PROLOGUE	Symbol,Name,Latitude,Longitude
</pre></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="style_layout_epilogue"></a>EPILOGUE</h3></div></div></div><p>
   An Epilogue is the same as a prologue, except this data is written at 
   the END of the file.  See the examples for PROLOGUE above.
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="style_behavior.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Styles.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="style_define.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">GPSBabel Behavior Directives </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Defining Fields Within the File</td></tr></table></div>
  
      {/literal}{/block}
  