/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.internal.artifacts.DependencyGraphNodeResult;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactsResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsLoader;
import org.gradle.api.internal.artifacts.result.DefaultResolvedArtifactResult;
import org.gradle.api.internal.artifacts.transform.ArtifactTransforms;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Factory;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphWithEdgeValues;
import org.gradle.util.CollectionUtils;

public class DefaultLenientConfiguration
implements LenientConfiguration,
VisitedArtifactSet {
    private final CacheLockingManager cacheLockingManager;
    private final ConfigurationInternal configuration;
    private final Set<UnresolvedDependency> unresolvedDependencies;
    private final VisitedArtifactsResults artifactResults;
    private final VisitedFileDependencyResults fileDependencyResults;
    private final TransientConfigurationResultsLoader transientConfigurationResultsFactory;
    private final ArtifactTransforms artifactTransforms;
    private final SelectedArtifactResults selectedArtifacts;
    private final SelectedFileDependencyResults selectedFileDependencies;

    public DefaultLenientConfiguration(ConfigurationInternal configuration, CacheLockingManager cacheLockingManager, Set<UnresolvedDependency> unresolvedDependencies, VisitedArtifactsResults artifactResults, VisitedFileDependencyResults fileDependencyResults, TransientConfigurationResultsLoader transientConfigurationResultsLoader, ArtifactTransforms artifactTransforms) {
        this.configuration = configuration;
        this.cacheLockingManager = cacheLockingManager;
        this.unresolvedDependencies = unresolvedDependencies;
        this.artifactResults = artifactResults;
        this.fileDependencyResults = fileDependencyResults;
        this.transientConfigurationResultsFactory = transientConfigurationResultsLoader;
        this.artifactTransforms = artifactTransforms;
        Transformer variantSelector = artifactTransforms.variantSelector((AttributeContainerInternal)ImmutableAttributes.EMPTY);
        this.selectedArtifacts = artifactResults.select((Spec<? super ComponentIdentifier>)Specs.satisfyAll(), variantSelector);
        this.selectedFileDependencies = fileDependencyResults.select(variantSelector);
    }

    @Override
    public SelectedArtifactSet select(final Spec<? super Dependency> dependencySpec, final AttributeContainerInternal requestedAttributes, Spec<? super ComponentIdentifier> componentSpec) {
        SelectedFileDependencyResults fileDependencyResults;
        SelectedArtifactResults artifactResults;
        if (componentSpec.equals((Object)Specs.satisfyAll()) && requestedAttributes.equals(ImmutableAttributes.EMPTY)) {
            artifactResults = this.selectedArtifacts;
            fileDependencyResults = this.selectedFileDependencies;
        } else {
            Transformer selector = this.artifactTransforms.variantSelector(requestedAttributes);
            artifactResults = this.artifactResults.select(componentSpec, selector);
            fileDependencyResults = this.fileDependencyResults.select(selector);
        }
        return new SelectedArtifactSet(){

            @Override
            public <T extends Collection<Object>> T collectBuildDependencies(T dest) {
                artifactResults.getArtifacts().collectBuildDependencies(dest);
                fileDependencyResults.getFiles().collectBuildDependencies(dest);
                return dest;
            }

            @Override
            public void visitArtifacts(ArtifactVisitor visitor) {
                DefaultLenientConfiguration.this.visitArtifacts((Spec<? super Dependency>)dependencySpec, requestedAttributes, artifactResults, fileDependencyResults, visitor);
            }

            @Override
            public <T extends Collection<? super File>> T collectFiles(T dest) throws ResolveException {
                DefaultLenientConfiguration.this.rethrowFailure();
                ResolvedFilesCollectingVisitor visitor = new ResolvedFilesCollectingVisitor(dest);
                try {
                    DefaultLenientConfiguration.this.visitArtifacts((Spec<? super Dependency>)dependencySpec, requestedAttributes, artifactResults, fileDependencyResults, visitor);
                    visitor.addArtifacts();
                }
                catch (Throwable t) {
                    visitor.failures.add(t);
                }
                if (!visitor.failures.isEmpty()) {
                    throw new ArtifactResolveException("files", DefaultLenientConfiguration.this.configuration.getPath(), DefaultLenientConfiguration.this.configuration.getDisplayName(), visitor.failures);
                }
                return dest;
            }

            @Override
            public <T extends Collection<? super ResolvedArtifactResult>> T collectArtifacts(T dest) throws ResolveException {
                DefaultLenientConfiguration.this.rethrowFailure();
                ResolvedArtifactCollectingVisitor visitor = new ResolvedArtifactCollectingVisitor(dest);
                try {
                    DefaultLenientConfiguration.this.visitArtifacts((Spec<? super Dependency>)dependencySpec, requestedAttributes, artifactResults, fileDependencyResults, visitor);
                }
                catch (Throwable t) {
                    visitor.failures.add(t);
                }
                if (!visitor.failures.isEmpty()) {
                    throw new ArtifactResolveException("artifacts", DefaultLenientConfiguration.this.configuration.getPath(), DefaultLenientConfiguration.this.configuration.getDisplayName(), visitor.failures);
                }
                return dest;
            }
        };
    }

    public boolean hasError() {
        return this.unresolvedDependencies.size() > 0;
    }

    public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
        return this.unresolvedDependencies;
    }

    public void rethrowFailure() throws ResolveException {
        if (this.hasError()) {
            ArrayList<Throwable> failures = new ArrayList<Throwable>();
            for (UnresolvedDependency unresolvedDependency : this.unresolvedDependencies) {
                failures.add(unresolvedDependency.getProblem());
            }
            throw new ResolveException(this.configuration.toString(), failures);
        }
    }

    private TransientConfigurationResults loadTransientGraphResults(SelectedArtifactResults artifactResults) {
        return this.transientConfigurationResultsFactory.create(artifactResults);
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) {
        LinkedHashSet<ResolvedDependency> matches = new LinkedHashSet<ResolvedDependency>();
        for (DependencyGraphNodeResult node : this.getFirstLevelNodes(dependencySpec)) {
            matches.add(node.getPublicView());
        }
        return matches;
    }

    private Set<DependencyGraphNodeResult> getFirstLevelNodes(Spec<? super Dependency> dependencySpec) {
        LinkedHashSet<DependencyGraphNodeResult> matches = new LinkedHashSet<DependencyGraphNodeResult>();
        TransientConfigurationResults graphResults = this.loadTransientGraphResults(this.selectedArtifacts);
        for (Map.Entry<ModuleDependency, DependencyGraphNodeResult> entry : graphResults.getFirstLevelDependencies().entrySet()) {
            if (!dependencySpec.isSatisfiedBy((Object)entry.getKey())) continue;
            matches.add(entry.getValue());
        }
        return matches;
    }

    public Set<ResolvedDependency> getAllModuleDependencies() {
        LinkedHashSet<ResolvedDependency> resolvedElements = new LinkedHashSet<ResolvedDependency>();
        LinkedList workQueue = new LinkedList();
        workQueue.addAll(this.loadTransientGraphResults(this.selectedArtifacts).getRootNode().getPublicView().getChildren());
        while (!workQueue.isEmpty()) {
            Set children;
            ResolvedDependency item = (ResolvedDependency)workQueue.removeFirst();
            if (!resolvedElements.add(item) || (children = item.getChildren()) == null) continue;
            workQueue.addAll(children);
        }
        return resolvedElements;
    }

    public Set<File> getFiles() {
        return this.getFiles((Spec<? super Dependency>)Specs.satisfyAll());
    }

    public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
        LinkedHashSet files = Sets.newLinkedHashSet();
        FilesAndArtifactCollectingVisitor visitor = new FilesAndArtifactCollectingVisitor(files);
        this.visitArtifacts(dependencySpec, (AttributeContainerInternal)ImmutableAttributes.EMPTY, this.selectedArtifacts, this.selectedFileDependencies, visitor);
        files.addAll(this.getFiles(this.filterUnresolved(visitor.artifacts)));
        return files;
    }

    public Set<ResolvedArtifact> getArtifacts() {
        return this.getArtifacts((Spec<? super Dependency>)Specs.satisfyAll());
    }

    public Set<ResolvedArtifact> getArtifacts(Spec<? super Dependency> dependencySpec) {
        ArtifactCollectingVisitor visitor = new ArtifactCollectingVisitor();
        this.visitArtifacts(dependencySpec, (AttributeContainerInternal)ImmutableAttributes.EMPTY, this.selectedArtifacts, this.selectedFileDependencies, visitor);
        return this.filterUnresolved(visitor.artifacts);
    }

    private Set<ResolvedArtifact> filterUnresolved(final Set<ResolvedArtifact> artifacts) {
        return (Set)this.cacheLockingManager.useCache((Factory)new Factory<Set<ResolvedArtifact>>(){

            public Set<ResolvedArtifact> create() {
                return CollectionUtils.filter((Set)artifacts, (Spec)new IgnoreMissingExternalArtifacts());
            }
        });
    }

    private Set<File> getFiles(final Set<ResolvedArtifact> artifacts) {
        final LinkedHashSet<File> files = new LinkedHashSet<File>();
        this.cacheLockingManager.useCache(new Runnable(){

            @Override
            public void run() {
                for (ResolvedArtifact artifact : artifacts) {
                    File depFile = artifact.getFile();
                    if (depFile == null) continue;
                    files.add(depFile);
                }
            }
        });
        return files;
    }

    private void visitArtifacts(Spec<? super Dependency> dependencySpec, AttributeContainerInternal requestedAttributes, SelectedArtifactResults artifactResults, SelectedFileDependencyResults fileDependencyResults, ArtifactVisitor visitor) {
        ArtifactVisitor transformingVisitor = this.artifactTransforms.visitor(visitor, requestedAttributes, this.configuration.getAttributesCache());
        if (dependencySpec == Specs.SATISFIES_ALL) {
            if (transformingVisitor.includeFiles()) {
                fileDependencyResults.getFiles().visit(transformingVisitor);
            }
            artifactResults.getArtifacts().visit(transformingVisitor);
            return;
        }
        if (transformingVisitor.includeFiles()) {
            for (Map.Entry<FileCollectionDependency, ResolvedArtifactSet> entry : fileDependencyResults.getFirstLevelFiles().entrySet()) {
                if (!dependencySpec.isSatisfiedBy((Object)entry.getKey())) continue;
                entry.getValue().visit(transformingVisitor);
            }
        }
        CachingDirectedGraphWalker walker = new CachingDirectedGraphWalker((DirectedGraphWithEdgeValues)new ResolvedDependencyArtifactsGraph(transformingVisitor, fileDependencyResults));
        DependencyGraphNodeResult rootNode = this.loadTransientGraphResults(artifactResults).getRootNode();
        for (DependencyGraphNodeResult node : this.getFirstLevelNodes(dependencySpec)) {
            node.getArtifactsForIncomingEdge(rootNode).visit(transformingVisitor);
            walker.add((Object[])new DependencyGraphNodeResult[]{node});
        }
        walker.findValues();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
        return this.loadTransientGraphResults(this.selectedArtifacts).getRootNode().getPublicView().getChildren();
    }

    private static class IgnoreMissingExternalArtifacts
    implements Spec<ResolvedArtifact> {
        private IgnoreMissingExternalArtifacts() {
        }

        public boolean isSatisfiedBy(ResolvedArtifact element) {
            if (this.isExternalModuleArtifact(element)) {
                try {
                    element.getFile();
                }
                catch (org.gradle.internal.resolve.ArtifactResolveException e) {
                    return false;
                }
            }
            return true;
        }

        boolean isExternalModuleArtifact(ResolvedArtifact element) {
            return element.getId().getComponentIdentifier() instanceof ModuleComponentIdentifier;
        }
    }

    private static class ResolvedDependencyArtifactsGraph
    implements DirectedGraphWithEdgeValues<DependencyGraphNodeResult, ResolvedArtifact> {
        private final ArtifactVisitor artifactsVisitor;
        private final SelectedFileDependencyResults fileDependencyResults;

        ResolvedDependencyArtifactsGraph(ArtifactVisitor artifactsVisitor, SelectedFileDependencyResults fileDependencyResults) {
            this.artifactsVisitor = artifactsVisitor;
            this.fileDependencyResults = fileDependencyResults;
        }

        public void getNodeValues(DependencyGraphNodeResult node, Collection<? super ResolvedArtifact> values, Collection<? super DependencyGraphNodeResult> connectedNodes) {
            connectedNodes.addAll(node.getOutgoingEdges());
            if (this.artifactsVisitor.includeFiles()) {
                this.fileDependencyResults.getFiles(node.getNodeId()).visit(this.artifactsVisitor);
            }
        }

        public void getEdgeValues(DependencyGraphNodeResult from, DependencyGraphNodeResult to, Collection<ResolvedArtifact> values) {
            to.getArtifactsForIncomingEdge(from).visit(this.artifactsVisitor);
        }
    }

    private static class ArtifactResolveException
    extends ResolveException {
        private final String type;
        private final String displayName;

        public ArtifactResolveException(String type, String path, String displayName, List<Throwable> failures) {
            super(path, failures);
            this.type = type;
            this.displayName = displayName;
        }

        public String getMessage() {
            return String.format("Could not resolve all %s for %s.", this.type, this.displayName);
        }
    }

    private static class FilesAndArtifactCollectingVisitor
    extends ArtifactCollectingVisitor {
        final Collection<File> files;

        FilesAndArtifactCollectingVisitor(Collection<File> files) {
            this.files = files;
        }

        @Override
        public boolean includeFiles() {
            return true;
        }

        @Override
        public void visitFiles(@Nullable ComponentIdentifier componentIdentifier, Iterable<File> files) {
            CollectionUtils.addAll(this.files, files);
        }
    }

    private static class ResolvedArtifactCollectingVisitor
    implements ArtifactVisitor {
        private final Collection<? super ResolvedArtifactResult> artifacts;
        private final Set<ComponentArtifactIdentifier> seenArtifacts = new HashSet<ComponentArtifactIdentifier>();
        private final Set<File> seenFiles = new HashSet<File>();
        private final List<Throwable> failures = new ArrayList<Throwable>();

        ResolvedArtifactCollectingVisitor(Collection<? super ResolvedArtifactResult> artifacts) {
            this.artifacts = artifacts;
        }

        @Override
        public void visitArtifact(ResolvedArtifact artifact) {
            try {
                if (this.seenArtifacts.add(artifact.getId())) {
                    File file = artifact.getFile();
                    this.artifacts.add(new DefaultResolvedArtifactResult(artifact.getId(), Artifact.class, file));
                }
            }
            catch (Throwable t) {
                this.failures.add(t);
            }
        }

        @Override
        public boolean includeFiles() {
            return true;
        }

        @Override
        public void visitFiles(@Nullable ComponentIdentifier componentIdentifier, Iterable<File> files) {
            try {
                for (File file : files) {
                    if (!this.seenFiles.add(file)) continue;
                    Object artifactIdentifier = componentIdentifier == null ? new OpaqueComponentArtifactIdentifier(file) : new ComponentFileArtifactIdentifier(componentIdentifier, file.getName());
                    this.artifacts.add(new DefaultResolvedArtifactResult((ComponentArtifactIdentifier)artifactIdentifier, (Class<? extends Artifact>)Artifact.class, file));
                }
            }
            catch (Throwable t) {
                this.failures.add(t);
            }
        }
    }

    private static class ResolvedFilesCollectingVisitor
    implements ArtifactVisitor {
        private final Collection<? super File> files;
        private final List<Throwable> failures = new ArrayList<Throwable>();
        private final Set<ResolvedArtifact> artifacts = new LinkedHashSet<ResolvedArtifact>();

        ResolvedFilesCollectingVisitor(Collection<? super File> files) {
            this.files = files;
        }

        @Override
        public void visitArtifact(ResolvedArtifact artifact) {
            this.artifacts.add(artifact);
        }

        @Override
        public boolean includeFiles() {
            return true;
        }

        @Override
        public void visitFiles(@Nullable ComponentIdentifier componentIdentifier, Iterable<File> files) {
            try {
                for (File file : files) {
                    this.files.add(file);
                }
            }
            catch (Throwable t) {
                this.failures.add(t);
            }
        }

        public void addArtifacts() {
            for (ResolvedArtifact artifact : this.artifacts) {
                try {
                    this.files.add(artifact.getFile());
                }
                catch (Throwable t) {
                    this.failures.add(t);
                }
            }
        }
    }
}

