/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.DefaultAttributeMatchingStrategy;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.ComponentAttributeMatcher;

public class DefaultAttributesSchema
implements AttributesSchemaInternal {
    private final ComponentAttributeMatcher componentAttributeMatcher;
    private final Map<Attribute<?>, AttributeMatchingStrategy<?>> strategies = Maps.newHashMap();
    private final Map<Key, List<? extends HasAttributes>> matchesCache = Maps.newHashMap();

    public DefaultAttributesSchema(ComponentAttributeMatcher componentAttributeMatcher) {
        this.componentAttributeMatcher = componentAttributeMatcher;
    }

    public <T> AttributeMatchingStrategy<T> getMatchingStrategy(Attribute<T> attribute) {
        AttributeMatchingStrategy<?> strategy = this.strategies.get(attribute);
        if (strategy == null) {
            throw new IllegalArgumentException("Unable to find matching strategy for " + attribute);
        }
        return (AttributeMatchingStrategy)Cast.uncheckedCast(strategy);
    }

    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute) {
        return this.attribute(attribute, null);
    }

    public <T> AttributeMatchingStrategy<T> attribute(Attribute<T> attribute, Action<? super AttributeMatchingStrategy<T>> configureAction) {
        AttributeMatchingStrategy strategy = (AttributeMatchingStrategy)Cast.uncheckedCast(this.strategies.get(attribute));
        if (strategy == null) {
            strategy = new DefaultAttributeMatchingStrategy();
            this.strategies.put(attribute, strategy);
        }
        if (configureAction != null) {
            configureAction.execute((Object)strategy);
        }
        return strategy;
    }

    public Set<Attribute<?>> getAttributes() {
        return this.strategies.keySet();
    }

    public boolean hasAttribute(Attribute<?> key) {
        return this.strategies.containsKey(key);
    }

    @Override
    public List<? extends HasAttributes> getMatches(AttributesSchema producerAttributeSchema, List<HasAttributes> candidates, AttributeContainer consumer) {
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        Key key = new Key(producerAttributeSchema, candidates, consumer);
        List<? extends HasAttributes> match = this.matchesCache.get(key);
        if (match == null) {
            match = this.componentAttributeMatcher.match(this, producerAttributeSchema, candidates, consumer);
            this.matchesCache.put(key, match);
        }
        return match;
    }

    @Override
    public boolean isMatching(AttributeContainer candidate, AttributeContainer target, boolean incompleteCandidate) {
        return this.componentAttributeMatcher.isMatching(this, candidate, target, incompleteCandidate);
    }

    private static class Key {
        private final AttributesSchema producerAttributeSchema;
        private final List<HasAttributes> candidates;
        private final AttributeContainer consumer;
        private final int hashCode;

        public Key(AttributesSchema producerAttributeSchema, List<HasAttributes> candidates, AttributeContainer consumer) {
            this.producerAttributeSchema = producerAttributeSchema;
            this.candidates = candidates;
            this.consumer = consumer;
            this.hashCode = this.doHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equal((Object)this.producerAttributeSchema, (Object)key.producerAttributeSchema) && Objects.equal((Object)this.consumer, (Object)key.consumer) && Objects.equal(this.candidates, key.candidates);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int doHashCode() {
            return Objects.hashCode((Object[])new Object[]{this.producerAttributeSchema, this.candidates, this.consumer});
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("producerAttributeSchema", (Object)this.producerAttributeSchema).add("candidates", this.candidates).add("consumer", (Object)this.consumer).toString();
        }
    }
}

