/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.hash.HashCode;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.changedetection.state.FileDetails;
import org.gradle.api.internal.changedetection.state.FileHashSnapshot;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.internal.nativeintegration.filesystem.FileType;

class DefaultFileDetails
implements FileDetails {
    final String path;
    final FileType type;
    private final RelativePath relativePath;
    private final boolean root;
    private final IncrementalFileSnapshot content;

    DefaultFileDetails(String path, RelativePath relativePath, FileType type, boolean root, IncrementalFileSnapshot content) {
        this.path = path;
        this.relativePath = relativePath;
        this.type = type;
        this.root = root;
        this.content = content;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.relativePath.getLastName();
    }

    public boolean isRoot() {
        return this.root;
    }

    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    public IncrementalFileSnapshot getContent() {
        return this.content;
    }

    public FileType getType() {
        return this.type;
    }

    public FileDetails withContent(HashCode contentHash) {
        return new DefaultFileDetails(this.path, this.relativePath, this.type, this.root, new FileHashSnapshot(contentHash));
    }
}

