/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.progress.LoggerProvider;
import org.gradle.internal.progress.PercentageProgressFormatter;
import org.gradle.internal.progress.ProgressFormatter;
import org.gradle.internal.progress.ProgressLoggerProvider;
import org.gradle.internal.progress.SimpleProgressFormatter;

public class BuildProgressLogger
implements LoggerProvider {
    private final ProgressLoggerProvider loggerProvider;
    private ProgressLogger buildProgress;
    private ProgressLogger configurationProgress;
    private Map<String, ProgressLogger> projectConfigurationProgress = new HashMap<String, ProgressLogger>();
    private ProgressFormatter buildProgressFormatter;
    private ProgressFormatter configurationProgressFormatter;

    public BuildProgressLogger(ProgressLoggerFactory progressLoggerFactory) {
        this(new ProgressLoggerProvider(progressLoggerFactory, BuildProgressLogger.class));
    }

    BuildProgressLogger(ProgressLoggerProvider loggerProvider) {
        this.loggerProvider = loggerProvider;
    }

    public void buildStarted() {
        this.buildProgress = this.loggerProvider.start("Initialize build", "Loading");
    }

    public void projectsLoaded(int totalProjects) {
        this.configurationProgressFormatter = new SimpleProgressFormatter(totalProjects, "projects");
        this.configurationProgress = this.loggerProvider.start("Configure projects", this.configurationProgressFormatter.getProgress());
    }

    public void graphPopulated(int totalTasks) {
        this.configurationProgress.completed();
        this.configurationProgress = null;
        this.buildProgress.completed("Task graph ready");
        this.buildProgressFormatter = new PercentageProgressFormatter("Building", totalTasks);
        this.buildProgress = this.loggerProvider.start("Execute tasks", this.buildProgressFormatter.getProgress());
    }

    public void buildFinished() {
        for (ProgressLogger l : this.projectConfigurationProgress.values()) {
            l.completed();
        }
        if (this.configurationProgress != null) {
            this.configurationProgress.completed();
        }
        this.buildProgress.completed();
        this.buildProgress = null;
        this.buildProgressFormatter = null;
        this.configurationProgress = null;
    }

    public void afterExecute() {
        this.buildProgress.progress(this.buildProgressFormatter.incrementAndGetProgress());
    }

    public void settingsEvaluated() {
        this.buildProgress.progress("Configuring");
    }

    public void beforeEvaluate(String projectPath) {
        if (this.configurationProgress != null) {
            ProgressLogger logger = this.loggerProvider.start("Configure project " + projectPath, projectPath.equals(":") ? "root project" : projectPath);
            this.projectConfigurationProgress.put(projectPath, logger);
        }
    }

    public void afterEvaluate(String projectPath) {
        if (this.configurationProgress != null) {
            ProgressLogger logger = this.projectConfigurationProgress.remove(projectPath);
            if (logger == null) {
                throw new IllegalStateException("Unexpected afterEvaluate event received without beforeEvaluate");
            }
            logger.completed();
            this.configurationProgress.progress(this.configurationProgressFormatter.incrementAndGetProgress());
        }
    }

    public ProgressLogger getLogger() {
        if (this.buildProgress == null) {
            throw new IllegalStateException("Build logger is unavailable (it hasn't started or is already completed).");
        }
        return this.buildProgress;
    }
}

